<?php
$post_type = get_post_type();
// Colorscheme
$colorscheme = get_option( 'myconianhotel_colorscheme' );
// Taxonimes
$taxonomies = get_object_taxonomies( $post_type );
// Filterable taxonomy
$taxonomy = $taxonomies[0] ?? null;
// Options
if ( 'collection' == $colorscheme ) {
	$compare = false;
	// Layout
	$entry_content_class = 'has-global-padding';
} else {
	$compare = 'accommodation' == $post_type ?: false;
	// Layout
	$entry_content_class = '';
}
// Archives's options page
$options_page = $post_type . '_archive_page';
// Related page
$archive_related_page = myconianhotel_archive_related_page( $post_type, $taxonomy, $options_page );
$has_hero_block = myconian_hotel_has_hero_block( $archive_related_page, $options_page );

$this_hotel = array();
if ( function_exists( 'myconianhotel_remote_data' ) ) {
	$this_hotel = myconianhotel_remote_data();
}

get_header( null, array(
	'has_hero_block' => $has_hero_block,
	'hotel' => $this_hotel
));
?>

<main class="wp-block-group is-layout-flow wp-block-group-is-layout-flow<?php echo $compare ? ' has-compare' : ''; ?>">
	<div class="entry-content wp-block-post-content <?php echo $entry_content_class ?>">

	<?php
	if ( $archive_related_page && 'publish' == get_post_status( $archive_related_page ) ) :
		$block_content = get_post( $archive_related_page )->post_content;
		echo do_blocks( $block_content );
	else:
		get_template_part( 'template-parts/archive', 'hero-block', array( 'options_page' => $options_page ?? null, 'taxonomy' => $taxonomy ) );
		get_template_part( 'template-parts/archive', 'free-text-block', array( 'options_page' => $options_page ?? null, 'taxonomy' => $taxonomy ) );

		get_template_part( 'theme-blocks/blocks/archive/template', '', array(
			'post_type' => $post_type,
			'colorscheme' => $colorscheme,
			'taxonomy' => $taxonomy,
			'taxonomies' => $taxonomies,
			'compare' => $compare,
			'is_related_page' => false
		));
	endif;
	?>	

</main>

<?php get_footer( null, array( 'hotel' => $this_hotel ) ); ?>
