<?php
require __DIR__.'/inc/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
	'https://github.com/beetgroove/myconian_hotels/',
	__FILE__,
	'myconianhotels'
);

//Set the branch that contains the stable release.
$myUpdateChecker->setBranch('main');

//Optional: If you're using a private repository, specify the access token like this:
$myUpdateChecker->setAuthentication('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');

// Check for mandatory plugins
if ( class_exists( 'ACF' ) ) {
	require_once __DIR__ . '/inc/theme-functions.php';  	// Additional theme functions
	require_once __DIR__ . '/inc/filters.php';              // Filters
	require_once __DIR__ . '/inc/actions.php';              // Actions
	require_once __DIR__ . '/inc/enqueue.php';              // Custom scripts and styles
	require_once __DIR__ . '/inc/custom-post-types.php';  	// Custom post types
	require_once __DIR__ . '/inc/widgets.php';				// Custom widgets
	require_once __DIR__ . '/inc/admin/admin.php';          // Admin
	require_once __DIR__ . '/theme-blocks/functions.php';   // Blocks
	require_once __DIR__ . '/inc/booking/functions.php';   // Blocks
	require_once __DIR__ . '/inc/filters/functions.php';   // Blocks
} else {
	add_action( 'template_redirect', function() {
	    if ( ! class_exists( 'ACF' ) && ! is_admin() ) {

	    	$message = 'Please contact site administrator.';

	    	if ( current_user_can('editor') || current_user_can('administrator') ) {
	    		$message = 'This theme requires the <strong>Advanced Custom Fields PRO</strong> plugin to be <a href="' . get_admin_url() . '/plugins.php">installed and activated</a>.';
	    	} 

	        wp_die(
	            '<h1>Missing Required Component</h1><p>' . $message . '</p>',
	            'Plugin Missing',
	            [ 'response' => 503 ]
	        );
	    }
	});
}

add_action( 'admin_notices', function() {
    if ( ( current_user_can('editor') || current_user_can('administrator') ) && ! class_exists( 'ACF' ) ) {
        echo '<div class="notice notice-warning"><p>This theme requires the <strong>Advanced Custom Fields PRO</strong> plugin to be installed and activated.</p></div>';
    }
} );