<!DOCTYPE html>
<html>
	<head>
		<?php
		$gtm_enable = get_option( 'myconianhotel_gtm_enable' );
		$gtm_id = trim(get_option( 'myconianhotel_gtm_id' ));

		if ( $gtm_enable && $gtm_id  ) :
			?>
		<!-- Google Tag Manager -->
		<script>
		(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
		new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
		j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
		'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
		})(window,document,'script','dataLayer','GTM-<?php echo $gtm_id; ?>');
		</script>
		<!-- End Google Tag Manager -->
			<?php
		endif;
		?>

		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">

		<?php wp_head(); ?>
	</head>

	<?php
	$colorscheme = get_option( 'myconianhotel_colorscheme' );
	$subtheme = get_option( 'myconianhotel_subtheme' );
	$menu_class = '';
	$collection_menu_class = '';
	$logo_src = get_attached_file( get_theme_mod( 'custom_logo' ) ) ?? false;
	$menu_type = get_stylesheet_directory_uri() . '/assets/img/menu-type.png';
	$show_group = true;
	$groups = $args['hotel']['groups'] ?? [];
	?>

	<body <?php body_class($subtheme ? ['myconianhotel-subtheme-' . $subtheme] : ''); ?>>
		<?php
		if ( $gtm_enable && $gtm_id  ) :
			?>
		<!-- Google Tag Manager (noscript) -->
		<noscript>
		<iframe src="https://www.googletagmanager.com/ns.html?id=GTM-<?php echo $gtm_id; ?>"
		height="0" width="0" style="display:none;visibility:hidden"></iframe>
		</noscript>
		<!-- End Google Tag Manager (noscript) -->
			<?php
		endif;


		if ( $colorscheme == 'collection' ) {
			$menu_type = get_stylesheet_directory_uri() . '/assets/img/menu-type-collection.png';
			$show_group = false;
			$collection_menu_class = 'collection-menu';		
		}

		if (is_front_page() && $colorscheme != 'collection') {
            $menu_class = 'home-menu';
        ?>
        <div class="home-spacer"></div>
        <div class="home-loader">
            <div class="loader-content">
                <div class="loader-content-container">
                    <div id="loader-content-animation">
                        <!-- <img src="<?php echo get_stylesheet_directory_uri() . '/assets/img/loader.gif' ?>"> -->
                    </div>
                </div>
            </div>
            <div class="loader-filler"></div>
        </div>
        <?php
        }
        
		?>
		<div class="wp-site-blocks">
			<?php
			if ( $args['has_hero_block'] ?? has_block( 'myconianhotel/hero' ) ) {
				$scroll_out_class = 'scrolled-out';
    		?>
    		<nav class="static-navbar <?php echo $menu_class ?>">
                <div class="static-nav-wrapper">
                    <div class="menu-static-logo">
                        <a href="<?php echo home_url() ?>">
                            <?php echo $logo_src ? myconianhotel_clean_svg_markup( $logo_src ) : ''; ?>
                        </a>
                    </div>
                    <div class="menu-open">
                        <a class="outer-link open-main-menu-static">MENU</a>
                    </div>
                </div>
            </nav>
    		<?php
			}
			else{
				$scroll_out_class = '';
			}
			?>
			
			<nav id="main-nav" class="<?php echo $scroll_out_class.' '.$menu_class.' '.$collection_menu_class ?>">
				<div class="main-nav-left">
					<div class="menu-blue-overlay has-darkblue-background-color has-background-color">
						<?php include_once __DIR__ . '/theme-blocks/blocks/animation-typo/template.php' ?>
					</div>
					<div class="left-links">
						<div class="logo">
							<a href="<?php echo home_url() ?>">
								<?php echo preg_replace('/' . preg_quote(" ", '/') . '/', "<br>", get_bloginfo( 'name' ), 1); ?>
							</a>
						</div>
						<div class="outer-menu-items">
							<?php
								wp_nav_menu( array(
								    'theme_location' => 'header-external',  // The location you registered
								    'container'      => false,              // No additional wrapping container
								    'menu_class'     => 'header-external',      // Class applied to the <ul> element
								    'fallback_cb'    => false               // No fallback if menu doesn't exist
								));
							?>
							<!-- <a class="outer-link">SPECIAL OFFERS</a> -->
							<a class="outer-link open-main-menu">MENU</a>
						</div>
					</div>
					<div class="left-content">
						<div class="left-content-wrapper">
							<?php
							wp_nav_menu( array(
							    'theme_location' => 'header-external',  // The location you registered
							    'container'      => false,              // No additional wrapping container
							    'menu_class'     => 'header-external header-external-mobile',      // Class applied to the <ul> element
							    'fallback_cb'    => false               // No fallback if menu doesn't exist
							));
							
							wp_nav_menu( array(
							    'theme_location' => 'header',  // The location you registered
							    'container'      => false,              // No additional wrapping container
							    'menu_class'     => 'main-nav-content',      // Class applied to the <ul> element
							    'fallback_cb'    => false,               // No fallback if menu doesn't exist
							    // 'walker'         => new Custom_Walker_Nav_Menu()
							));

							wp_nav_menu( array(
							    'theme_location' => 'header-extras',  // The location you registered
							    'container'      => false,              // No additional wrapping container
							    'menu_class'     => 'header-extras',      // Class applied to the <ul> element
							    'fallback_cb'    => false               // No fallback if menu doesn't exist
							));
							if ( $show_group ) {
								get_template_part( 'template-parts/affiliations', '', array(
									'groups' 		=> $args['hotel']['groups'] ?? [],
									'colorscheme' 	=> $colorscheme
								));
							}
							?>
							
						</div>
						<?php 
						$menu_location = 'header'; // Replace with your theme location
						$locations = get_nav_menu_locations(); // Get all registered theme locations

						if (isset($locations[$menu_location])) {
						    $menu_id = $locations[$menu_location]; // Get the menu ID for the specified location
						    $menu_items = wp_get_nav_menu_items($menu_id); // Fetch the menu items
						}
						?>
					</div>
				</div>
				<div class="main-nav-right">
					<div id="menu-img-container">
						<?php if ($menu_items && function_exists('get_field')): ?>
						    <?php foreach ($menu_items as $item): ?>
						        <?php $image = get_field('menu_item_image', $item); ?>
						        <?php if ($image): ?>
						            <img 
						            	class="menu-item-img"
						                src="<?php echo esc_url($image['url']); ?>" 
						                alt="<?php echo esc_attr($item->title); ?>" 
						                data-menu-item="<?php echo 'menu-item-'.esc_attr($item->ID); ?>" 
						                style="display: none;" />
						        <?php endif; ?>
						    <?php endforeach; ?>
						<?php endif; ?>
					</div>
					<div class="right-links open-book-menu">
						<a href="#"><?php _e('Book your stay', 'ambassador') ?></a>
					</div>
					<div class="right-content">
						<div id="menu-animation"></div>
						<div class="wp-block-myconianhotel-booking booking-module-container is-layout-constrained internal" style="justify-content: center;">
							<div id="booking-menu-column" class="m-0 booking-col internal" data-reserve="<?php echo get_field( 'myconianhotel_booking_platform_url', 'option' ) ?>">
								<div class="mobile-booking-header">
									<div class="logo">
										<a href="<?php echo home_url() ?>">
											<?php echo str_replace(" ", "<br>", get_bloginfo( 'name' )); ?>
										</a>
									</div>
									<div class="mobile-booking-close">
										Close
									</div>
								</div>
								<div class="booking-module-ov" data-lenis-prevent>
									
									<div class="booking-module ">
										<div class="booking-module-overlay"></div>
										<?php 
										if ( $colorscheme == 'collection' ) {
										?>
										<div class="selector hotel-selector">
											<div class="wording">Location</div>
											<div class="sel-hotel-wrapper">
												<div class="sel-date-inner-wrapper">
													<div class="hotel-wording">HOTELS & VILLAS</div>
													<div class="hotel-listing">
														<?php 
														if ( function_exists( 'get_hotels_json_feed' ) && isset( get_hotels_json_feed()->data['hotels'] )  ) {
															$booking_hotels = get_hotels_json_feed()->data['hotels'];
															foreach ( $booking_hotels as $booking_hotel) {
															?>
															<span class="booking-hotel" data-url="<?php echo $booking_hotel['hotel_booking_platform_url'] ?: get_field( 'myconianhotel_booking_platform_url', 'option' ) ?>"><?php echo $booking_hotel['title'] ?></span>
															<?php
															}
														}
														?>
													</div>
												</div>
											</div>
										</div>
										<?php
										}
										?>
										<div class="selector date-selector">
											<div class="wording">Check In & Out</div>
											<div class="sel-date-wrapper closed">
												<div class="sel-date-inner-wrapper">
													<div class="start-date"></div>
													<div class="sep-date">PLEASE SELECT DATE</div>
													<div class="end-date"></div>
												</div>
											</div>
										</div>
										<div class="selector room-selector">
											<div class="wording">Rooms</div>
											<div class="sel-room-wrapper closed">
												<div class="op-sign op-sign-minus" data-target="rooms">
												
												</div>
												<div id="rooms" class="rooms" data-val="1" data-ident="rooms">
													1
												</div>
												<div class="op-sign op-sign-plus" data-target="rooms">
												
												</div>
											</div>
										</div>
										<div class="selector guest-selector">
											<div class="wording">Guests</div>
											<div class="sel-guests-wrapper closed">
												<div class="op-sign op-sign-minus" data-target="guests">
												
												</div>
												<div id="guests" class="guests" data-val="1" data-ident="guests">
													1
												</div>
												<div class="op-sign op-sign-plus" data-target="guests">
												
												</div>
											</div>
										</div>
										<div class="view-results">
											<div class="search-icon">
												<?php 
												// echo @file_get_contents(__DIR__.'/assets/img/search-icon.svg');
												?>
											</div>
											<div class="wording">
												<a href="<?php echo get_field( 'myconianhotel_booking_platform_url', 'option' ) ?>" class="mobile-booking-redirect">BOOK NOW</a>
											</div>
										</div>
									</div>
									<div class="booking-calendar">
										<div class='prev-month'><img src='<?php echo get_stylesheet_directory_uri() . '/assets/img/arrow-small-left.png' ?>'></div><div class='next-month'><img src='<?php echo get_stylesheet_directory_uri() . '/assets/img/arrow-small-right.png' ?>'></div>
										<div id="monthContainer2" class="owl-carousel">
											<?php echo function_exists( 'displayCalendar' ) ? displayCalendar() : ''; // function_exists just for intallation proccess ?>
										</div>
									</div>
									<div class="mobile-controls">

										<div class="selector-mob">
											<div class="op-sign op-sign-minus" data-target="rooms">
												-
											</div>
											<div class="value-wrapper">
												<div class="wording">
													Rooms
												</div>
												<div id="rooms-mobile" class="value" data-val="1" data-ident="rooms">
													1
												</div>
											</div>
											<div class="op-sign op-sign-plus" data-target="rooms">
												+
											</div>
										</div>
										<div class="selector-mob">
											<div class="op-sign op-sign-minus" data-target="guests">
												-
											</div>
											<div class="value-wrapper">
												<div class="wording">
													Guests
												</div>
												<div id="guests-mobile" data-ident="guests" class="value" data-val="1">
													1
												</div>
											</div>
											<div class="op-sign op-sign-plus" data-target="guests">
												+
											</div>
										</div>
									
									</div>
								</div>
								<div class="view-results-mob">
									<div class="search-icon">
										<?php 
										// echo @file_get_contents(__DIR__.'/assets/img/search-icon.svg');
										?>
									</div>
									<div class="wording">
										<a href="<?php echo get_field( 'myconianhotel_booking_platform_url', 'option' ) ?>">
											BOOK NOW
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</nav>
	<div class="mobile-book-button">
		Book Now
	</div>
	<?php 
	if ($scroll_out_class != 'scrolled-out') {
	?>
	<div class="spacer"></div>
	<?php
	}
	?>