<?php

/**
 * Remove posts, categories and authors from SEO sitemaps 
 */

add_filter( 'wpseo_sitemap_exclude_post_type', function( $exclude, $post_type ) {
    return $post_type === 'post' ? true : $exclude;
}, 10, 2 );

add_filter( 'wpseo_sitemap_exclude_taxonomy', function( $exclude, $taxonomy ) {
    if ( in_array( $taxonomy, [ 'category', 'post_tag' ] ) ) {
        return true;
    }
    return $exclude;
}, 10, 2 );

add_filter( 'wpseo_sitemap_exclude_author', '__return_true' );