<?php

/**
 * Handle affiliations & consortiums logos styles
 */
add_action('wp_ajax_myconianhotel_handle_update_affiliation_terms', 'myconianhotel_handle_update_affiliation_terms');
function myconianhotel_handle_update_affiliation_terms() {
    check_ajax_referer('update_grouped_terms_nonce', 'security');

    if (!current_user_can('manage_categories')) {
        wp_send_json_error('Unauthorized', 403);
    }

    $terms = $_POST['terms'] ?? [];
    $taxonomy = $_POST['taxonomy'] ?? null;

    foreach ( $terms as $term ) {
        $term_id = intval ($term['term_id'] );

        if ( ! term_exists( $term_id, $taxonomy ) ) {
            continue;
        }

        // Build style
        $style = '';
        foreach ( $term['meta'] as $key => $value ) {
            if ( $value ) {
                $style .= $key . ':' . sanitize_text_field( $value ) . 'px;';
            }
        }

        if ( $style ) {
            update_term_meta( $term_id, 'myconianhotel-style', $style );
        }        
    }

    //wp_send_json_success($style);
    wp_send_json_success('Terms updated.');
}