<?php

/**
 * Appearance options page 
 *  Appearance options page render
 * 
 * Generate site logo
 * Generate lottie files
 * 
 * Set site logo
 */

/**
 * Appearance options page 
 */
add_action('admin_menu', 'myconian_appearance_page');
function myconian_appearance_page() {
    add_submenu_page(
        'themes.php', // Parent slug. 'themes.php' is the file for the "Appearance" menu.
        'Myconian Theme Options', // Page title.
        'Myconian Theme', // Menu title.
        'manage_options', // Capability required to view this menu.
        'myconianhotel-appearance-options', // Menu slug.
        'myconianhotel_appearance_options_callback' // Function to display the content of the page.
    );
}

/**
 * Appearance options page render
 */
function myconianhotel_appearance_options_callback() {
    // Check if the user has the required capability
    if (!current_user_can('manage_options')) {
        return;
    }


    // Save the settings if the form has been submitted
    if (isset($_POST['myconianhotel_appearance_options'])) {
        $force_update = isset( $_POST['myconianhotel_logotype_force_update'] );
        check_admin_referer('myconianhotel_colorscheme_nonce');

        $logotype_before_save = $force_update ? 'C' : get_option( 'myconianhotel_logotype' );
        $logotype_angle_before_save =  $force_update ? 0 : get_option( 'myconianhotel_logotype_angle' );
        $logotype_letterspacing_before_save =  $force_update ? 165 : get_option( 'myconianhotel_logotype_letterspacing' );
        $colorscheme_before_save =  get_option( 'myconianhotel_colorscheme' );

        update_option('myconianhotel_logotype', sanitize_text_field($_POST['myconianhotel_logotype']));
        update_option('myconianhotel_logotype_angle', sanitize_text_field($_POST['myconianhotel_logotype_angle']));
        update_option('myconianhotel_logotype_letterspacing', sanitize_text_field($_POST['myconianhotel_logotype_letterspacing']));
        update_option('myconianhotel_colorscheme', sanitize_text_field($_POST['myconianhotel_colorscheme']));
        update_option('myconianhotel_subtheme', sanitize_text_field($_POST['myconianhotel_subtheme']));
        update_option('myconianhotel_logotype_force_update', $force_update );

        if (
            $force_update ||
            $logotype_before_save != get_option( 'myconianhotel_logotype' ) ||
            $logotype_angle_before_save !== get_option( 'myconianhotel_logotype_angle' ) ||
            $logotype_letterspacing_before_save !== get_option( 'myconianhotel_logotype_letterspacing' ) ||
            $colorscheme_before_save !== get_option( 'myconianhotel_colorscheme' )
        ) {
            $logotype = get_option( 'myconianhotel_logotype' );
            $logotype_angle = get_option( 'myconianhotel_logotype_angle' );
            $logotype_letterspacing = get_option( 'myconianhotel_logotype_letterspacing' );
            $hotel_name = strtoupper( $logotype );
            //generateSvgLogo($logotype, $hotel_name, get_option( 'myconianhotel_colorscheme' ));
            //generateSvgLogo($logotype, $hotel_name, get_option( 'myconianhotel_colorscheme' ), '-typo');
            generateLottieFiles( $logotype_before_save, $logotype, $logotype_angle_before_save, $logotype_angle, $logotype_letterspacing_before_save, $logotype_letterspacing, $force_update );          
        }


        echo '<div class="updated"><p>Changes saved</p></div>';
        
    }

    // Get the current value of the option
    $colorscheme = get_option( 'myconianhotel_colorscheme', '' );
    $subtheme = get_option( 'myconianhotel_subtheme', '' );
    $logotype = get_option( 'myconianhotel_logotype' ) ?: (mb_substr($colorscheme,0, 1) ?: 'C'); // Logotype option -> First letter of colorscheme option -> '?'
    $logotype_angle = get_option( 'myconianhotel_logotype_angle' ) ?: 0; // Logotype option -> First letter of colorscheme option -> '?'
    $logotype_letterspacing = get_option( 'myconianhotel_logotype_letterspacing' ) ?: 165; // Logotype option -> First letter of colorscheme option -> '?'
    $logotype = strtoupper($logotype);
    
    ?>

    <div class="wrap">
        <h1><?php _e('Myconian Theme Options', 'myconianhotel'); ?></h1>
        <form method="post" action="">
            <?php wp_nonce_field('myconianhotel_colorscheme_nonce'); ?>
            <input type="hidden" name="myconianhotel_appearance_options" value="1">

            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php _e('Color Scheme', 'myconianhotel'); ?></th>
                    <td>
                        <select name="myconianhotel_colorscheme">
                            <option value="" <?php selected( $colorscheme, 'myconianhotel' ); ?>>None</option>
                            <option value="collection" <?php selected( $colorscheme, 'collection' ); ?>>Collection</option>
                            <option value="ambassador" <?php selected( $colorscheme, 'ambassador' ); ?>>Ambassador</option>
                            <option value="deos" <?php selected( $colorscheme, 'deos' ); ?>>Deos</option>
                            <option value="kyma" <?php selected( $colorscheme, 'kyma' ); ?>>Kyma</option>
                            <option value="avaton" <?php selected( $colorscheme, 'avaton' ); ?>>Avaton</option>
                            <option value="royal" <?php selected( $colorscheme, 'royal' ); ?>>Royal</option>
                            <option value="utopia" <?php selected( $colorscheme, 'utopia' ); ?>>Utopia</option>
                            <option value="imperial" <?php selected( $colorscheme, 'imperial' ); ?>>Imperial</option>
                            <option value="villa" <?php selected( $colorscheme, 'villa' ); ?>>Villa</option>
                            <option value="kove" <?php selected( $colorscheme, 'kove' ); ?>>Kove</option>
                            <option value="sunrize" <?php selected( $colorscheme, 'sunrize' ); ?>>Sunrize</option>
                            <option value="o" <?php selected( $colorscheme, 'o' ); ?>>O</option>
                            <option value="naia" <?php selected( $colorscheme, 'naia' ); ?>>Naia</option>
                            <option value="korali" <?php selected( $colorscheme, 'korali' ); ?>>Korali</option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Sub Theme', 'myconianhotel'); ?></th>
                    <td>
                        <select name="myconianhotel_subtheme">
                            <option value="" <?php selected( $subtheme, '' ); ?>>Default</option>
                            <option value="align-left" <?php selected( $subtheme, 'align-left' ); ?>>Align Left</option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Logo Type', 'myconianhotel'); ?></th>
                    <td>
                        <input type="text" name="myconianhotel_logotype" maxlength="1" value="<?php echo $logotype; ?>" style="width:2em;" oninput="this.value = this.value.toUpperCase()" />
                        <p class="description">This letter is used for Interactive Typo Block & site logo<br>To update the block, visit the corresponding page and save your changes after Attempt recovery.</p>  
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Logo Type Angle', 'myconianhotel'); ?></th>
                    <td>
                        <input type="number" name="myconianhotel_logotype_angle" min="-90" step="45" max="45" value="<?php echo $logotype_angle; ?>" style="width:5em;"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e('Logo Type Letter spacing', 'myconianhotel'); ?></th>
                    <td>
                        <input type="number" name="myconianhotel_logotype_letterspacing" min="0" step="1" value="<?php echo $logotype_letterspacing; ?>" style="width:5em;"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="myconianhotel_logotype_force_update"><?php _e('Force update', 'myconianhotel'); ?></label></th>
                    <td>
                        <input type="checkbox" id="myconianhotel_logotype_force_update" name="myconianhotel_logotype_force_update"/>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

/**
 * Generate site logo
 *  myconian-[colorscheme]-logo.svg
 *  myconian-[colorscheme]-logo-type.svg
 * 
 */
function generateSvgLogo( $logotype, $hotel_name, $colorscheme, $type = '' ){

    // TODO:
    $color = '#103B5A';
    if ( 'collection' == $colorscheme ) {
        $color = '#150101';
    }

    if ( $type == '' ) {
        if ( $colorscheme !== 'collection' ) {
            $svg =
            '<svg xmlns="http://www.w3.org/2000/svg" width="265" height="98" viewBox="0 0 265 98">
                <g transform="translate(5 5)">
                    <g  data-name="Group 1178" transform="translate(-1082 -1152)">
                        <text  transform="translate(1216 1191)" fill="#ebeae2" font-size="16" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">MYCONIAN</tspan></text>
                        <text  transform="translate(1216 1210)" fill="#ebeae2" font-size="16" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">'.$hotel_name.'</tspan></text>
                    </g>
                    <g transform="translate(-1198 -1169)">
                        <text transform="translate(1236 1181)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1274 1207) rotate(90)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1248 1245) rotate(180)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1223.485 1240) rotate(-135)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1210 1219) rotate(-90)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1234 1219)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">M</tspan></text>
                        <text transform="translate(1215 1194.485) rotate(-45)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1260.515 1186) rotate(45)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                        <text transform="translate(1269 1231.515) rotate(135)" fill="#ebeae2" font-size="17" font-family="DomaineSansText-Regular, Domaine Sans Text"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                    </g>
                </g>
            </svg>';
        }
    } else {
        $svg =
        '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 142 40">
            <text transform="translate(.2 16.7)" fill="' . $color . '" font-size="16" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">MYCONIAN</tspan></text>
            <text transform="translate(.2 35.7)" fill="' . $color . '" font-size="16" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $hotel_name . '</tspan></text>
        </svg>';        
    }

    $directory = __DIR__.'/../../assets/img/logos';
    $filename = 'myconian-' . $colorscheme . '-logo' . $type . '.svg';
    $filepath = $directory . '/' . $filename;

    if ( isset( $svg ) ) {
        // Check if file exists
        file_put_contents($filepath, $svg); // creates file

    }
    
    if ( $type == '') {
       // myconiancollection_set_site_logo( $filepath );
    }
}

/**
 * Generate lottie files
 *  menu-fast.json
 *  loader.json
 *  footer.json
 */
function generateLottieFiles( $old_letter = 'C', $new_letter = 'C', $old_angle = '0', $new_angle = '0' , $old_letterspacing = '165', $new_letterspacing = '165', $force_update = false ) {

    
    $files = [
        'menu-fast.json',
        'loader.json',
        'footer.json',
    ];

    $template_files = [
        'menu-fast-template.json', // "a":{"r":{"a":1,"k":0
        'loader-template.json', // "a":{"r":{"a":1,"k":0
        'footer-template.json' // "a":{"r":{"a":0,"k":0
    ];

    // Check if upload/lottie-files dir exists & create
    $lf_directory = ABSPATH . 'wp-content/uploads/lottie-files';
    if ( ! file_exists( $lf_directory ) ) {
        wp_mkdir_p( $lf_directory );
    }

    // Create lottie files from template files to upload/lottie-files
    $tf_directory = ABSPATH . 'wp-content/themes/myconian_hotels/assets/lottie-files';
    error_log('> ' . $old_letter . ' - ' . $new_letter . ' > ' . $force_update . "\n", 3, "$lf_directory/errors.log");
    foreach ( $files as $key => $file ) {
        $lf_filepath = $lf_directory . '/' . $file;
        // eg. wp-content/uploads/lottie-files/menu-fast.json

        if ( $force_update && file_exists( $lf_filepath ) ) {
            unlink( $lf_filepath );
        }

        // Check if file exists
        if ( ! file_exists( $lf_filepath ) ) {
            // Create the file            
            $tf_filepath = $tf_directory . '/' . $template_files[$key];
            $tf_data = @file_get_contents( $tf_filepath );
            file_put_contents($lf_filepath, $tf_data);
        }

        // Letters
        $tf_data = @file_get_contents( $lf_filepath );
        $old_letters = $old_letter.$old_letter.$old_letter.$old_letter.$old_letter.$old_letter.$old_letter.$old_letter;
        $new_letters = $new_letter.$new_letter.$new_letter.$new_letter.$new_letter.$new_letter.$new_letter.$new_letter;
        $new_data = str_replace($old_letters, $new_letters, $tf_data);
        // Angle
        $angle_data = str_replace('"a":{"r":{"a":1,"k":' . $old_angle, '"a":{"r":{"a":1,"k":' . $new_angle, $new_data);
        $angle2_data = str_replace('"a":{"r":{"a":0,"k":' . $old_angle, '"a":{"r":{"a":0,"k":' . $new_angle, $angle_data);
        // Letterspacing
        $logotypespacing_data = str_replace('"a":{"t":{"a":0,"k":' . $old_letterspacing, '"a":{"t":{"a":0,"k":' . $new_letterspacing, $angle2_data);
        // Modify
        file_put_contents($lf_filepath, $logotypespacing_data);
    }
}

/**
 * Set site logo
 */
function myconiancollection_set_site_logo( $file_path ) {
    if ( ! file_exists( $file_path ) ) {
        return new WP_Error( 'file_not_found', 'The specified logo file does not exist.' );
    }

    $filename = basename( $file_path );

    // Check if the image already exists in the media library
    $query = new WP_Query( array(
        'post_type'      => 'attachment',
        'post_status'    => 'inherit',
        'posts_per_page' => 1,
        'title'          => $filename,
        'fields'         => 'ids',
    ) );

    if ( ! empty( $query->posts ) ) {
        $attachment_id = $query->posts[0];
    } else {
        require_once ABSPATH . 'wp-admin/includes/image.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/media.php';

        $upload = wp_upload_bits( $filename, null, file_get_contents( $file_path ) );
        if ( $upload['error'] ) {
            return new WP_Error( 'upload_failed', $upload['error'] );
        }

        $attachment = array(
            'guid'           => $upload['url'],
            'post_mime_type' => wp_check_filetype( $filename )['type'],
            'post_title'     => pathinfo( $filename, PATHINFO_FILENAME ),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );
        $attachment_id = wp_insert_attachment( $attachment, $upload['file'] );
        $attach_data   = wp_generate_attachment_metadata( $attachment_id, $upload['file'] );
        wp_update_attachment_metadata( $attachment_id, $attach_data );
    }

    set_theme_mod( 'custom_logo', $attachment_id );

    return $attachment_id;
}