<?php

/**
 * Media library svg support
 * Disable wp resize for large images
 * Tiny MCE
 *  Allowed formats
 *  Paste as text always enabled
 */

/**
 * Media library svg support
 */
function allow_svg_upload($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'allow_svg_upload');

function sanitize_svg_on_upload($file) {
    if ($file['type'] === 'image/svg+xml') {
        // Load the SVG and sanitize it
        if (class_exists('DOMDocument')) {
            $svg = new DOMDocument();
            $svg->loadXML(file_get_contents($file['tmp_name']), LIBXML_NOENT | LIBXML_DTDLOAD);
            // Strip script elements and risky attributes
            foreach ($svg->getElementsByTagName('script') as $script) {
                $script->parentNode->removeChild($script);
            }
            $svg->save($file['tmp_name']);
        }
    }
    return $file;
}
add_filter('wp_handle_upload_prefilter', 'sanitize_svg_on_upload');

function fix_svg_display_in_media_library() {
    echo '<style>
        .column-title .attachment-thumbnail[src$=".svg"], .column-title img[src$=".svg"] {
            width: 100% !important;
            height: auto !important;
        }
    </style>';
}
add_action('admin_head', 'fix_svg_display_in_media_library');


/**
 * Disable wp resize for large images
 */
//add_filter( 'big_image_size_threshold', '__return_false' );

/**
 * Tiny MCE
 *  Allowed formats
 *  Paste as text always enabled
 */
add_filter('tiny_mce_before_init', 'theme_tiny_MCE');
function theme_tiny_MCE( $init ) {
    /*$init["toolbar1"] = "bold,bullist,numlist,spellchecker,link";
    $init["toolbar2"] = "";

    if ( isset( $_GET['post'] ) && 'post' == get_post_type( $_GET['post'] ) ) {        
        $init["toolbar1"] = 'formatselect,' . $init["toolbar1"];
    }*/

    $init['paste_as_text'] = true;
    return $init;
}

