<?php

/**
 * Theme settings page 
 * Theme settings page render 
 * Accomodation settings page for collection collorscheme (ACF)
 * 404 page setting at Dashboard > Settings > Reading
 */

add_action('admin_menu', function () {
    add_submenu_page(
        'options-general.php',
        'Myconian Theme',
        'Myconian Theme',
        'manage_options',
        'myconianhotel-settings-options',
        'myconianhotel_settings_options_callback'
    );
});

add_action('admin_init', function () {
    if ( get_option( 'myconianhotel_colorscheme' ) !== 'collection' ) {
        register_setting('myconianhotel_settings_group', 'myconianhotel_id');
    }
    register_setting('myconianhotel_settings_group', 'myconianhotel_gtm_id');
    register_setting('myconianhotel_settings_group', 'myconianhotel_gtm_enable');
});


function myconianhotel_settings_options_callback() {
    ?>
    <div class="wrap">
        <h1>Myconian Theme Settings</h1>
        <form method="post" action="options.php">
            <?php settings_fields('myconianhotel_settings_group'); ?>
            <?php do_settings_sections('myconianhotel_settings_group'); ?>

            <?php if ( get_option( 'myconianhotel_colorscheme' ) !== 'collection' ) : ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Hotel ID</th>
                    <td><input type="number" name="myconianhotel_id" value="<?php echo esc_attr(get_option('myconianhotel_id')); ?>" /><p class="description"><a href="https://www.myconiancollection.gr/wp-admin/edit.php?post_type=hotel" target="_blank">Hotel ID</a> is mandatory to retrieve info from Myconian Collection website.</p></td>
                </tr>
            </table>
            <?php endif; ?>

            <h2 class="title"><?php _e('Google Tag Manager', 'myconianhotel'); ?></h2>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row">GTM-XXXXXXX</th>
                    <td><input type="text" name="myconianhotel_gtm_id" maxlength="7" placeholder="XXXXXXX" value="<?php echo esc_attr(get_option('myconianhotel_gtm_id')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Enable GTM</th>
                    <td><input type="checkbox" name="myconianhotel_gtm_enable" value="1" <?php checked(1, get_option('myconianhotel_gtm_enable'), true); ?> /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>

        <hr>

        <h2>Hotels Data</h2>
        <p class="description"><ul style="list-style:disc;list-style-position:inside;"><li>Hotel's Affiliations & Consortiums</li><li>Hotels Block required data</li></ul>
            <strong>Last update: <?php echo myconianhotel_timestamp_to_date( get_option('myconianhotel_hotels_block_data')['timestamp'] ?? 0 ) ?></strong><br>
            Data older than 24 hours is automatically updated upon website visit.
        </p>
        <p class="submit">
            <button id="force-update-hotels-data" class="button button-secondary">Force Update</button>
            <span id="force-update-hotels-response"></span>
        </p>            

        <h2>Magazine Feed</h2>
        <p class="description">
            <ul style="list-style:disc;list-style-position:inside;"><li>https://www.myconiancollectionmagazine.gr feed for Magazine Block</li></ul>
            <strong>Last update: <?php echo myconianhotel_timestamp_to_date( get_option('myconianhotel_magazine_feed_block_data')['timestamp'] ?? 0 ) ?></strong><br>
            Data older than 24 hours is automatically updated upon website visit.
        </p>
        <p class="submit">
            <button id="force-update-magazine-data" class="button button-secondary">Force Update</button>
            <span id="force-update-magazine-response"></span>
        </p>
    </div>

    <script>
        handleForceUpdateButton('force-update-hotels-data', 'force-update-hotels-response', 'hotels');
        handleForceUpdateButton('force-update-magazine-data', 'force-update-magazine-response', 'magazine');

        function handleForceUpdateButton(buttonId, responseId, action) {
            const btn = document.getElementById(buttonId);
            const responseEl = document.getElementById(responseId);
            if (!btn || !responseEl) return;

            btn.addEventListener('click', function () {
                btn.disabled = true;
                btn.textContent = 'Updating...';

                fetch(ajaxurl, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({
                        action: 'myconianhotel_handle_force_update_ajax',
                        _ajax_nonce: '<?php echo wp_create_nonce("myconianhotel_force_update_nonce"); ?>',
                        update_type: action
                    })
                })
                .then(response => response.json())
                .then(data => {
                    btn.disabled = false;
                    btn.textContent = 'Run Update';
                    responseEl.textContent = data.success ? 'Update complete.' : (data.data || 'Something went wrong.');
                })
                .catch(() => {
                    btn.disabled = false;
                    btn.textContent = 'Run Update';
                    responseEl.textContent = 'AJAX request failed.';
                });
            });
        }
    </script>

    <?php
}

add_action('wp_ajax_myconianhotel_handle_force_update_ajax', 'myconianhotel_handle_force_update_ajax');

function myconianhotel_handle_force_update_ajax() {
    check_ajax_referer('myconianhotel_force_update_nonce');

    $type = sanitize_text_field($_POST['update_type'] ?? '');

    switch ($type) {
        case 'hotels':
            $result = myconianhotel_remote_data(true);
            if ($result !== false && !empty($result)) {
                wp_send_json_success();
            } else {
                wp_send_json_error('Hotel data update failed.');
            }
            break;

        case 'magazine':
            $result = myconianhotel_fetch_block_data(
                'https://www.myconiancollectionmagazine.gr/wp-json/wp/v2/posts',
                'myconianhotel_magazine_feed_block_data',
                DAY_IN_SECONDS,
                true
            );
            if ($result !== false) {
                wp_send_json_success();
            } else {
                wp_send_json_error('Magazine data update failed.');
            }
            break;

        default:
            wp_send_json_error('Invalid update type.');
            break;
    }
}

/**
 * Accomodation settings page for collection collorscheme (ACF)
 */
//if ( 'collection' == get_option( 'myconianhotel_colorscheme' ) ) {
    add_action('acf/init', function() {
        if (function_exists('acf_add_options_sub_page')) {
            acf_add_options_sub_page([
                'page_title'  => 'Accommodations Settings',
                'menu_title'  => 'Accommodations',
                'parent_slug' => 'options-general.php',
                'capability' => 'manage_options'
            ]);
        }
    });    
//}

/**
 * 404 page setting at Dashboard > Settings > Reading
 */
add_action( 'admin_init', function () {
    // Register the option to store the page ID
    register_setting( 'reading', 'myconianhotel_404_page', [
        'type'              => 'integer',
        'sanitize_callback' => 'absint',
        'default'           => 0,
    ]);

    // Add the dropdown field to the Reading Settings page
    add_settings_field(
        'myconianhotel_404_page',          // ID
        '404 Page',                    // Label
        function () {
            $selected = get_option( 'myconianhotel_404_page' );
            wp_dropdown_pages( [
                'name'              => 'myconianhotel_404_page',
                'selected'          => $selected,
                'show_option_none'  => '— Select a page —',
                'option_none_value' => '0',
            ] );
        },
        'reading'                      // Settings section
    );
} );

