<?php 

function create_gallery_post_type() {
    $labels = array(
        'name'               => 'Gallery',
        'singular_name'      => 'Gallery item',
        'menu_name'          => 'Gallery',
        'name_admin_bar'     => 'Gallery item',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Gallery item',
        'new_item'           => 'New Gallery item',
        'edit_item'          => 'Edit Gallery item',
        'view_item'          => 'View Gallery item',
        'all_items'          => 'All Gallery items',
        'search_items'       => 'Search Gallery items',
        'not_found'          => 'No gallery items found.',
        'not_found_in_trash' => 'No gallery items found in Trash.',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'gallery'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 6,
        'supports'           => array('title', 'thumbnail'),
        'menu_icon'          => 'dashicons-images-alt'
    );

    register_post_type('gallery', $args);
}
add_action('init', 'create_gallery_post_type');

function create_gallery_category_taxonomy() {
    $labels = array(
        'name'              => 'Gallery Categories',
        'singular_name'     => 'Gallery Category',
        'search_items'      => 'Search Gallery Categories',
        'all_items'         => 'All Gallery Categories',
        'parent_item'       => 'Parent Category',
        'parent_item_colon' => 'Parent Category:',
        'edit_item'         => 'Edit Gallery Category',
        'update_item'       => 'Update Gallery Category',
        'add_new_item'      => 'Add New Gallery Category',
        'new_item_name'     => 'New Gallery Category Name',
        'menu_name'         => 'Gallery Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'gallery-category'),
    );

    register_taxonomy('gallery_category', array('gallery'), $args);
}
add_action('init', 'create_gallery_category_taxonomy');


?>