<?php
/**
 * Custom post type Position
 * Default Position template
 * 
 * Add custom columns to the Position edit screen
 *  Acf fields column
 * 
 * Add the data to custom columns for the Accommodation edit screen
 */

/**
 * Custom post type Position
 */
add_action('init', 'create_position_post_type');
function create_position_post_type() {
    $labels = array(
        'name'                  => __('Positions'),
        'singular_name'         => __('Position'),
        'menu_name'             => __('Careers'),
        'name_admin_bar'        => __('Position'),
        'add_new'               => __('Add New Position'),
        'add_new_item'          => __('Add New Position'),
        'new_item'              => __('New Position'),
        'edit_item'             => __('Edit Position'),
        'view_item'             => __('View Position'),
        'all_items'             => __('All Positions'),
        'search_items'          => __('Search Positions'),
        'not_found'             => __('No Positions found.'),
        'not_found_in_trash'    => __('No Positions found in Trash.'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => true,
        'publicly_queryable'    => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'rewrite'               => array('slug' => 'positions'),
        'capability_type'       => 'post',
        'has_archive'           => true,
        'hierarchical'          => false,
        'menu_position'         => 5,
        'supports'              => array('title', 'editor', 'thumbnail', 'custom-fields', 'excerpt', 'page-attributes'), // 'page-attributes' for query order support
        'show_in_rest'          => true,  // Enables the Gutenberg editor
        'menu_icon'             => 'dashicons-universal-access'
    );

    register_post_type('position', $args);
}

/**
 * Default Position template
 */
add_filter( 'block_editor_settings_all', 'myconianhotel_add_default_block_template_for_position', 10, 2 );
function myconianhotel_add_default_block_template_for_position( $editor_settings, $post ) {
    // Apply only for new posts and a specific post type, e.g., 'post'.
    if ( $post->post ) {
        if ($post->post->post_type === 'position' && $post->post->post_status === 'auto-draft') {
            // Define the block template.
            $editor_settings['template'] = [
                ['myconianhotel/widget-text', [
                    'chosenTemplate' => 'WPForm',
                    'className' => 'is-style-sticky'
                ]],
            ];

            $editor_settings['templateLock'] = 'all';
        }        
    }
    return $editor_settings;
}

/**
 * Add custom columns to the Position edit screen
 */
add_filter( 'manage_position_posts_columns', function( $columns ) {
    $new_columns = array();

    foreach ($columns as $key => $value) {
        $new_columns[$key] = $value;

        // Insert navigation column after the Title column.
        if ('title' === $key) {
            $new_columns['post_acf_fields'] = __('Position open at', 'myconianhotel');
            ?>
            <style>
                .column-post_acf_fields ul {
                    margin: 0;
                    display: flex;
                }

                .column-post_acf_fields ul li:not(:first-child):before {
                    content: ', ';
                }
            </style>
            <?php
        }
    }

    return $new_columns;
});

/**
 * Add the data to custom columns for the Accommodation edit screen
 */
add_action( 'manage_position_posts_custom_column', function( $column, $post_id ) {
    if ($column === 'post_acf_fields') {
        $hotels = get_field( 'myconianhotel_related_hotels', $post_id );
        if ( $hotels ) {
            ?><ul><?php
            foreach ( $hotels as $id ) {
                ?><li><?php echo get_the_title( $id ) ?></li><?php
            }
            ?></ul><?php
        }
    }
}, 10, 2);