<?php

/**
 * Custom post type Restaurant
 */
add_action('init', 'create_restaurant_post_type');
function create_restaurant_post_type() {
    $labels = array(
        'name'                  => __('Restaurants'),
        'singular_name'         => __('Restaurant'),
        'menu_name'             => __('Restaurants'),
        'name_admin_bar'        => __('Restaurant'),
        'add_new'               => __('Add New'),
        'add_new_item'          => __('Add New'),
        'new_item'              => __('New Restaurant'),
        'edit_item'             => __('Edit Restaurant'),
        'view_item'             => __('View Restaurant'),
        'all_items'             => __('All Restaurants'),
        'search_items'          => __('Search Restaurants'),
        'not_found'             => __('No restaurants found.'),
        'not_found_in_trash'    => __('No restaurants found in Trash.'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => true,
        'publicly_queryable'    => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'rewrite'               => array('slug' => 'mykonos-restaurants'),
        'capability_type'       => 'post',
        'has_archive'           => true,
        'hierarchical'          => false,
        'menu_position'         => 5,
        'supports'              => array('title', 'editor', 'thumbnail', 'custom-fields', 'excerpt'),
        'show_in_rest'          => true,  // Enables the Gutenberg editor
        'menu_icon'             => 'dashicons-food'
    );

    register_post_type('restaurant', $args);
}

add_action('init', 'create_restaurant_location_taxonomy');
function create_restaurant_location_taxonomy() {
    $labels = array(
        'name'              => 'Locations',
        'singular_name'     => 'Location',
        'search_items'      => 'Search Locations',
        'all_items'         => 'All Locations',
        'parent_item'       => 'Parent Location',
        'parent_item_colon' => 'Parent Location:',
        'edit_item'         => 'Edit Location',
        'update_item'       => 'Update Location',
        'add_new_item'      => 'Add New Location',
        'new_item_name'     => 'New Location Name',
        'menu_name'         => 'Locations',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'restaurants'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('restaurant_location', array('restaurant'), $args);
}

add_action('add_meta_boxes', 'add_myconianhotel_restaurant_url_meta_box');
function add_myconianhotel_restaurant_url_meta_box() {
    add_meta_box(
        'myconianhotel_restaurant_url_meta_box',
        'Restaurant Url',
        'myconianhotel_restaurant_url_meta_box_callback',
        'restaurant',
        'side',
        'default'
    );
}

function myconianhotel_restaurant_url_meta_box_callback($post) {
    wp_nonce_field('save_myconianhotel_restaurant_url', 'myconianhotel_restaurant_url_nonce');
    $value = get_post_meta($post->ID, '_restaurant_url', true);
    echo '<input type="url" id="myconianhotel_restaurant_url" name="myconianhotel_restaurant_url" value="' . esc_attr($value) . '" style="width:100%" />';
}

add_action('save_post', 'save_myconianhotel_restaurant_url');
function save_myconianhotel_restaurant_url($post_id) {
    if (!isset($_POST['myconianhotel_restaurant_url_nonce']) || 
        !wp_verify_nonce($_POST['myconianhotel_restaurant_url_nonce'], 'save_myconianhotel_restaurant_url')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['myconianhotel_restaurant_url'])) {
        $url = sanitize_text_field($_POST['myconianhotel_restaurant_url']);
        update_post_meta($post_id, '_restaurant_url', $url);
    }
}