<?php

/**
 * Add lazy loading to all images
 */
//add_filter( 'wp_content_img_tag', 'theme_loading_lazy_images', 10, 3 );
function theme_loading_lazy_images( $filtered_image, $context, $attachment_id ) { 
    $filtered_image = str_replace( '<img ', '<img loading="lazy" ', $filtered_image ); 
    return $filtered_image;
}

add_filter('wp_nav_menu_objects', 'add_acf_image_to_menu_items', 10, 2);

function add_acf_image_to_menu_items($items, $args) {
    // Check if ACF is available
    if (!function_exists('get_field')) {
        return $items;
    }

    foreach ($items as &$item) {
        $image = get_field('menu_item_image', $item); // Fetch ACF field
        if ($image) {
            $item->image_url = $image['url']; // Add image URL to the menu item object
        }
    }
    return $items;
}