<?php
$colorscheme = $args['colorscheme'] ?? null;
?>

<?php if ( 'collection' == $colorscheme && ( current_user_can('editor') || current_user_can('administrator') ) ) {  ?>

<div id="affiliation-logos-editor" class="affiliation-logos"style="display:none">

	<div class="affiliation-logo affiliation-logo--a-myconian-collection-hotel">
		<?php echo file_get_contents(get_stylesheet_directory() . '/assets/img/a-myconian-collection-hotel-logo.svg'); ?>
	</div>

	<?php
	$groups = get_terms( array(
	    'taxonomy'   => 'group',
	    'hide_empty' => false
	));

	if ( ! empty( $groups ) ) :
		foreach ( $groups as $group ) :
			$logo = get_field( 'myconianhotel_term_logo', 'group_' . $group->term_id );
			if ( $logo ) :
				$style = ' style="' . get_term_meta( $group->term_id, 'myconianhotel-style', true ) .'"';
			?>
		<div data-id="<?php echo $group->term_id ?>" data-taxonomy="group" class="affiliation-logo affiliation-logo--<?php echo $group->slug; ?>"<?php echo $style ?>>
			<?php
			if ( $logo ) {
				echo file_get_contents( $logo );
			} 
			?>
		</div>
			<?php
			endif;
		endforeach;
	endif;

	$consortiums = get_terms( array(
	    'taxonomy'   => 'consortium',
	    'hide_empty' => false
	));

	if ( ! empty( $consortiums ) ) :
		foreach ( $consortiums as $consortium ) :
			$logo = get_field( 'myconianhotel_term_logo', 'group_' . $consortium->term_id );
			if ( $logo ) :
				$style = ' style="' . get_term_meta( $consortium->term_id, 'myconianhotel-style', true ) .'"';
			?>
		<div data-id="<?php echo $consortium->term_id ?>" data-taxonomy="consortium" class="affiliation-logo affiliation-logo--<?php echo $consortium->slug; ?> affiliation-logo--consortium"<?php echo $style ?>>
			<?php
			if ( $logo ) {
				echo file_get_contents( $logo );
			} 
			?>
		</div>
			<?php
			endif;
		endforeach;
	endif;				
	?>
</div>

<script>
(function($){
	$(document).ready(function($) {

		$('#toggle-affiliations-editor').on('click', function() {
			$('#affiliation-logos-editor').slideToggle();
		})

		$('#affiliation-logos-editor .affiliation-logo:not(.affiliation-logo--a-myconian-collection-hotel)').on('click', function(e) {
			e.preventDefault();

			if ( ! $(this).hasClass('is-active')) {
				$('.affiliation-logo').removeClass('is-active');
				$('.affiliation-logo .affiliation-logo_controls').remove();

				$(this).append(
					`<div class="affiliation-logo_controls">` +
						`<button id="close-affiliations-edit" class="mh-icon-close"></button>` +
						`<div class="label">Height</div><div class="label">Shrink</div><div class="label" style="opacity:.3;">Y</div>` +
						`<input type="number" name="affiliation-logo-height" min="20" max="100" step="1" value="${$(this).css('height').replace('px', '')}" />` +
						`<input type="number" name="affiliation-logo-margin" min="-60" max="0" step="1" value="${$(this).css('margin-left').replace('px', '')}" />` +
						`<input type="number" name="affiliation-logo-top" min="-20" max="20" step="1" value="0" disabled/>` +
						`<input id="submit-affiliations-edit" type="submit"/>` +
					`</div>`
					);			
			}

			$(this).addClass('is-active');
		});

		$('#affiliation-logos-editor .affiliation-logo').on('change', 'input[type="number"]', function(e) {	
			if ('affiliation-logo-height' == $(this).attr('name')) {
				$(this).closest('.affiliation-logo').css({height: $(this).val() + 'px'});
			} else if ('affiliation-logo-top' == $(this).attr('name')) {
				$(this).closest('.affiliation-logo').css({top: $(this).val() + 'px'});			
			} else if ('affiliation-logo-margin' == $(this).attr('name')) {
				$(this).closest('.affiliation-logo').css({marginLeft: $(this).val() + 'px', marginRight: $(this).val() + 'px'});			
			}
		});

		$('#affiliation-logos-editor').on('click', '#close-affiliations-edit', function(e) {	
			//e.stopPropagation();
			$('.affiliation-logo').removeClass('is-active');
			$('.affiliation-logo .affiliation-logo_controls').remove();
		});

	    $('#affiliation-logos-editor').on('click', '#submit-affiliations-edit', function(e) {
	        e.preventDefault();

	        const data = {
	            action: 'myconianhotel_handle_update_affiliation_terms',
	            security: '<?php echo wp_create_nonce('update_grouped_terms_nonce'); ?>',
	            taxonomy: $(this).closest('[data-taxonomy]').data('taxonomy'),
	            terms: [
	                {
	                    term_id: $(this).closest('[data-id]').data('id'),
	                    meta: {
	                        height: $('[name="affiliation-logo-height"]').val(),
	                        top: $('[name="affiliation-logo-top"]').val(),
	                        'margin-left': $('[name="affiliation-logo-margin"]').val(),
	                        'margin-right': $('[name="affiliation-logo-margin"]').val()
	                    }
	                }
	            ]
	        };

	        $.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function(response) {
	            if (response.success) {
	                console.log('Terms updated successfully.');
	                console.log(response);
	            } else {
	                console.error('Error:', response.data);
	            }
	        });
	    });		
	});
})(jQuery);
</script>

<?php } ?>