<?php
$groups = $args['groups'] ?? [];
$consortiums = $args['consortiums'] ?? [];
$colorscheme = $args['colorscheme'] ?? null;
?>

<div class="affiliation-logos">
<?php 
if ( 'collection' == $colorscheme ) :

	$groups = get_terms( array(
	    'taxonomy'   => 'group',
	    'hide_empty' => false
	));

	if ( ! empty( $groups ) ) :
		foreach ( $groups as $group ) :
			$logo = get_field( 'myconianhotel_term_logo', 'group_' . $group->term_id );
			if ( $logo ) :
				$style = ' style="' . get_term_meta( $group->term_id, 'myconianhotel-style', true ) .'"';
				?>
		<div class="affiliation-logo affiliation-logo--<?php echo $group->slug; ?>"<?php echo $style ?>>
			<?php
			if ( $logo ) {
				echo file_get_contents( $logo );
			} 
			?>
		</div>
			<?php
			endif;
		endforeach;
	endif;

else:
	?>

	<a href="https://www.myconiancollection.gr/" target="_blank" class="affiliation-logo affiliation-logo--myconian-collection">
		<?php echo file_get_contents(get_stylesheet_directory() . '/assets/img/a-myconian-collection-hotel-logo.svg'); ?>
	</a>

	<?php
	if ( ! empty( $groups ) ) :
		foreach ( $groups as $group ) :
			if ( $group['logo'] ) :
				$link_parts = preg_split('@/@', $group['link'], -1, PREG_SPLIT_NO_EMPTY);
				$slug = $link_parts ? array_pop( $link_parts ) : null;
				$style = ' style="' . $group['style'] .'"';
				?>
		<div class="affiliation-logo<?php echo $slug ? ' affiliation-logo--' . $slug : '' ?>"<?php echo $style ?>>
			<?php echo file_get_contents( $group['logo'] ); ?>
		</div>
				<?php
			endif;
		endforeach;
	endif;

	if ( ! empty( $consortiums ) ) :
		foreach ( $consortiums as $consortium ) :
			if ( $consortium['logo'] ) :
				$link_parts = preg_split('@/@', $consortium['link'], -1, PREG_SPLIT_NO_EMPTY);
				$slug = $link_parts ? array_pop( $link_parts ) : null;
				$style = ' style="' . $consortium['style'] .'"';
				?>
		<div class="affiliation-logo<?php echo $slug ? ' affiliation-logo--' . $slug : '' ?>"<?php echo $style ?>>
			<?php echo file_get_contents( $consortium['logo'] ); ?>
		</div>
				<?php
			endif;
		endforeach;
	endif;

endif;					
if ( 'collection' == $colorscheme && ( current_user_can('editor') || current_user_can('administrator') ) ) :
	?>
	<button id="toggle-affiliations-editor" class="myconianhotel-fontend-edit-btn"><span class="dashicons dashicons-edit-large"></span></button>
	<?php
endif;
?>
</div>