<?php

// TODO: merge with blocks/post-terms/template.php

$the_terms = $args['the_terms'] ?? null;
$post_type = $args['post_type'] ?? null;
$taxonomy = $args['taxonomy'] ?? null;
$queried_object = get_queried_object();

// Hotels only
$the_groups = get_the_terms( $post->ID, 'group' );
// Resturants only
$hotels = get_field( 'myconianhotel_related_hotels', $post->ID );

$breadcrumb_base = '';
if ( is_single() ) {
    $archive_url = get_post_type_archive_link( $post_type );
    if ( $archive_url ) {
        $post_type_object = get_post_type_object( $post_type );
        $archive_name = $post_type_object->labels->name; // Get archive name (e.g., "Accommodations")	        
        $breadcrumb_base = '<li><a href="' . esc_url($archive_url) . '">' . esc_html($archive_name) . '</a></li>';
    }
}

$contition_1 = ( ( is_archive() && ! is_tax() ) || is_single() ) && $the_terms && ! is_wp_error( $the_terms );
$contition_2 = is_archive() && $the_groups && ! is_wp_error( $the_groups );
$contition_3 = is_archive() && $hotels;

if ( $contition_1 || $contition_2 ) :
	?>

<div class="wp-block-myconianhotel-post-terms wp-block is-layout-flex">							

	<?php
	if ( $contition_1 ) :
		?>
		<ul class="breadcrumb">
			<?php echo $breadcrumb_base; ?>
			<li>
				<?php
				if ( is_tax() && $queried_object->slug == $the_terms[0]->slug) :
					echo $the_terms[0]->name;
				else :
					?>
				<a href="<?php echo get_term_link( $the_terms[0]->term_id, $taxonomy );?>">
					<?php echo $the_terms[0]->name; ?>						
				</a>
					<?php
				endif;
				?>
			</li>
		</ul>
		<?php
	endif;

	if ( $contition_2 ) :
		?>
		<ul>
		<?php
		foreach ( $the_groups as $group ) :
			?>
			<li><a href="<?php echo get_term_link( $group->term_id, 'group' ); ?>" class="has-uppercase-text-transform"><?php echo $group->name; ?></a></li>
			<?php
		endforeach;
		?>
	</ul>	
		<?php
	endif;

	if ( $contition_3 ) :
		?>
		<ul>
		<?php
		foreach ( $hotels as $hotel_id ) :
			?>
			<li><a href="<?php echo get_post_meta( $hotel_id, '_hotel_url', true ); ?>" class="has-uppercase-text-transform" target="_blank"><?php echo get_the_title( $hotel_id ); ?></a></li>
			<?php
		endforeach;
		?>
	</ul>	
		<?php
	endif;
	?>

</div>

	<?php
endif;