const { unregisterBlockStyle } = wp.blocks;

wp.domReady(() => {
    //console.log(wp.blocks.getBlockType('core/quote').styles);
    unregisterBlockStyle('core/quote', 'plain');
    // Unregister the 'fill' and 'outline' styles for the core/button block
    wp.blocks.unregisterBlockStyle( 'core/button', 'fill' );
    wp.blocks.unregisterBlockStyle( 'core/button', 'outline' );
});

const { subscribe } = wp.data;

const monitorBlockFocus = () => {
    const { getSelectedBlockClientId, getBlockName } = wp.data.select('core/block-editor');

    subscribe(() => {
        /*const selectedBlockClientId = getSelectedBlockClientId();
        
        const elements = document.querySelectorAll('.editor-block-list-item-paragraph, .editor-block-list-item-heading, .editor-block-list-item-list, .editor-block-list-item-list-item, .editor-block-list-item-quote');
        elements.forEach(element => {
            element.setAttribute('disabled', 'disabled');
        });

        if (selectedBlockClientId) {
            const selectedBlockName = getBlockName(selectedBlockClientId);
            //console.log(elements);

            if (selectedBlockName === 'myconianhotel/free-text') {
                elements.forEach(element => {
                    element.removeAttribute('disabled');
                });
            } else {
              elements.forEach(element => {
                  element.setAttribute('disabled', 'disabled');
              });
            }
        }*/
    });
};

// Call the function when the editor is loaded
window.addEventListener('DOMContentLoaded', monitorBlockFocus);

/**
 * core/file
 * display setting always off
 * show download button setting always off
 */

const { addFilter } = wp.hooks;

addFilter(
    'blocks.registerBlockType',
    'myconianhotel/core-file-disable-options',
    (settings, name) => {
        if (name === 'core/file') {
            // Remove the attributes
            //console.log(settings);
            if (settings.attributes) {
                delete settings.attributes.displayPreview;
                delete settings.attributes.showDownloadButton;
            }

            // Optionally hide controls in the editor UI
            if (settings.edit) {
                const originalEdit = settings.edit;
                settings.edit = (props) => {
                    // Just strip the attributes from props so controls don’t show
                    delete props.attributes.displayPreview;
                    delete props.attributes.showDownloadButton;
                    return originalEdit(props);
                };
            }
        }
        return settings;
    }
);

/**
 * core/file target setting always blank
 */

const { createHigherOrderComponent } = wp.compose;

addFilter(
    'editor.BlockEdit',
    'myconianhotel/core-file-force-textLinkTarget-blank',
    createHigherOrderComponent((BlockEdit) => {
        return (props) => {
            if (props.name === 'core/file') {
                if (props.attributes.textLinkTarget !== '_blank') {
                    props.setAttributes({ textLinkTarget: '_blank' });
                }
            }
            return <BlockEdit {...props} />;
        };
    }, 'withForcedBlankTarget')
);