import { AmbientAnimation } from './components';
// https://chatgpt.com/c/670cdce5-e42c-8003-a2f6-331a2a3b6834

const { __ } = wp.i18n;

const { registerBlockType } = wp.blocks;
import { CustomPanelColorSettings, IconSet } from '../../modules';
const { useBlockProps, InspectorControls, useSetting, BlockControls } = wp.blockEditor;
const { ToolbarGroup, ToolbarButton } = wp.components;
const { useEffect, Fragment } = wp.element;

// SVG Icons
const alignPullBottomIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect fill="#000000" x="5" y="3" width="10" height="2"/>
        <rect fill="#000000" x="3" y="11" width="14" height="6"/>
        <rect fill="#000000" x="5" y="7" width="10" height="2"/>
    </svg>
);    

const alignPullTopIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect x="5" y="11" width="10" height="2"/>
        <rect x="3" y="3" width="14" height="6"/>
        <rect x="5" y="15" width="10" height="2"/>
    </svg>
);   

registerBlockType( 'myconianhotel/animation-typo', {
    apiVersion: 2,
    title: 'Animation Typo',
    icon: IconSet.animationTypo,
    category: 'widgets',
    attributes: {
        backgroundColor: {
            type: 'string'
        },
        mediaPosition: {
            type: 'string'
        }
    },
    edit: ( props ) => {
        const {attributes, setAttributes} = props;
        const {backgroundColor, color, mediaPosition} = attributes;
        const defaultBackgroundSlug = useSetting('custom.animationTypoBlockDefaultBackgroundSlug');

        useEffect(() => {
            if (! backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, []);

        const blockProps = useBlockProps({
            className: [
                'wp-block alignfull',                
                backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '', // Color class
                mediaPosition ? `has-animation-on-the-${mediaPosition}` : ''
            ].filter(Boolean).join(' ')
        });

        return (
            <Fragment>
                <BlockControls>
                    <ToolbarGroup>
                        <ToolbarButton
                            icon={alignPullTopIcon}
                            label={__('Show media on top')}
                            isActive={mediaPosition === 'top'}
                            onClick={() => setAttributes({ mediaPosition: 'top' })}
                        />
                        <ToolbarButton
                            icon={alignPullBottomIcon}
                            label={__('Show media on bottom')}
                            isActive={mediaPosition === 'bottom'}
                            onClick={() =>  {setAttributes({ mediaPosition: 'bottom'});}}
                        /> 
                    </ToolbarGroup>
                </BlockControls>
                <InspectorControls>
                    <CustomPanelColorSettings
                        setAttributes={setAttributes}
                        backgroundColor={backgroundColor}
                        palette={'collection' == myconianhotelBlockAnimationTypo.colorscheme ? ['lightergray', 'white'] : ['darkblue', 'lightbrown', 'darkgray', 'lightergray'] }
                    />
                </InspectorControls>

            	<div {...blockProps}>
                	<AmbientAnimation attributes={attributes}/>
                </div>
            </Fragment>
        );
    },

    save: ( props ) => {
        const {attributes} = props;
        const {backgroundColor, mediaPosition} = attributes;
                
        const blockProps = useBlockProps.save({
            className: [
                'wp-block alignfull',                
                backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '', // Color class
                mediaPosition ? `has-animation-on-the-${mediaPosition}` : ''
            ].filter(Boolean).join(' ')
        });

        return (
        	<div {...blockProps}>
            	<AmbientAnimation attributes={attributes}/>
            </div>
        );
    },
});