<?php
$is_related_page 	= $args['is_related_page'] ?? true;
$post_type 			= $args['post_type'] ?? get_post_type();
$colorscheme 		= $args['colorscheme'] ?? get_option( 'myconianhotel_colorscheme' );
$taxonomies 		= $args['taxonomies'] ?? get_object_taxonomies( $post_type );
$taxonomy 			= $args['taxonomy'] ?? ( $taxonomies[0] ?? null );
$compare 			= $args['compare'] ?? ( 'accommodation' == $post_type ?: false );
$options_page 		= $post_type . '_archive_page';
$all_text 			= get_field( 'myconianhotel_free_text_block', $options_page )['text'] ?? '';

// Options
if ( 'collection' == $colorscheme ) {
	// Layout
	$archive_class = 'wp-block-columns alignfull is-layout-flex has-default-background-color has-background';
	$post_class = 'wp-block-column';
	$fix = '';
} else {
	// Layout
	$archive_class = 'has-global-padding is-layout-constrained';
	$post_class = 'wp-block-myconianhotel-group wp-block-group is-layout-constrained alignfull has-global-padding';
	$fix = '<div class="wp-block-myconianhotel-archive__fix"></div>'; // Resolves changing posts order on filtering bug
}
$filters = array();
$filters_and_compare = array();
// Filterable Taxonomy
$terms = get_terms( array(
    'taxonomy' => $taxonomy,
    'hide_empty' => true,
));

$logo_src = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ), 'full' )[0] ?? false;

?>

<div class="wp-block-myconianhotel-archive <?php echo $archive_class ?> <?php echo $fix ? 'has-fix' : '' ?>">			
	<?php if ( ! is_tax() ) : ?>
	<div class="wp-block-myconianhotel-free-text wp-block alignfull is-layout-constrained has-global-padding has-default-background-color has-background-color has-black-color is-style-presetMediaTextLarge <?php echo $is_related_page && $all_text ? 'has-text' : ''; ?>">
		<div id="filter-text-wrap" class="filter-text-wrap is-layout-flow">
			<p id="filter-text" class="has-medium-large-font-size filter-text"><?php echo $is_related_page ? $all_text : ''; ?></p>
		</div>
	</div>
	<?php endif; ?>		

	<?php

	echo $fix;

	$cnt = 0;
	while ( have_posts() ) : the_post(); $cnt++;
		
		//$post_type = get_post_type(); // If Archive has multiple post types like Location

		$the_terms = get_the_terms( get_the_ID(), $taxonomy ); // <<<<<< get_the_ID()
		$attributes = get_field( 'myconian_room_attributes' ) ?? array();

		$attributes_to_filters = myconianhotel_merge_accommodation_attributes_to_archive_filters( $taxonomy, $filters, $filters_and_compare, $attributes, get_the_ID() );
		$data_attributes = $attributes_to_filters['data_attributes'] ?? '';
		$compare_attributes = array_filter( $attributes, function ( $attr ) {
		    return isset( $attr['is_compare'] ) && $attr['is_compare'];
		});

		$aspectRatio = 'collection' == $colorscheme ? '16/9' : '4/3';

		// Permalink
		$permalink = 'hotel' == $post_type || 'restaurant' == $post_type ? get_post_meta( get_the_ID(), '_' . $post_type . '_url', true ) : get_the_permalink();
		$target = 'hotel' == $post_type || 'restaurant' == $post_type ? '_blank' : null;
		
		if ( $compare && 1 == $cnt ) :
			get_template_part( 'template-parts/archive', 'compare-mobile-header', array( 'compare_attributes' => $compare_attributes ) );
		endif;			
		?>

		<div class="wp-block-myconianhotel-post has-white-background-color has-background-color <?php echo $post_class ?>" style="width:<?php echo number_format( ( count( $compare_attributes ) + 1 ) * 33.3333 , 4 ); ?>vw" <?php echo $data_attributes; ?>>
			
			<div class="wp-block-myconianhotel-media-text wp-block-media-text is-stacked-on-mobile has-media-on-the-right">
				<figure class="wp-block-media-text__media">
				<?php if ( $permalink ) : ?>
					<a href="<?php echo $permalink; ?>" <?php echo $target ? 'target="' . $target . '"' : ''; ?> style="aspect-ratio:<?php echo $aspectRatio; ?>;width:100%;">
				<?php endif;

				if ( has_post_thumbnail() ) {
					the_post_thumbnail( 'large', array('style' => 'aspect-ratio:' . $aspectRatio . ';object-fit:cover;') );
				} else if ( $colorscheme ) {
					get_template_part( 'template-parts/image', 'placeholder', array( 'src' => $logo_src, 'aspectRatio' => $aspectRatio ) );
				}

				if ( $permalink ) : ?>
					</a>
				<?php endif; ?>
				</figure>

				<div class="wp-block-media-text__content is-layout-flow">
					<?php
					get_template_part( 'template-parts/archive', 'breadcrumb', array(
						'the_terms' => $the_terms,
						'post_type' => $post_type,
						'taxonomy' => $taxonomy
					));
					?>					

					<h2 class="wp-block-heading wp-myconianhotel-block-heading">
						<?php
						if ( $permalink ) :
							?>
						<a href="<?php echo $permalink; ?>" <?php echo $target ? 'target="' . $target . '"' : ''?>><?php the_title(); ?></a>
							<?php
						else:
							the_title();
						endif;
						?>
					</h2>

					<?php
					get_template_part( '/theme-blocks/blocks/post-acf-fields/template', '', array(
						'fields' => $attributes,
						'filter' => 'is_featured',
						'title' => false
					));

					the_excerpt();

					if ( $compare ) : // TODO: $more
						?>
					<div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
						<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="<?php echo $permalink; ?>">Learn more</a></div>
					</div>
						<?php
					endif;

					if ( $compare ) :
						get_template_part( 'template-parts/archive', 'compare-attributes', array(
							'the_terms' => $the_terms,
							'compare_attributes' => $compare_attributes
						));
					endif;
					?>

				</div>
			</div>
		</div>

		<?php
		if ( $compare && $compare_attributes ) :
			?>
		<div class="compare-mobile-title has-uppercase-text-transform"><?php the_title(); ?></div>
			<?php
		endif;
		?>

	<?php
	endwhile;	
?>

<?php
if ( true || is_post_type_archive( $post_type ) ) :
	get_template_part( 'template-parts/filters', '', [
		'filters' => array_merge( myconianhotel_transform_accommodation_terms_to_archive_filters( $taxonomy, $terms ), $attributes_to_filters['filters_and_compare'] ?? array() ),
		'post_type' => $post_type,
		'taxonomy' => $taxonomy,
		'compare' => $compare,
		'is_related_page' => $is_related_page
	]);
endif;
?>
</div>