const { registerBlockType } = wp.blocks;
const { __ } = wp.i18n;
const { BlockControls, InspectorControls } = wp.blockEditor;
const { ToolbarButton, Button, TextControl, PanelBody, Icon } = wp.components;
const { useSelect } = wp.data;
import { IconSet } from '../../modules';

import { edit } from '@wordpress/icons'; // Import the link icon

registerBlockType('myconianhotel/book-form', {
    title: __('Book Options', 'myconianhotel'),
    category: 'widgets',
    icon: IconSet.bookForm,
    attributes: {
        bookOptions: {
            type: 'array',
            default: [], // Only the dynamic book options will be in this array
        },
        defaultBookOption: {
            type: 'object',
            default: { label: 'Standard', ID: '' }, // Default values for the fixed row
        },
    },
    edit: ({ attributes, setAttributes }) => {
        const { bookOptions, defaultBookOption } = attributes;
        const optionsUrl = myconianhotelBlockBookForm.adminUrl + '/edit.php?post_type=accommodation&page=accommodations-settings';

        // Get the current post title
        const postTitle = useSelect((select) => {
            return 'Standard';//select('core/editor').getEditedPostAttribute('title') || __('Untitled Post', 'myconianhotel');
        }, []);

        // Update defaultBookOption label with post title
        const updateDefaultBookOptionID = (value) => {
            setAttributes({ defaultBookOption: { ...defaultBookOption, ID: value } });
        };
        
        const updateDefaultBookOptionLabel = (value) => {
            setAttributes({ defaultBookOption: { ...defaultBookOption, label: value } });
        };

        const addBookOption = () => {
            const newBookOptions = [...bookOptions, { label: '', ID: '' }];
            setAttributes({ bookOptions: newBookOptions });
        };

        const removeBookOption = (index) => {
            const newBookOptions = bookOptions.filter((_, i) => i !== index);
            setAttributes({ bookOptions: newBookOptions });
        };

        const updateBookOptionLabel = (index, value) => {
            const newBookOptions = bookOptions.map((row, i) =>
                i === index ? { ...row, label: value } : row
            );
            setAttributes({ bookOptions: newBookOptions });
        };


        const updateBookOptionID = (index, value) => {
            const newBookOptions = bookOptions.map((row, i) =>
                i === index ? { ...row, ID: value } : row
            );
            setAttributes({ bookOptions: newBookOptions });
        };

        // Set the fixed label to the post title if it is not already set
        if (defaultBookOption.label == 'postTitle') {
            //setAttributes({ defaultBookOption: { ...defaultBookOption, label: postTitle } });
        }

        return (
            <div className="wp-block-myconianhotel-book-form">
                <legend class="wpforms-field-label">{myconianhotelBlockBookForm?.options?.header ?? 'Available room options'}<a href={optionsUrl} target="_blank"><Icon icon={edit} style={{verticalAlign:'bottom'}}/></a></legend>
                <div className="wpforms-field-description">{myconianhotelBlockBookForm?.options?.description ?? 'Select the room option that you like.'}</div>
                <BlockControls>
                    <ToolbarButton
                        label={__('Add BookOption', 'myconianhotel')}
                        onClick={addBookOption}
                    >
                        {__('Add BookOption', 'myconianhotel')}
                    </ToolbarButton>
                </BlockControls>
                <InspectorControls>
                    <PanelBody title="Options">
                        <p>You can find global options <a href={optionsUrl} target="_blank">here</a>.</p>
                    </PanelBody>
                </InspectorControls>

                {/*<div className="option-row">
                    <TextControl
                        label={__('Default', 'myconianhotel')}
                        value={defaultBookOption.label}
                        onChange={updateDefaultBookOptionLabel}
                        disabled
                    />
                    <TextControl
                        label={'ID'}
                        placeholder={__('Room ID', 'myconianhotel')}
                        value={defaultBookOption.ID}
                        onChange={updateDefaultBookOptionID}
                    />
                </div>*/}

                {/* Dynamic BookOptions */}
                {bookOptions.map((bookOption, index) => (
                    <div className="option-row" key={index}>
                        <TextControl
                            label={__('Option', 'myconianhotel') + ' ' + (index+1)}
                            placeholder={__('Label', 'myconianhotel')}
                            value={bookOption.label}
                            onChange={(value) => updateBookOptionLabel(index, value)}
                        />
                        <TextControl
                            label={'ID'}
                            placeholder={__('ID', 'myconianhotel')}
                            value={bookOption.ID}
                            onChange={(value) => updateBookOptionID(index, value)}
                        />
                        <div>
                            <Button
                                isDestructive
                                onClick={() => removeBookOption(index)}
                            >
                                {__('Remove', 'myconianhotel')}
                            </Button>
                        </div>
                    </div>
                ))}

                <Button isPrimary onClick={addBookOption} style={{ marginTop: '10px' }}>
                    {__('Add New Option', 'myconianhotel')}
                </Button>
            </div>
        );
    },

    save: () => {
        return null; // Server side render

        const { bookOptions, defaultBookOption } = attributes;

        return (
            <div id="bookForm" className="wp-block-myconianhotel-book-form">
                {bookOptions.length > 0 && (
                    <div className="wpforms-field wpforms-field-radio">
                        <fieldset>
                            <legend className="wpforms-field-label">{__('Available room options', 'myconianhotel')}</legend>
                            <ul>
                                <li className="choice-1 depth-1">
                                    <input type="radio" id="book-option-0" name="book-option" aria-describedby="wpforms-bookForm-field_1-description" checked value={defaultBookOption.ID} />
                                    <label className="wpforms-field-label-inline" for="book-option-0">{defaultBookOption.label}</label>
                                </li>

                                {bookOptions.map((bookOption, index) => (
                                    bookOption.ID && (
                                    <li className={'choice-' + (index+2) + ' depth-1'} key={index}>
                                        <input type="radio" id={'book-option-' + (index+2)} name="book-option" aria-describedby="wpforms-bookForm-field_1-description" value={bookOption.ID} />
                                        <label className="wpforms-field-label-inline" for={'book-option-' + (index+2)}>{bookOption.label}</label>
                                    </li>
                                    )
                                ))}
                            </ul>
                            <div id="wpforms-bookForm-field_1-description" className="wpforms-field-description">Select the room option that you like</div>
                        </fieldset>
                    </div>
                )}

                {defaultBookOption.ID && (
                <a
                    href="#"
                    className="wp-block-button__link wp-element-button"
                    rel="noopener noreferrer"
                    target="_BLANK"
                >
                    {__('Book Now', 'myconianhotel')}
                </a>
                )}
            </div>
        );
    },
});
