const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
const {useBlockProps, useInnerBlocksProps } = wp.blockEditor;
import { AmbientAnimation } from '../../animation-typo/src/components';

const colorscheme = myconianhotelBlockPostTeaserGallery.colorscheme;

const TEMPLATE_INNERBLOCKS =
'collection' == colorscheme ?
[
    ['myconianhotel/post-teaser-column-empty', {},
        [
            ['wpforms/form-selector']
        ]
    ]
] :
[
    ['myconianhotel/post-teaser-column-empty', {},
        [
            ['myconianhotel/heading', {level:2, textAlign: 'center'}],
            ['myconianhotel/free-text', {displayPresets: ['free'], isNested: true}]
        ]
    ],
    ['myconianhotel/post-teaser-column-empty', {},
        [
            ['wpforms/form-selector']
        ]
    ]
];

const TEMPLATE = TEMPLATE_INNERBLOCKS;

registerBlockType('myconianhotel/contact', {
    apiVersion: 2,
    title: __('Contact', 'myconianhotel'),
    description: __('Some description'),
    icon: 'email',
    category: 'layout',
    edit(props) {
        const innerBlocksProps = useInnerBlocksProps({}, {
            template: TEMPLATE,
            templateLock: 'all'
        });

        // Create an array of 10 elements
        const items = Array.from({ length: 10 }, (_, index) => index);

        return (
            <div class={`wp-block wp-block-myconianhotel-contact wp-block-myconianhotel-post-teaser alignfull  has-white-background-color has-background-color has-${'collection' == colorscheme ? '2' : '3'}-columns`}>
                <div class="wp-block-columns wp-block-myconianhotel-columns">
                    <div class="wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column is-column-first is-layout-flow is-column-first has-darkgray-background-color has-background-color">
                        <AmbientAnimation/>
                    </div>
                    {innerBlocksProps.children}
                </div>
            </div>
        );
    },
    save(props) {
        const innerBlocksProps = useInnerBlocksProps.save({});
        
        // Create an array of 10 elements
        const items = Array.from({ length: 10 }, (_, index) => index);

        return (
            <div class={`wp-block wp-block-myconianhotel-contact wp-block-myconianhotel-post-teaser alignfull  has-white-background-color has-background-color has-${'collection' == colorscheme ? '2' : '3'}-columns`}>
                <div class="wp-block-columns wp-block-myconianhotel-columns">
                    <div class="wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column is-column-first is-layout-flow is-column-first has-darkgray-background-color has-background-color">
                        <AmbientAnimation/>
                    </div>
                    {innerBlocksProps.children}
                </div>
            </div>
        );
    }
});