const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
const { useBlockProps, useInnerBlocksProps } = wp.blockEditor;
import { IconSet } from '../../modules';

const TEMPLATE = [
    [
        'myconianhotel/group', {
            className: 'wp-block-column is-layout-flow',
            'metadata': {
                'name': 'Column'
            }
        },
        [            
            ['myconianhotel/paragraph', {                
                fontSize: 'small',
                placeholder: __('Subtitle', 'myconianhotel')
            }],
            ['myconianhotel/heading', {
                level: 2,
                placeholder: __('Heading', 'myconianhotel')
            }],
            [
                'myconianhotel/group', {
                    className: 'wp-block-myconianhotel-files',
                    'metadata': {
                        'name': 'Files'
                    }
                },
                [            
                    ['core/file'],
                    ['core/file']            
                ]
            ]         
        ]
    ],
    [
        'myconianhotel/group', {
            className: 'wp-block-column is-layout-flow',
            'metadata': {
                'name': 'Column'
            }
        },
        [            
            ['myconianhotel/paragraph', {                
                fontSize: 'small',
                placeholder: __('Subtitle', 'myconianhotel')
            }],
            ['myconianhotel/paragraph', {
                placeholder: __('Content', 'myconianhotel')
            }]            
        ]
    ],
    [
        'myconianhotel/group', {
            className: 'wp-block-column is-layout-flow',
            'metadata': {
                'name': 'Column'
            }
        },
        [            
            ['myconianhotel/paragraph', {                
                fontSize: 'small',
                placeholder: __('Subtitle', 'myconianhotel')
            }],
            ['myconianhotel/paragraph', {
                placeholder: __('Content', 'myconianhotel')
            }]            
        ]
    ]
];

registerBlockType('myconianhotel/files-text', {
    apiVersion: 2,
    title: __('Files & Text', 'myconianhotel'),
    description: __('Some description'),
    icon: IconSet.filesText,
    category: 'layout',
    edit(props) {
        const blockProps = useBlockProps({
            className: 'is-layout-constrained alignfull has-global-padding has-silver-background-color has-background-color'
        });

        const innerBlocksProps = useInnerBlocksProps({
            className: [
                'wp-block-columns is-layout-flex'
            ].filter(Boolean).join(' ') // Filter out empty class values
        }, {
            templateLock: 'all',
            template: TEMPLATE,
            allowedBlocks: []        
        });

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );
    },
    save(props) {
        const blockProps = useBlockProps.save({
            className: 'is-layout-constrained alignfull has-global-padding has-silver-background-color has-background-color'
        });

        const innerBlocksProps = useInnerBlocksProps.save({
            className: [
                'wp-block-columns is-layout-flex'
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );
    }
});

wp.blocks.registerBlockStyle('myconianhotel/files-text', [
    {
        name: 'alternative',
        label: 'Alternative style',
    }
]);