// https://chatgpt.com/c/6717816b-8b60-8003-8e4a-6407083f5df6
/*
                                
                        Style           Owl theme       Media position  NavContainer    Nav
        
gallery                 default         default                         false           true
gallery                 default         fade                            false           true
gallery                 alternative     autowidth                       true            true            Single room
gallery-text            alternative     autowidth                       true            true
gallery-text            alternative     autowidth       bottom          false           true
post-teaser-gallery     any             autowidth                       true            true            

*/

(function( $ ){

    const scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
    document.documentElement.style.setProperty('--wp--custom--scrollbar-width', scrollbarWidth + 'px');

    $(document).ready(function() {
        $('.wp-block-myconianhotel-gallery__slider.owl-carousel').each(function(i) {
            new Gallery($(this), i);
        });        
    });
    // Export to global scope
    //window.myconianhotelGallery = Gallery;

    function Gallery($carousel, index) {
        const $galleryBlock = $carousel.closest('.wp-block-myconianhotel-gallery');
        const $galleryTextBlock = $carousel.closest('.wp-block-myconianhotel-gallery-text');
        const $postTeaserGalleryBlock = $carousel.closest('.wp-block-myconianhotel-post-teaser-gallery');
        const $mediaTextBlock = $carousel.closest('.wp-block-myconianhotel-media-text');
        const totalItems = $carousel.find('.wp-block-myconianhotel-media').length; // Total items
        // Theme
        const themeClass = $carousel.attr("class").split(' ').find(function(className) {
            const themeClass = className.startsWith('owl-theme');
            return className.startsWith('owl-theme-');
        });
        const theme = themeClass?.replace('owl-theme-', '');

        // Gallery block style
        let galleryBlockStyle = undefined;
        if ( $galleryBlock.length ) {
            const galleryBlockClass = $galleryBlock.attr("class").split(' ').find(function(className) {
                return className.startsWith('is-style-');
            });            
            galleryBlockStyle = galleryBlockClass?.replace('is-style-', '');
        }

        // Post teaser gallery block style
        let postTeaserGalleryBlockStyle = undefined;
        if ( $postTeaserGalleryBlock.length ) {
            const postTeaserGalleryBlockClass = $postTeaserGalleryBlock.attr("class").split(' ').find(function(className) {
                return className.startsWith('is-style-');
            });            
            postTeaserGalleryBlockStyle = postTeaserGalleryBlockClass?.replace('is-style-', '');
        }

        // Media position for media-text block
        let mediaTextBlockMediaPosition = 'left';
        if ($mediaTextBlock.length) {
            const mediaTextBlockClass = $mediaTextBlock.attr("class").split(' ').find(function(className) {
                return className.startsWith('has-media-on-the-');
            });            
            mediaTextBlockMediaPosition = mediaTextBlockClass?.replace('has-media-on-the-', '') ?? mediaTextBlockMediaPosition;
        }

        // Nav container      
        let navContainer = false;
        let navText = [];

        if ($galleryBlock.length && 'alternative' == galleryBlockStyle) {
            navContainer = `#owl-nav-${index}`;
            navText = ['&#xe906;', '&#xe907;'];
            $galleryBlock.append(`<div class="owl-nav-container alignfull is-layout-constrained has-global-padding"><div id="owl-nav-${index}" class="owl-nav" data-carousel_index="1/${totalItems}"></div></div>`);
            $galleryBlock.append(`<style>#owl-nav-${index}:before{width:${totalItems.toString().length*20}px}</style>`);            
        }
        
        if ($galleryTextBlock.length && (mediaTextBlockMediaPosition !== 'left' && mediaTextBlockMediaPosition !== 'right')) {
            navContainer = `#owl-nav-${index}`;
            navText = ['&#xe906;', '&#xe907;'];               
            $galleryTextBlock.find('.wp-block-myconianhotel-gallery').append(`<div id="owl-nav-${index}" class="owl-nav"></div>`);          
        } else if ($galleryTextBlock.length) {
            navContainer = `#owl-nav-${index}`;
            navText = ['&#xe906;', '&#xe907;'];               
            $galleryTextBlock.find('.wp-block-myconianhotel-media-text').append(`<div id="owl-nav-${index}" class="owl-nav"></div>`);          
        }

        if ($postTeaserGalleryBlock.length) {
            navContainer = `#owl-nav-${index}`;
            navText = ['&#xe906;', '&#xe907;'];               
            $postTeaserGalleryBlock.find('.wp-block-myconianhotel-post-teaser').append(`<div id="owl-nav-${index}" class="owl-nav" ></div>`);          
        }

        //if ('default' == theme) {
            let lockLoopAnimationFix = true;
            let potentialIndex = 0;
            let lastIndex = 0;
        //}

        //if ('autowidth' == theme) {
            let allowTranslate = true;
        //}
        
        var owl = $carousel.owlCarousel({
            autoWidth: 'autowidth' == theme ? true : false,
            loop:
                ('default' == theme && totalItems >= 3)
                || 'fade' == theme
                || ('autowidth' == theme && ('alternative' == galleryBlockStyle || ($postTeaserGalleryBlock.length && 'top' == mediaTextBlockMediaPosition)))
                ? true : false,
            lazyLoad: true,
            rtl: 'left' == mediaTextBlockMediaPosition ? true : false,
            //startPosition: 'left' == mediaTextBlockMediaPosition ? totalItems : 0,
            nav: true,
            dots: false,
            center:
                'default' == theme || 'fade' == theme ? true : false,
            smartSpeed: 'fade' == theme ? 150 : 325,
            animateIn: 'fade' == theme ? 'fadeIn' : false,
            animateOut: 'fade' == theme ? 'fadeOut' : false,
            autoplay: ('fade' == theme || 'default' == theme) ? true : false,
            autoplayHoverPause: ('fade' == theme || 'default' == theme) ? true : false,
            navContainer: navContainer,
            navText: navText,
            mouseDrag: true,
            margin: 0,
            onInitialize: (event) => {
                if ($postTeaserGalleryBlock.length && 'top' == mediaTextBlockMediaPosition) {
                    itemContent(0);
                }
            },
            onInitialized: (event) => {
                if ('default' == ! theme && 'fade' !== theme) {
                    toggleNav();
                }

                if ('default' == theme) {
                    $(event.currentTarget).find('.owl-stage .owl-item').css({
                        transition:'transform .325s ease-in-out'
                    });
                    $carousel.find('.loopanimationfix').removeClass('loopanimationfix');
                }

                if ( $galleryTextBlock.length && 'autowidth' == theme && 'bottom' == mediaTextBlockMediaPosition ) {
                    updateOuterStagePosition();                    
                }

                if ( 'fade' == theme ) {
                    $carousel.closest('.wp-block-myconianhotel-weather').find('.wp-block-myconianhotel-weather-info__content').on('click', function(){
                        $carousel.trigger('next.owl.carousel');
                    });
                }


                // Wait for all images inside the carousel to load
                var images = $carousel.find('.owl-item:not(.cloned) img');
                var totalImages = images.length;
                var loadedImages = 0;

                images.each(function () {
                    if (this.complete) {
                        imageLoaded();
                    } else {
                        $(this).on('load', imageLoaded);
                        $(this).on('error', imageLoaded); // in case some fail
                    }
                    
                });
                
                function imageLoaded() {
                    loadedImages++;
                    if (loadedImages == 3) {
                        console.log('last hope');
                        $carousel.trigger('refresh.owl.carousel');
                    }
                }                

            },
            onChange: (event) => {
                if ( 'default' == theme ) {
                    potentialIndex = event.item.index;
                }
            },
            onResized: (event) => {
                setTimeout(function(){
                    $(event.currentTarget).trigger('refresh.owl.carousel');
                    //console.log('resized');
                    if ('default' == ! theme && 'fade' == theme) {
                        toggleNav();
                    }
                }, 300)
            },
            onTranslate: (event) => {
                if ('autowidth' == theme) {
                    allowTranslate = false;
                }

                if ('default' == theme) {                
                    fixLoopAnimation(potentialIndex - event.item.index);
                    if (event.item.index > lastIndex) {
                        $('.wp-block-myconianhotel-gallery .gallery-circle svg').css({
                            'transition' : 'all .325s ease-in-out',
                            'transform' : 'rotate(45deg)',
                        });
                        setTimeout(function(){
                            $('.wp-block-myconianhotel-gallery .gallery-circle svg').css({
                                'transition' : 'all 0s',
                                'transform' : 'rotate(0deg)',
                            });
                        }, 300)                    
                    } else {
                        $('.wp-block-myconianhotel-gallery .gallery-circle svg').css({
                            'transition' : 'all .325s ease-in-out',
                            'transform' : 'rotate(-45deg)',
                        });
                        setTimeout(function(){
                            $('.wp-block-myconianhotel-gallery .gallery-circle svg').css({
                                'transition' : 'all 0s',
                                'transform' : 'rotate(0deg)',
                            });
                        }, 300)                    
                    }
                }

                if ('fade' == theme) {
                    $carousel.closest('.wp-block-myconianhotel-weather').toggleClass('translated-odd-times')
                }

                if ('alternative' == galleryBlockStyle) {
                    let currentIndex = event.item.index - Math.ceil(event.item.count / 2) + 1;
                    currentIndex = currentIndex == 0 ? totalItems : currentIndex;
                    $(`#owl-nav-${index}`).attr('data-carousel_index', `${currentIndex}/${totalItems}`);                    
                }

                if ($postTeaserGalleryBlock.length && 'top' == mediaTextBlockMediaPosition) {
                    itemContent(event.item.index);
                }

                if (
                    ($postTeaserGalleryBlock.length && 'right' == mediaTextBlockMediaPosition) ||
                    ($galleryTextBlock.length && 'right' == mediaTextBlockMediaPosition)
                    ) {
                    if (event.item.index) {
                        $mediaTextBlock.addClass('hide-content')
                    } else {
                        $mediaTextBlock.removeClass('hide-content')                        
                    }
                }

            },
            onTranslated: (event) => {
                lastIndex = event.item.index;
                if ('autowidth' == theme) {
                    allowTranslate = true;
                }
            },
            onRefreshed: (event) => {
                //console.log('Refreshed');
            },
            responsive: {
                0: {
                    items: 1
                },
                992: {
                    items: 'default' == theme ? 3 : 1
                }
            }
        });

        owl.trigger('refresh.owl.carousel');

        // Mouseweel
        if (false) {
            $carousel.trigger('refresh.owl.carousel'); // TODO: fixes poor appearance on initialized
            $carousel.on('wheel', '.owl-stage', function (e) {
                if ( allowTranslate ) {
                    if (e.originalEvent.deltaY>0) {
                        $carousel.trigger('next.owl');                        
                    } else {
                        $carousel.trigger('prev.owl');                        
                    }               
                }
                e.preventDefault();
            });
        }

        function toggleNav() {
            if ( $carousel.find('.owl-stage').offset().left + $carousel.find('.owl-stage').width() < window.innerWidth ) {
                $carousel.next('.owl-nav').attr('disabled',true);
            } else {
                $carousel.next('.owl-nav').removeAttr('disabled');                
            }
        }

        function itemContent(index) {
            const $info = $postTeaserGalleryBlock.find('.wp-block-myconianhotel-gallery__info');
            const $element = $postTeaserGalleryBlock.find('.wp-block-post-teaser-column').eq(index);
            let subtitleAndInfo = $element.find('p:first-child').text().split('[');

            const subtitle = subtitleAndInfo[0];
            const info = subtitleAndInfo[1]?.replace(']', '')??'';
            const title = $element.find('.wp-myconianhotel-block-heading').text();
            const content = $element.find('figure + p').html();            
            const buttons = $element.find('.wp-block-myconianhotel-buttons').html();            
            const infoHtml = itemInfo(info);
            
            setTimeout(function() {
                $info.html(infoHtml);
            }, 250)

            if ( infoHtml ) {
                $info.addClass('has-info');
            } else {
                $info.removeClass('has-info');                
            }

            setTimeout(function() {
                $postTeaserGalleryBlock.find('.wp-block-media-text__content').html(
                    `${subtitle ? `<p class="has-small-font-size has-uppercase-text-transform">${subtitle}</p>` : ''}
                    ${title ? `<h2 class="wp-block-heading wp-myconianhotel-block-heading">${title}</h2>` : ''}             
                    ${content ? `<p>${content}</p>` : ''}
                    ${buttons ? `<div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">${buttons}</div>` : ''}`
                    );
            }, 250);
        }

        function itemInfo(info) {
            const items = info.split(' ');
            let html = '';

            for (var i = 0; i < items.length; i++) {
                html += items[i] && `<span>${items[i]}</span>`;
            }

            return html;
        }

        function fixLoopAnimation(potentialDirection) {
            let criticalIndex = null;

            if (potentialDirection > 0) { // x1
                if (totalItems <= 6) {
                    criticalIndex = totalItems*2-(totalItems-2);
                } else {
                    criticalIndex = totalItems*2-(parseInt(totalItems/2)+1);
                }
            } else { // x2
                if (totalItems <= 6) {
                    criticalIndex = 2;
                } else {
                    criticalIndex = Math.ceil(totalItems/2)-1;
                }
            }

            //console.log('potentialDirection: ' + potentialDirection);

            // For display purposes
            $carousel.find('.loopanimationfix').removeClass('loopanimationfix');
            if (lockLoopAnimationFix) {lockLoopAnimationFix = false; return};

            if (potentialDirection > 0) {
                $carousel.each(function() {
                    $(this).find('.owl-item').each(function(index) {
                        if (index === criticalIndex) {
                            var $this = $(this);
                            setTimeout(function() {
                                if ($this.hasClass('active')) {
                                    $this.addClass('loopanimationfix');
                                }
                            });
                        }
                    })
                });            
            } else {
                $carousel.each(function() {
                    $(this).find('.owl-item').each(function(index) {
                        if (index === criticalIndex) {
                            var $this = $(this);
                            setTimeout(function() {
                                if ($this.hasClass('active')) {
                                    $this.addClass('loopanimationfix');
                                }
                            });
                        }
                    })
                });             
            }
        }

        /**
         * Updates owl-stage-outer position in a way that the first image looks horizontaly centered
         */
        function updateOuterStagePosition(event) {
            const $outerStage = $carousel.find('.owl-stage-outer');
            const outerStageWidth = $outerStage.width();
            const itemWidth = $outerStage.find('.owl-item').eq(0).width();
            const diff = outerStageWidth - (itemWidth);

            if (diff > 0) {
                const left = (diff/2)*100/outerStageWidth;
                $outerStage.css({left: parseInt(left) + '%'});
            }
        }

        function updateStageWidthAndPosition(event) {
            const centerItemWidth = $stage.find('.owl-item.center').width();
            const stageWidth = $stage.width();
            const navButtonWidth = parseInt(centerItemWidth/2);
            
            $(event.currentTarget).find('.owl-prev, .owl-next').width(navButtonWidth);

            $stage.css({
                width: stageWidth + centerItemWidth,
                //right: parseInt((centerItemWidth-itemWidth)/2)
            });
        }
    }    
})( jQuery );

// totalItems = 2       d1 => totalItems*2-0 (4)        d2 => 2
// totalItems = 3       d1 => totalItems*2-1 (5)        d2 => 2
// totalItems = 4       d1 => totalItems*2-2 (6)        d2 => 2
// totalItems = 5       d1 => totalItems*2-3 (7)        d2 => 2
// totalItems = 6       d1 => totalItems*2-4 (8)        d2 => 2
// totalItems = 7       d1 => totalItems*2-4 (10)       d2 => 3
// totalItems = 8       d1 => totalItems*2-5 (11)       d2 => 3
// totalItems = 9       d1 => totalItems*2-5 (13)       d2 => 4
// totalItems = 10      d1 => totalItems*2-6 (14)       d2 => 4
// totalItems = 11      d1 => totalItems*2-6 (16)       d2 => 5
// totalItems = 12      d1 => totalItems*2-7 (17)       d2 => 5
// totalItems = 13      d1 => totalItems*2-7 (19)       d2 => 6  