<?php
if ( $attributes['markers'] ?? false ) {
    foreach ( $attributes['markers'] as $marker ) {
        $markers[] = array(
            'location' => array(
                'lat'   => $marker['position']['lat'],
                'lng'   => $marker['position']['lng'],
            ),
            'title' => $marker['label'] ?: $marker['address']
        );
    }
}

$markers = json_encode( $markers );
?>

<div class="wp-block-myconianhotel-google-map wp-block-myconianhotel-media-text wp-block-media-text has-media-on-the-right alignfull is-stacked-on-mobile has-white-background-color">
    <div class="wp-block-media-text__media">
        <div id="map"></div>
    </div>

    <div class="wp-block-media-text__content">
        <div><?php echo $content; ?></div>
        <ul id="locations-list" class="wp-block-myconianhotel-google-map__locations"></ul>
    </div>
</div>

<style>
    .special-marker{
        circle{
            fill: #b4aea1;
        }
        &:hover{
            circle{
                fill: #103b5a;
            }
        }

        .blue-circle{
            fill: #103b5a;
        }

        .gray-circle{
            fill: #b4aea1;
        }
    }
</style>

<script>

(function(){
    initMap = function () {
        const parser = new DOMParser();

        const ambSvgString = '<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40"><g id="Group_1359" data-name="Group 1359" transform="translate(-1336 -3784)"><circle id="Ellipse_9" data-name="Ellipse 9" cx="20" cy="20" r="20" transform="translate(1336 3784)" fill="#013762"/><path id="a" d="M8-22.381l2.62,6.069H5.4Zm5.132,11.844H15.4L8.919-25.416H7.91L1.4-10.538H2.929L4.9-15.132h6.227Z" transform="translate(1347.596 3821.977)" fill="#e9e7e4"/></g></svg>';
        const ambSvg = parser.parseFromString(ambSvgString, 'image/svg+xml').documentElement;

        const locSvgString = '<svg class="special-marker" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><circle cx="12" cy="12" r="12" fill="#b4aea1"/></svg>';
        const locSvg = parser.parseFromString(locSvgString, 'image/svg+xml').documentElement;

        //First item in this object must be the location of the Hotel
        let markerData = <?php echo $markers ?>;
        markerData = markerData.map((marker, i) => {
            return {
                ...marker, // Spread existing properties
                icon: 0 == i ? ambSvg : locSvg.cloneNode(true)
            };
        });

        const map = new google.maps.Map(document.getElementById('map'), {
            center: { lat: 37.4414527, lng: 25.3463776 },
            zoom: 13.5,
            mapId: "156839d38324d66d",
            streetViewControl: false,
            fullscreenControl: false,
            mapTypeControl: false,
            zoomControl: false
        });

        const origin = markerData[0].location;
        const markers = {};
        let previousMarker = null;

        markerData.forEach((item, index) => {
            const marker = new google.maps.marker.AdvancedMarkerElement({
                position: item.location,
                map: map,
                title: item.title,
                content: item.icon,
            });

            markers[item.title] = marker;

            if (index != 0){
                marker.content.addEventListener('mouseenter',function(){
                    $('#locations-list li').removeClass('is-active');
                    $('#locations-list li[data-item="' + index + '"]').addClass('is-active');
                })

                // marker.content.addEventListener('mouseleave',function(){
                //     $('#locations-list li').removeClass('is-active');
                // })
            }
            

            // Click listener for each marker
            marker.addListener('click', function () {
                
                marker.content.innerHTML = '<circle cx="12" cy="12" r="12" fill="#103b5a"/>';

                $('#locations-list li').removeClass('is-active');
                $('#locations-list li[data-item="' + index + '"]').addClass('is-active');

                // Reset the previous marker's color
                if (previousMarker && previousMarker !== marker) {
                    previousMarker.content.innerHTML = '<circle cx="12" cy="12" r="12" fill="#b4aea1"/>';
                }

                // Store the clicked marker as the previous marker
                previousMarker = marker;

                // Open Google Maps directions in a new tab
                if (index !== 0) { // Ensure it's not the "Ambassador" marker
                    const destination = item.location;
                    const googleMapsUrl = `https://www.google.com/maps/dir/?api=1&origin=${origin.lat},${origin.lng}&destination=${destination.lat},${destination.lng}`;
                    window.open(googleMapsUrl, '_blank');
                }
            });
        });

        const distanceMatrixService = new google.maps.DistanceMatrixService();
        distanceMatrixService.getDistanceMatrix(
            {
                origins: [origin],
                destinations: markerData.slice(1).map(item => item.location),
                travelMode: google.maps.TravelMode.DRIVING
            },
            function (response, status) {
                if (status === google.maps.DistanceMatrixStatus.OK) {
                    const distances = response.rows[0].elements;
                    const list = document.getElementById('locations-list');
                    distances.forEach((distance, i) => {
                        const listItem = document.createElement('li');
                        listItem.innerHTML = `${markerData[i + 1].title} <span>${distance.distance.text}</span>`;
                        listItem.setAttribute('data-item', i + 1);

                        // Click listener to trigger marker click
                        listItem.addEventListener('click', () => {
                            const destination = markerData[i + 1].location;
                            const googleMapsUrl = `https://www.google.com/maps/dir/?api=1&origin=${origin.lat},${origin.lng}&destination=${destination.lat},${destination.lng}`;
                            window.open(googleMapsUrl, '_blank');
                        });

                        listItem.addEventListener('mouseenter', () => {
                            $(listItem).addClass('is-active'); // Add colored class to list item
                            const marker = markers[markerData[i + 1].title]; // Get the corresponding marker
                            marker.content.innerHTML = '<circle class="blue-circle" cx="12" cy="12" r="12" fill="#103b5a"/>';
                            
                        });

                        listItem.addEventListener('mouseleave', () => {
                            $(listItem).removeClass('is-active'); // Remove colored class from list item
                            const marker = markers[markerData[i + 1].title]; // Get the corresponding marker
                            marker.content.innerHTML = '<circle class="gray-circle" cx="12" cy="12" r="12" fill="#b4aea1"/>';
                        });

                        list.appendChild(listItem);
                    });
                } 
            }
        );
    };
})();

</script>
