import { group } from '@wordpress/icons';

const { registerBlockType } = wp.blocks;
const { InnerBlocks, useBlockProps, useInnerBlocksProps } = wp.blockEditor;
const { __ } = wp.i18n;

registerBlockType('myconianhotel/group', {
    apiVersion: 2, // Use block API version 2
    title: __('Group (M)', 'myconianhotel'),
    icon: group,
    category: 'layout',
    attributes: {
        /*align: {
            type: 'string',
            default: 'wide',
        }*/
    },
    supports: {
        //align: ['wide', 'full'], // Optional: support alignment options
        inserter: false, // Prevents this block from appearing in the block inserter
    },
    edit: (props) => {
        const blockProps = useBlockProps({
            className: [
                'wp-block-group'               
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps();

        return (
            <div {...blockProps}>
                {innerBlocksProps.children}
            </div>
        );
    },
    save: () => {
        const blockProps = useBlockProps.save({
            className: [
                'wp-block-group'               
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps.save()

        return (
            <div {...blockProps}>
                {innerBlocksProps.children}
            </div>
        );
    },
});
