// https://chatgpt.com/c/670cdce5-e42c-8003-a2f6-331a2a3b6834

const { __ } = wp.i18n;

const { registerBlockType } = wp.blocks;
const { RichText, BlockControls, AlignmentToolbar, InspectorControls } = wp.blockEditor;
const { PanelBody, SelectControl } = wp.components;
const { useEffect } = wp.element;
const { HeadingLevelDropdown } = wp.blockEditor;

registerBlockType( 'myconianhotel/heading', {
    apiVersion: 2,
    title: 'Heading (M)',
    icon: 'heading',
    category: 'text',
    attributes: {
        content: {
            type: 'string',
            source: 'html',
            selector: 'h1, h2, h3, h4, h5, h6, blockquote',
        },
        level: {
            type: 'number',
            default: 2,
        },
        placeholder: {
            type: 'string',            
            default: __('Heading', 'myconianhotel')
        },
        tag: {
            type: 'string',
            default: 'h'
        },
        textAlign: {
            type: 'string',
            default: 'left', // Default alignment
        },
    },

    edit: ( props ) => {
        const { attributes: { content, tag, level, textAlign, placeholder }, setAttributes } = props;

        const onChangeContent = ( newContent ) => {
            setAttributes( { content: newContent } );
        };

        const onChangeLevel = ( newLevel ) => {
            setAttributes( { level: newLevel } );
        };

        const onChangeAlignment = ( newAlignment ) => {
            setAttributes( { textAlign: newAlignment || 'left' } );  // Default to 'left'
        };

        return (
            <>
                {/*<BlockControls>
                    <HeadingLevelDropdown
                        value={ level }
                        onChange={ onChangeLevel }
                    />
                    <AlignmentToolbar
                        value={ textAlign }
                        onChange={ onChangeAlignment }
                    />
                </BlockControls>*/}
                <InspectorControls>
                    <PanelBody title="Options">
                        <SelectControl
                            label="Transform to"
                            value={ tag + `${ 'h' == tag ? level : '' }` } // The currently selected option
                            options={[
                                { label: 'Header', value: 'h' },
                                { label: 'Blockquote', value: 'blockquote' },
                            ]}
                            onChange={(value) => setAttributes({tag: value})}
                        />
                    </PanelBody>
                </InspectorControls>
                <RichText
                    className={`${ 'h' == tag ? 'wp-block-heading wp-myconianhotel-block-heading' : ''}${'center' === textAlign ? ' has-text-align-center' : ('right' === textAlign ? ' has-text-align-right' : '')}`}
                    tagName={ tag + `${ 'h' == tag ? level : '' }` }
                    value={ content }
                    onChange={ onChangeContent }
                    placeholder={placeholder}
                />
            </>
        );
    },

    save: ( props ) => {
        const { attributes: { content, tag, level, textAlign } } = props;

        return (
            <RichText.Content
                className={`${ 'h' == tag ? 'wp-block-heading wp-myconianhotel-block-heading' : ''}${'center' === textAlign ? ' has-text-align-center' : ('right' === textAlign ? ' has-text-align-right' : '')}`}
                tagName={ tag + `${ 'h' == tag ? level : '' }` }
                value={ content }
            />
        );
    },
} );


