/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!********************************************!*\
  !*** ./blocks/instagram-feed/src/index.js ***!
  \********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

// https://chatgpt.com/c/67372518-f878-8003-a7e1-251c390dfc2a

const {
  registerBlockType
} = wp.blocks;
const {
  useBlockProps,
  useInnerBlocksProps,
  useSetting
} = wp.blockEditor;
const {
  useEffect
} = wp.element;
const TEMPLATE = [['myconianhotel/buttons']];
registerBlockType('myconianhotel/instagram-feed', {
  apiVersion: 2,
  title: 'Instagram Feed',
  icon: 'instagram',
  category: 'widgets',
  edit: props => {
    const {
      attributes,
      setAttributes
    } = props;
    const {
      feed,
      backgroundColor
    } = attributes;
    // Set the initial background color if it hasn't been set
    const defaultBackgroundSlug = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
    useEffect(() => {
      if (!backgroundColor) {
        setAttributes({
          backgroundColor: defaultBackgroundSlug
        });
      }
    }, [backgroundColor, defaultBackgroundSlug]);
    const blockProps = useBlockProps({
      className: ['wp-block-myconianhotel-post-teaser has-3-columns is-style-nogap', `has-${backgroundColor}-background-color has-background-color`, 'alignfull', 'is-stacked-on-mobile', 'is-layout-constrained'].filter(Boolean).join(' ') // Filter out empty class values
    });
    const innerBlocksProps = useInnerBlocksProps({}, {
      template: TEMPLATE,
      templateLock: 'all',
      allowedBlocks: []
    });
    const paresedFeed = JSON.parse(feed); // Parse JSON to an array

    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      ...blockProps,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "wp-block-columns wp-block-myconianhotel-columns",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(InstagramFeedRender, {
          feed: paresedFeed
        })
      }), innerBlocksProps.children]
    });
  },
  save: props => {
    return null; // Serverside render
  }
});
const InstagramFeedRender = props => {
  return props.feed.map((post, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
    className: "wp-block-column wp-block-myconian-hotel-column",
    children: [('IMAGE' == post.media_type || 'CAROUSEL_ALBUM' == post.media_type) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("figure", {
      className: "wp-block-myconianhotel-media wp-block-myconianhotel-image wp-block-image",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
        src: post.uri,
        alt: 'Instagram Image',
        style: {
          aspectRatio: "1/1",
          objectFit: "cover"
        }
      }), post.caption && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("figcaption", {
        className: "wp-element-caption is-style-toggleOverlay",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("a", {
          href: post.permalink,
          target: "_blank",
          class: "is-layout-flow",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("time", {
            datetime: post.insta_timestamp,
            children: humanTiming(post.insta_timestamp)
          }), truncateString(post.caption)]
        })
      })]
    }, index), 'VIDEO' == post.media_type && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("figure", {
      className: "wp-block-myconianhotel-media wp-block-myconianhotel-image wp-block-image",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("video", {
        src: post.uri,
        alt: 'Instagram Video',
        autoplay: true,
        loop: true,
        muted: true,
        playsinline: true,
        preload: "metadata",
        poster: "",
        style: {
          aspectRatio: "1/1",
          objectFit: "cover"
        }
      }), post.caption && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("figcaption", {
        className: "wp-element-caption is-style-toggleOverlay",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("a", {
          href: post.permalink,
          target: "_blank",
          class: "is-layout-flow",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("time", {
            datetime: post.insta_timestamp,
            children: humanTiming(post.insta_timestamp)
          }), truncateString(post.caption)]
        })
      })]
    }, index)]
  }));
};
function truncateString(str, maxLength = 120) {
  if (str.length > maxLength) {
    return str.substring(0, maxLength) + '...';
  }
  return str;
}
function humanTiming(dateTime = "2024-11-15 13:53:52") {
  // Convert the date-time string to a Date object
  const pastDate = new Date(dateTime.replace(' ', 'T')); // Convert to ISO format for parsing

  // Check if the date is valid
  if (isNaN(pastDate.getTime())) {
    throw new Error("Invalid date-time format provided");
  }

  // Calculate the time difference in seconds
  const currentTime = Math.floor(Date.now() / 1000); // Get the current time in seconds
  let timeDifference = Math.floor(currentTime - pastDate.getTime() / 1000); // Time difference in seconds

  // Define the tokens (time units)
  const tokens = [{
    unit: 31536000,
    label: 'year'
  }, {
    unit: 2592000,
    label: 'month'
  }, {
    unit: 604800,
    label: 'week'
  }, {
    unit: 86400,
    label: 'day'
  }, {
    unit: 3600,
    label: 'hour'
  }, {
    unit: 60,
    label: 'minute'
  }, {
    unit: 1,
    label: 'second'
  }];
  let result = '';
  let counter = 1;

  // Loop through each token and find the appropriate unit
  for (const token of tokens) {
    if (timeDifference < token.unit) continue;
    if (counter > 1) break;
    const numberOfUnits = Math.floor(timeDifference / token.unit);
    result += `${numberOfUnits} ${token.label}${numberOfUnits > 1 ? 's' : ''} `;
    timeDifference -= numberOfUnits * token.unit;
    counter++;
  }
  return `${result.trim()} ago`;
}
})();

/******/ })()
;
//# sourceMappingURL=index.js.map