// https://chatgpt.com/c/67372518-f878-8003-a7e1-251c390dfc2a

const { registerBlockType } = wp.blocks;
const { useBlockProps, useInnerBlocksProps, useSetting } = wp.blockEditor;
const { useEffect } = wp.element;

const TEMPLATE = [
    ['myconianhotel/buttons']
];

registerBlockType('myconianhotel/instagram-feed', {
    apiVersion: 2,
    title: 'Instagram Feed',
    icon: 'instagram',
    category: 'widgets',
    edit: (props) => {
        const { attributes, setAttributes } = props;
        const { feed, backgroundColor } = attributes;
        // Set the initial background color if it hasn't been set
        const defaultBackgroundSlug  = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
        useEffect(() => {
            if (!backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, [backgroundColor, defaultBackgroundSlug]);

        const blockProps = useBlockProps({
            className: [
                'wp-block-myconianhotel-post-teaser has-3-columns is-style-nogap',
                `has-${backgroundColor}-background-color has-background-color`,
                'alignfull',
                'is-stacked-on-mobile',
                'is-layout-constrained',
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps({}, {
            template: TEMPLATE,
            templateLock: 'all',
            allowedBlocks: []        
        });
        const paresedFeed = JSON.parse(feed); // Parse JSON to an array

        return (
            <div {...blockProps}>
                <div className="wp-block-columns wp-block-myconianhotel-columns">
                    <InstagramFeedRender feed={paresedFeed}/>
                </div>
                {innerBlocksProps.children}
            </div>
        );
    },
    save: (props) => {
        return null; // Serverside render
    },
});

const InstagramFeedRender = (props) => {
    return (
        props.feed.map((post, index) => (
            <div className="wp-block-column wp-block-myconian-hotel-column">
                { ('IMAGE' == post.media_type || 'CAROUSEL_ALBUM' == post.media_type) &&
                <figure key={index} className="wp-block-myconianhotel-media wp-block-myconianhotel-image wp-block-image">
                    <img src={post.uri} alt={'Instagram Image'}  style={{aspectRatio:"1/1", objectFit:"cover"}} />
                    {post.caption &&
                    <figcaption className="wp-element-caption is-style-toggleOverlay">
                        <a href={post.permalink} target="_blank" class="is-layout-flow">
                            <time datetime={post.insta_timestamp}>{humanTiming(post.insta_timestamp)}</time>
                           {truncateString(post.caption)}
                        </a>
                    </figcaption>
                    }
                </figure>
                }
                { ('VIDEO' == post.media_type) &&
                <figure key={index} className="wp-block-myconianhotel-media wp-block-myconianhotel-image wp-block-image">
                    <video src={post.uri} alt={'Instagram Video'} autoplay loop muted playsinline preload="metadata" poster="" style={{aspectRatio:"1/1", objectFit:"cover"}} />
                    {post.caption &&
                    <figcaption className="wp-element-caption is-style-toggleOverlay">
                        <a href={post.permalink} target="_blank" class="is-layout-flow">
                            <time datetime={post.insta_timestamp}>{humanTiming(post.insta_timestamp)}</time>
                           {truncateString(post.caption)}
                        </a>
                    </figcaption>
                    }
                </figure>
                }
            </div>
        ))  
    );
}

function truncateString(str, maxLength=120) {
    if (str.length > maxLength) {
        return str.substring(0, maxLength) + '...';
    }
    return str;
}

function humanTiming(dateTime = "2024-11-15 13:53:52") {
    // Convert the date-time string to a Date object
    const pastDate = new Date(dateTime.replace(' ', 'T')); // Convert to ISO format for parsing

    // Check if the date is valid
    if (isNaN(pastDate.getTime())) {
        throw new Error("Invalid date-time format provided");
    }

    // Calculate the time difference in seconds
    const currentTime = Math.floor(Date.now() / 1000); // Get the current time in seconds
    let timeDifference = Math.floor(currentTime - pastDate.getTime() / 1000); // Time difference in seconds

    // Define the tokens (time units)
    const tokens = [
        { unit: 31536000, label: 'year' },
        { unit: 2592000, label: 'month' },
        { unit: 604800, label: 'week' },
        { unit: 86400, label: 'day' },
        { unit: 3600, label: 'hour' },
        { unit: 60, label: 'minute' },
        { unit: 1, label: 'second' }
    ];

    let result = '';
    let counter = 1;

    // Loop through each token and find the appropriate unit
    for (const token of tokens) {
        if (timeDifference < token.unit) continue;
        if (counter > 1) break;

        const numberOfUnits = Math.floor(timeDifference / token.unit);
        result += `${numberOfUnits} ${token.label}${numberOfUnits > 1 ? 's' : ''} `;
        timeDifference -= numberOfUnits * token.unit;
        counter++;
    }

    return `${result.trim()} ago`;
}
