<?php
$feed = beetinstafeed_get_insta_feed();

if ( ! empty( $feed ) ) :
	?>
<div class="wp-block-myconianhotel-instagram-feed wp-block-myconianhotel-post-teaser has-3-columns is-style-nogap has-lightgray-background-color has-background-color alignfull is-stacked-on-mobile is-layout-constrained">
	<div class="wp-block-columns wp-block-myconianhotel-columns">

	<?php
	foreach ( $feed as $post ) :
		$mediaTypeClassSuffix = 'VIDEO' == $post->media_type ? 'video' : 'image';
		?>

		<div class="wp-block-column wp-block-myconian-hotel-column">
			<figure class="wp-block-myconianhotel-media wp-block-myconianhotel-<?php echo $mediaTypeClassSuffix ?> wp-block-<?php echo $mediaTypeClassSuffix ?>">

				<?php if ( 'VIDEO' == $post->media_type ) : ?>
					<video src="<?php echo $post->uri; ?>" autoplay loop muted playsinline preload="metadata"  alt="Instagram Video" style="aspect-ratio:1/1;object-fit:cover"></video>
				<?php else : ?>
					<img decoding="async" src="<?php echo $post->uri; ?>" alt="Instagram Image" style="aspect-ratio:1/1;object-fit:cover">
				<?php endif ?>

				<figcaption class="wp-element-caption is-style-toggleOverlay">
					<a href="<?php echo $post->permalink; ?>" target="_blank" class="is-layout-flow">
						<time datetime="<?php echo $post->insta_timestamp; ?>"><?php echo function_exists( 'beetinstafeed_humanTiming' ) ? beetinstafeed_humanTiming( strtotime( $post->insta_timestamp ) ) : ''; ?></time>
						<?php echo $post->caption; ?>
					</a>
				</figcaption>
			</figure>
		</div>

		<?php		
	endforeach
	?>

	</div>
</div>
	<?php
endif;
?>
