const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { InspectorControls, useBlockProps } = wp.blockEditor;
const { PanelBody } = wp.components;
const { Fragment, useEffect } = wp.element;
import { CustomPanelColorSettings, IconSet } from '../../modules';

registerBlockType('myconianhotel/interactive-typo', {
    apiVersion: 2,
    title: __('Interactive Typo', 'myconianhotel'),
    icon: IconSet.interactiveTypo,
    category: 'widgets',
    supports: {
        multiple: false, // Restrict the block to be added only once
    },
    edit(props) {
        const { attributes, setAttributes } = props;
        const { typo, backgroundColor } = attributes;

        // Set the initial background color if it hasn't been set
        useEffect(() => {
            if (!backgroundColor) {
                setAttributes({ backgroundColor: 'collection' == myconianhotelBlockInteractiveTypo.colorscheme ? 'darkgray' : 'darkblue' });
            }
        }, [backgroundColor]);

        const blockProps = useBlockProps({
            className:[
                'animation-container alignfull',
                backgroundColor ? `has-${backgroundColor}-background-color has-background-color` : ''
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        
        // Create an array of 10 elements
        const items = Array.from({ length: 10 }, (_, index) => index);

        return (
            <Fragment>
            <InspectorControls>
                <PanelBody title={__('Instructions', 'myconianhotel')}>               
                    You can change the displayed letters <a href={myconianhotelBlockInteractiveTypo.appearanceOptionsPage} target="_blank" rel="noopener noreferrer">here</a>.<br/>
                    Then you need to return and Attempt recovery.
                </PanelBody>
                <CustomPanelColorSettings
                    setAttributes={setAttributes}
                    backgroundColor={backgroundColor}
                    palette={'collection' == myconianhotelBlockInteractiveTypo.colorscheme ? ['darkgray', 'white'] : ['darkblue', 'darkgray', 'lightgray'] }
                />
            </InspectorControls>

            <div {...blockProps}>
                <div className="animation-outer-container interactive-circle">
                    {items.map((item) => (
                        <div className={`inner-circle inner-circle-${item}`} key={item}>
                            <div className="inner-wrapper">
                                <div className="letter letter-1">{typo}</div>
                                <div className="letter letter-2">{typo}</div>
                                <div className="letter letter-3">{typo}</div>
                                <div className="letter letter-4">{typo}</div>    
                                <div className="letter letter-5">{typo}</div>
                                <div className="letter letter-6">{typo}</div>
                                <div className="letter letter-7">{typo}</div>
                                <div className="letter letter-8">{typo}</div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
            </Fragment>
        );
    },
    save(props) {
        const { attributes } = props;
        const { typo, backgroundColor } = attributes;
        const blockProps = useBlockProps.save({
            className:[
                'animation-container alignfull',
                backgroundColor ? `has-${backgroundColor}-background-color has-background-color` : ''
            ].filter(Boolean).join(' ') // Filter out empty class
        });

        // Create an array of 10 elements
        const items = Array.from({ length: 10 }, (_, index) => index);

        return (
            <div {...blockProps}>
                <div className="animation-outer-container interactive-circle">
                    {items.map((item) => (
                        <div className={`inner-circle inner-circle-${item}`} key={item}>
                            <div className="inner-wrapper">
                                <div className="letter letter-1">{typo}</div>
                                <div className="letter letter-2">{typo}</div>
                                <div className="letter letter-3">{typo}</div>
                                <div className="letter letter-4">{typo}</div>    
                                <div className="letter letter-5">{typo}</div>
                                <div className="letter letter-6">{typo}</div>
                                <div className="letter letter-7">{typo}</div>
                                <div className="letter letter-8">{typo}</div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        );
    }
});