<?php

/**
 * Enqueue Editor assets
 */
add_action( 'enqueue_block_editor_assets', function(){
    $asset_file = include( __DIR__ . '/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-masonry',
        get_theme_file_uri() . '/theme-blocks/blocks/masonry/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );
}, 100 );

/**
 * Enqueue front-end assets
 */
add_action('enqueue_block_assets', function() {
    $theme = wp_get_theme();
    $version = $theme->get( 'Version' );

    // myconianhotel/media-text-hero
    wp_register_script(
        'myconianhotel-block-masonry-front-end',
        get_template_directory_uri() . '/theme-blocks/blocks/masonry/assets/js/index.js',
        array(),
        $version,
        true // Load in the footer
    );

    if ( ! is_admin() ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('myconianhotel-block-masonry-front-end');
    }
});

add_filter( 'render_block', function( $rendered_block, $block ) {
    if ( 'myconianhotel/masonry' == $block['blockName'] ) {
        preg_match_all( '~(<figure[^>]*>\s*<img[^>]*>\s*<\/figure>)~i', $rendered_block, $matches );
        if ( count( $matches ) ) {
            for ( $m=0; $m < count( $matches[0] ); $m++ ) {
                if ( ! empty($matches[0][$m]) ) {
                    $tmp = str_replace( '><img', '><div><img', $matches[0][$m] );
                    $tmp = str_replace( '</figure>', '</div></figure>', $tmp );
                    $rendered_block = str_replace( $matches[0][$m], $tmp, $rendered_block );
                } 
            }
        }        
    }
    return $rendered_block;
}, 2, 2);    