const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
const { InnerBlocks, useBlockProps, BlockControls, MediaUpload, MediaPlaceholder, useInnerBlocksProps } = wp.blockEditor;
const { ToolbarButton, ToolbarGroup } = wp.components;
const { useSelect, useDispatch } = wp.data;
import { IconSet } from '../../modules';

registerBlockType('myconianhotel/masonry', {
    apiVersion: 2,
    title: __('Masonry', 'myconianhotel'),
    description: __('Some description'),
    icon: IconSet.masonry,
    category: 'media',
    edit(props) {
        const { clientId, attributes/*1, setAttributes*/ } = props;

        {/*TODO: Same as mediahotel/galery from here */}
        const blockProps = useBlockProps({
            className: 'alignfull',
        });

        const innerBlocksProps = useInnerBlocksProps({}, {
            allowedBlocks: ['myconianhotel/media'],
            templateLock: false
        });

        const { replaceInnerBlocks, insertBlocks } = useDispatch('core/block-editor');
        
        const innerBlocks = useSelect(select => select('core/block-editor').getBlocks(clientId), [clientId]);

        const onSelectImages = (media) => {
            const imageBlocks = media.map((image) =>
                createBlock('myconianhotel/media', {
                    mediaId: image.id,
                    mediaUrl: image.url,
                    mediaAlt: image.alt,
                    mediaSizeSlug: 'medium',
                    mediaOrientation: image.sizes.full.height > image.sizes.full.width ? 'portrait' : 'landscape',
                    relatedPostsLinkOption: true,
                    aspectRatio: 'unset'
                })
            );
            replaceInnerBlocks(clientId, imageBlocks, false);
        };

        const onAddImages = (media) => {
            const imageBlocks = media.map((image) =>
                createBlock('myconianhotel/media', {
                    mediaId: image.id,
                    mediaUrl: image.url,
                    mediaAlt: image.alt,
                    mediaSizeSlug: 'medium',
                    mediaOrientation: image.sizes.full.height > image.sizes.full.width ? 'portrait' : 'landscape',
                    relatedPostsLinkOption: true,
                    aspectRatio: 'unset'
                })
            );
            insertBlocks(imageBlocks, innerBlocks.length, clientId);
        };

        {/*TODO: Same as mediahotel/galery to here */}

        return (
            <div {...blockProps}>
                <BlockControls>
                    <MediaUpload
                        onSelect={onAddImages}
                        allowedTypes={['image']}
                        multiple
                        render={({ open }) => (
                            <ToolbarGroup>
                                <ToolbarButton
                                    label={__('Add', 'myconianhotel')}
                                    onClick={open}
                                >
                                    {__('Add', 'myconianhotel')}
                                </ToolbarButton>
                            </ToolbarGroup>
                        )}
                    />
                </BlockControls>

                {/* Show placeholder if there are no inner blocks */}
                {!innerBlocks.length && (
                    <MediaPlaceholder
                        onSelect={onSelectImages}
                        allowedTypes={['image']}
                        multiple
                        gallery
                        labels={{ title: __('Select Images', 'myconianhotel') }}
                    />
                )}


                {/* Display the rest of the gallery */}
                {innerBlocks.length > 0 && (
                    innerBlocksProps.children                  
                )}
            </div>
        );
    },
    save(props) {
        const { attributes } = props;

        const blockProps = useBlockProps.save({
            className: 'alignfull',
        });
        
        const innerBlocksProps = useInnerBlocksProps.save();

        return (
            <div {...blockProps}>
                {innerBlocksProps.children}
            </div>
        );
    }
});