(function($){

	var totalAnimationTime = 40; //seconds
	var totalAnimationDegrees = 360; //Degrees

	class AmbientAnimation {
		constructor(element) {
			this.element = element;
			this.$element = $(this.element);
			this.lastScrollTop = 0;
		}

		setAmbientRotation(duration, degrees) {
			this.$element.find('.inner-circle .inner-wrapper').css('transition', 'all '+duration+'s linear');
			this.$element.find('.inner-circle .inner-wrapper').css('transform', 'rotate('+degrees+'deg)')
		}

		handleRotation() {
			var st = $(window).scrollTop();
			if (isInViewport(this.$element)) {
				var degreesAnimated = getRotationDegrees(this.$element.find('.inner-circle .inner-wrapper').css('transform'));
				
				if (st > this.lastScrollTop){
			   		if (degreesAnimated == 0){
			   			this.setAmbientRotation(0, 0);
			   			setTimeout(() => {
			   				this.setAmbientRotation(totalAnimationTime, totalAnimationDegrees);
			   			}, 50)
			   		}
			   		else{
			   			this.setAmbientRotation(totalAnimationTime, totalAnimationDegrees);
			   		}
					
		   		}
			   	else {
			   		if (degreesAnimated == 0){
			   			this.setAmbientRotation(0, 0);
			   			setTimeout(() => {
			   				this.setAmbientRotation(totalAnimationTime, totalAnimationDegrees * -1);
			   			}, 50)
			   		}
			   		else{
			   			this.setAmbientRotation(totalAnimationTime, totalAnimationDegrees * -1);
			   		}
			   	}
			} else {
		   		var degreesAnimated = this.$element.find('.inner-circle .inner-wrapper').css('transform');
		   		//console.log('Out of viewport rotation: '+getRotationDegrees(degreesAnimated))
		   		this.$element.find('.inner-circle .inner-wrapper').css('transition', 'all 0s linear');
				this.$element.find('.inner-circle .inner-wrapper').css('transform', 'rotate(0)')
		   	}
	   		this.lastScrollTop = st;
		}
	}

	$(document).ready(function() {
		const ambientInstances = [];

		document.querySelectorAll('.ambient-animation-container').forEach(container => {
		  const instance = new AmbientAnimation(container);
		  ambientInstances.push(instance);
		});

		window.addEventListener('scroll', () => {
		  ambientInstances.forEach(instance => instance.handleRotation());
		});		
	});

	function getRotationDegrees(matrix) {
	    if(matrix !== 'none') {
	        var values = matrix.split('(')[1].split(')')[0].split(',');
	        var a = values[0];
	        var b = values[1];
	        var angle = Math.round(Math.atan2(b, a) * (180/Math.PI));
	    }
	    else {
	    	var angle = 0;
	    }
	    return (angle < 0) ? angle + 360 : angle;
	}

	// Check if element is in viewport
	function isInViewport(element) {
	    const elementOffset = $(element).offset();
	    const elementTop = elementOffset.top;
	    const elementBottom = elementTop + $(element).outerHeight();
	    const viewportTop = $(window).scrollTop();
	    const viewportBottom = viewportTop + $(window).height();
	    return elementBottom > viewportTop && elementTop < viewportBottom;
	}

})(jQuery)