// https://chatgpt.com/c/66fbc41a-13dc-8003-9993-9d0350ee180d

import MediaTextAttributes from '../../media-text/src/attributes';
import { onChangeMediaPosition } from '../../media-text/src/functions';
import { ContentEdit, ContentSave } from '../../media-text/src/components';

import { CustomPanelColorSettings, IconSet } from '../../modules';
import MediaAttributes from '../../media/src/attributes';
import { AmbientAnimation } from '../../animation-typo/src/components';
import { MediaEdit, MediaSave, MediaUploadMedia, PanelBodyMedia } from '../../media/src/components';
const { useState } = wp.element;

wp.domReady(() => {

    const { __ } = wp.i18n;
    const { registerBlockType } = wp.blocks;
    const { 
        MediaUpload, 
        InspectorControls, 
        MediaPlaceholder, 
        InnerBlocks, 
        BlockControls, 
        MediaUploadCheck, 
        useBlockProps,
        useSetting,
        PanelColorSettings
    } = wp.blockEditor;
    const { 
        PanelBody,
        ToggleControl, 
        TextareaControl, 
        SelectControl, 
        ToolbarButton, 
        ToolbarGroup
    } = wp.components;
    const { useEffect, Fragment } = wp.element;
    const { useSelect } = wp.data;

    const alignPullTopIcon = (
        <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
            <rect x="5" y="11" width="10" height="2"/>
            <rect x="3" y="3" width="14" height="6"/>
            <rect x="5" y="15" width="10" height="2"/>
        </svg>
    );

    const updatedMediaAttributes = {
        ...MediaAttributes,
        mediaSizeSlug: {
            ...(MediaAttributes.mediaSizeSlug || {}), // Fallback to an empty object if undefined
            default: 'medium',
        }
    };

    registerBlockType('myconianhotel/media-text-hero', {
        apiVersion: 2,
        title: 'Media & Text Hero',
        description: __('A two-column layout with an image or video on one side and text on the other, surrounded by a background image.'),
        icon: IconSet.mediaTextHero,
        category: 'layout',
        attributes: {
            ...MediaTextAttributes,
            ...updatedMediaAttributes,
            backgroundPresets: {
                type: 'object',
                default: {},
            },
            innerBlockPosition: {
                type: 'string'
            }
        },
        supports: {
            anchor: true,
            media: true/*,
            background: {
                backgroundImage: true, // Enable background image control.
            }*/
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const { 
                mediaId, 
                mediaUrl, 
                mediaAlt,
                mediaSizeSlug,
                mediaCustomPosition,
                mediaOrientation,
                aspectRatio,
                mediaType,
                autoplay,
                loop,
                muted,
                controls,
                playsinline,
                preload,
                poster,
                posterId,
                mediaPosition,
                backgroundColor,
                chosenTemplate,
                backgroundPresets,
                innerBlockPosition
            } = attributes;

            const defaultBackgroundSlug = useSetting('custom.defaultBackgroundSlug');
            const mediaTextHeroBlockDefaultBackgroundSlug = useSetting('custom.mediaTextHeroBlockDefaultBackgroundSlug');
            const mediaTextHeroBlockInnerDefaultBackgroundSlug = useSetting('custom.mediaTextHeroBlockInnerDefaultBackgroundSlug');

            // Initialize innerBlockPosition for collection color scheme
            useEffect(() => {
                if ('collection' == myconianhotelBlockMediaTextHero.colorscheme && ! innerBlockPosition) {
                    setAttributes({ innerBlockPosition: 'left' });
                }
            }, []);

            // Pass data to save()
            useEffect(() => {
                if ('collection' == myconianhotelBlockMediaTextHero.colorscheme) {
                    if ('darkblue' == backgroundColor) {
                        setAttributes({ backgroundPresets: {                        
                            mediaText: 'lightergray',
                            animationTypo: 'darkgray'
                        }});
                    } else {
                        setAttributes({ backgroundPresets: {                        
                            mediaText: 'white',
                            animationTypo: 'darkgray'
                        }});
                    }
                } else {
                    if ('lightbrown' == backgroundColor) {
                        setAttributes({ backgroundPresets: {                        
                            mediaText: 'lightgray',
                            animationTypo: 'white'
                        }});
                    } else if ('lightgray' == backgroundColor) {
                        setAttributes({ backgroundPresets: {
                            mediaText: 'white',
                            animationTypo: 'lightbrown'
                        }});
                    } else if ('darkgray' == backgroundColor) {
                        setAttributes({ backgroundPresets: {
                            mediaText: 'lightbrown',
                            animationTypo: 'white'
                        }});
                    } else if ('darkblue' == backgroundColor) {
                        setAttributes({ backgroundPresets: {
                            mediaText: 'lightgray',
                            animationTypo: 'darkblue'
                        }});
                    }                    
                }
            }, [backgroundColor]);
            
            useEffect(() => {
                if (! backgroundColor) {
                    setAttributes({ backgroundColor: mediaTextHeroBlockDefaultBackgroundSlug });
                }
            }, [backgroundColor]);

            // Aspect ratio && positions
            useEffect(() => {
                // Aspect ratio
                if ('top' == mediaPosition && 'collection' !== myconianhotelBlockMediaTextHero.colorscheme && innerBlockPosition ) {
                    setAttributes({ aspectRatio: '3/2' });
                } else if ('top' == mediaPosition && 'collection' !== myconianhotelBlockMediaTextHero.colorscheme) {
                    setAttributes({ aspectRatio: '130/74' });
                } else {
                    setAttributes({ aspectRatio: '1/1' });
                }

                // Positions
                if ('top' !== mediaPosition && 'collection' !== myconianhotelBlockMediaTextHero.colorscheme) {
                    setAttributes({ innerBlockPosition: undefined });
                }
            }, [mediaPosition, innerBlockPosition]);

            // Apply blockProps directly to the root element
            const blockProps = useBlockProps({
                className: [
                    'wp-block-myconianhotel-media-text-hero alignfull has-' + backgroundColor + '-background-color has-background-color',
                    innerBlockPosition ? `has-innerblock-on-the-${innerBlockPosition}` : '', // Align inner block
                    'collection' !== myconianhotelBlockMediaTextHero.colorscheme ? 'is-layout-constrained has-global-padding' : ''
                ].filter(Boolean).join(' ')
            });

            const innerBlockProps = {
                className: [
                    'wp-block wp-block-myconianhotel-media-text wp-block-media-text is-style-alternative', // Default class
                    'has-' + backgroundPresets.mediaText + '-background-color has-background-color', // background
                    props.align ? `align${props.align}` : '', // Align classes
                    'is-stacked-on-mobile', // Mobile stacking class
                    `has-media-on-the-${mediaPosition}`, // Media positioning class
                ].filter(Boolean).join(' ') // Filter out empty class values
            };

            return (
                <Fragment>
                    <BlockControls>
                        <ToolbarGroup>
                            <ToolbarButton
                                icon="align-pull-left"
                                label={__('Show media on left')}
                                isActive={mediaPosition === 'left'}
                                onClick={() => onChangeMediaPosition('left', setAttributes)}
                            />
                            <ToolbarButton
                                icon="align-pull-right"
                                label={__('Show media on right')}
                                isActive={mediaPosition === 'right'}
                                onClick={() => onChangeMediaPosition('right', setAttributes)}
                            />
                            <ToolbarButton
                                icon={alignPullTopIcon}
                                label={__('Show media on top')}
                                isActive={mediaPosition === 'top'}
                                onClick={() => onChangeMediaPosition('top', setAttributes)}
                            />
                        </ToolbarGroup>
                        { ('top' == mediaPosition || 'collection' == myconianhotelBlockMediaTextHero.colorscheme)  && (
                        <ToolbarGroup>
                            <ToolbarButton
                                icon="align-left"
                                label={__('Align inner Block to the left')}
                                isActive={innerBlockPosition === 'left'}
                                onClick={() => {
                                    if ('collection' == myconianhotelBlockMediaTextHero.colorscheme) {
                                        setAttributes({innerBlockPosition: 'left'})
                                    } else {
                                        setAttributes({
                                            innerBlockPosition: innerBlockPosition === 'left' ? undefined : 'left',
                                        });                                        
                                    }
                                }}
                            />
                            <ToolbarButton
                                icon="align-right"
                                label={__('Align inner Block to the right')}
                                isActive={innerBlockPosition === 'right'}
                                onClick={() => {
                                    if ('collection' == myconianhotelBlockMediaTextHero.colorscheme) {
                                        setAttributes({innerBlockPosition: 'right'})
                                    } else {
                                        setAttributes({
                                            innerBlockPosition: innerBlockPosition === 'right' ? undefined : 'right',
                                        });                                        
                                    }
                                }}
                            />
                        </ToolbarGroup>
                        )}
                        <ToolbarGroup>
                            <MediaUploadMedia
                                mediaId={mediaId}
                                setAttributes={setAttributes}
                            />
                        </ToolbarGroup>
                    </BlockControls>
                    <InspectorControls>
                        <CustomPanelColorSettings
                            setAttributes={setAttributes}
                            backgroundColor={backgroundColor}
                            palette={'collection' == myconianhotelBlockMediaTextHero.colorscheme ? ['darkblue', 'lightergray'] : ['darkblue', 'lightbrown', 'darkgray', 'lightgray'] }
                        />
                        <PanelBodyMedia
                            mediaType={mediaType}
                            mediaId={mediaId}
                            mediaAlt={mediaAlt}
                            mediaUrl={mediaUrl}
                            mediaSizeSlug={mediaSizeSlug}
                            mediaCustomPosition={mediaCustomPosition}
                            mediaOrientation={mediaOrientation}
                            aspectRatio={aspectRatio}
                            open={open}
                            controls={controls}
                            autoplay={autoplay}
                            loop={loop}
                            muted={muted}
                            playsinline={playsinline}
                            preload={preload}
                            poster={poster}
                            posterId={posterId}
                            setAttributes={setAttributes}
                        />
                    </InspectorControls>
                    <div {...blockProps}>

                        {/* Invisible editable field to focus on Editor's Blocks list */}                    
                        <textarea style={{ border: '0',clip: 'rect(1px, 1px, 1px, 1px)',clipPath: 'inset(50%)',height: '1px',margin: '-1px',overflow: 'hidden',padding: '0',position: 'absolute',width: '1px',wordWrap: 'normal' }} />                    

                        <AmbientAnimation attributes={{color: backgroundPresets.animationTypo, align: 'full'}}/>
                    
                        <div {...innerBlockProps}>
                            <MediaEdit
                                mediaType={mediaType}
                                mediaUrl={mediaUrl}
                                mediaAlt={mediaAlt}
                                mediaId={mediaId}
                                mediaSizeSlug={mediaSizeSlug}
                                mediaCustomPosition={mediaCustomPosition}
                                mediaOrientation={mediaOrientation}
                                aspectRatio={aspectRatio}
                                controls={controls}
                                autoplay={autoplay}
                                loop={loop}
                                muted={muted}
                                playsinline={playsinline}
                                preload={preload}
                                poster={poster}
                                figureProps={
                                    {className:'wp-block-media-text__media'}
                                }
                                setAttributes={setAttributes}
                            />
                            <ContentEdit chosenTemplate={chosenTemplate} setAttributes={setAttributes}/>
                        </div>
                    </div>
                </Fragment>
            );
        },
        save: (props) => {
            const { attributes } = props;
            const { 
                mediaId, 
                mediaUrl, 
                mediaAlt, 
                mediaPosition,
                mediaSizeSlug,
                mediaOrientation,
                mediaCustomPosition,
                aspectRatio,
                mediaType,
                autoplay,
                loop,
                muted,
                controls,
                playsinline,
                preload,
                poster,
                backgroundColor,
                backgroundPresets,
                innerBlockPosition
            } = attributes;

            // Use blockProps.save to ensure props are added to the root element in the frontend
            const blockProps = useBlockProps.save({
                className: [
                    'wp-block-myconianhotel-media-text-hero alignfull has-' + backgroundColor + '-background-color has-background-color',
                    innerBlockPosition ? `has-innerblock-on-the-${innerBlockPosition}` : '', // Align inner block
                    'collection' !== myconianhotelBlockMediaTextHero.colorscheme ? 'is-layout-constrained has-global-padding' : ''
                ].filter(Boolean).join(' ')/*,
                style: {
                    "background-size": "cover",
                    "background-image": `url(${props.attributes?.style?.background?.backgroundImage?.url ?? 'none'})`,
                    "background-position": "50% 0px"
                }*/
            });

            const innerBlockProps = {
                className: [
                    'wp-block wp-block-myconianhotel-media-text wp-block-media-text is-style-alternative', // Default class
                    'has-' + backgroundPresets.mediaText + '-background-color has-background-color', // background
                    props.align ? `align${props.align}` : '', // Align classes
                    'is-stacked-on-mobile', // Mobile stacking class
                    `has-media-on-the-${mediaPosition}`, // Media positioning class
                ].filter(Boolean).join(' ') // Filter out empty class values
            };

            return (
                <div {...blockProps}>

                    <AmbientAnimation attributes={{color: backgroundPresets.animationTypo, align: 'full'}}/>
                
                    <div {...innerBlockProps}>
                        <MediaSave
                            mediaType={mediaType}
                            mediaUrl={mediaUrl}
                            mediaAlt={mediaAlt}
                            mediaId={mediaId}
                            mediaSizeSlug={mediaSizeSlug}
                            mediaCustomPosition={mediaCustomPosition}
                            mediaOrientation={mediaOrientation}
                            aspectRatio={aspectRatio}
                            controls={controls}
                            autoplay={autoplay}
                            loop={loop}
                            muted={muted}
                            playsinline={playsinline}
                            preload={preload}
                            poster={poster}
                            figureProps={
                                {className:'wp-block-media-text__media'}
                            }
                        />
                        <ContentSave/>
                    </div>
                </div>            
            );
        },
    });

});