/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/icons/build-module/library/link-off.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link-off.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * WordPress dependencies
 */


const linkOff = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_0__.Path, {
    d: "M17.031 4.703 15.576 4l-1.56 3H14v.03l-2.324 4.47H9.5V13h1.396l-1.502 2.889h-.95a3.694 3.694 0 0 1 0-7.389H10V7H8.444a5.194 5.194 0 1 0 0 10.389h.17L7.5 19.53l1.416.719L15.049 8.5h.507a3.694 3.694 0 0 1 0 7.39H14v1.5h1.556a5.194 5.194 0 0 0 .273-10.383l1.202-2.304Z"
  })
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (linkOff);
//# sourceMappingURL=link-off.js.map

/***/ }),

/***/ "./blocks/animation-typo/src/components.js":
/*!*************************************************!*\
  !*** ./blocks/animation-typo/src/components.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AmbientAnimation: () => (/* binding */ AmbientAnimation)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

// TODO: Same as mediatext hero
const AmbientAnimation = props => {
  const letter = myconianhotelBlockAnimationTypo.logotype;
  const circles = Array.from({
    length: 10
  }); // Creates an array of 10 items

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: `animation-container ambient-animation-container${props?.attributes?.align ? ` alignfull` : ''}${props?.attributes?.color ? ` has-${props?.attributes?.color}-color has-color` : ''}`,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      className: "animation-outer-container ambient-animation",
      children: circles.map((_, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: `inner-circle inner-circle-${i}`,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "inner-wrapper",
          children: [...Array(8)].map((_, j) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: `letter letter-${j + 1}`,
            children: letter
          }, j))
        })
      }, i))
    })
  });
};

/***/ }),

/***/ "./blocks/media-text/src/attributes.js":
/*!*********************************************!*\
  !*** ./blocks/media-text/src/attributes.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const MediaTextAttributes = {
  align: {
    // deprecated?
    type: 'string',
    default: 'full' // Force full alignment by default
  },
  mediaPosition: {
    type: 'string',
    default: 'left'
  },
  chosenTemplate: {
    type: 'string',
    default: 'default'
  },
  backgroundColor: {
    type: 'string'
    //default: 'white', It is declared inside index.js (themeDefaultBackground)
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTextAttributes);

/***/ }),

/***/ "./blocks/media-text/src/components.js":
/*!*********************************************!*\
  !*** ./blocks/media-text/src/components.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ContentEdit: () => (/* binding */ ContentEdit),
/* harmony export */   ContentSave: () => (/* binding */ ContentSave)
/* harmony export */ });
/* harmony import */ var _media_src_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../media/src/components */ "./blocks/media/src/components.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


const {
  __
} = wp.i18n;
const {
  InnerBlocks,
  useInnerBlocksProps,
  useBlockProps
} = wp.blockEditor;
const {
  Fragment,
  useState,
  useEffect,
  useRef
} = wp.element;
const {
  useSelect
} = wp.data;
const ContentEdit = props => {
  const {
    clientId,
    setAttributes,
    className,
    chosenTemplate
  } = props;
  const {
    updateBlockAttributes,
    replaceInnerBlocks
  } = wp.data.dispatch('core/block-editor');
  // Track last chosen template
  const lastTemplateRef = useRef(chosenTemplate);
  const templates = {
    default: [['myconianhotel/paragraph', {
      textAlign: 'center',
      fontSize: 'small',
      placeholder: __('Subtitle', 'myconianhotel')
    }], ['myconianhotel/heading', {
      level: 2,
      textAlign: 'center',
      placeholder: __('Heading', 'myconianhotel')
    }], ['myconianhotel/paragraph', {
      textAlign: 'center',
      placeholder: __('Content', 'myconianhotel')
    }], ['myconianhotel/buttons']],
    sticky: [['myconianhotel/free-text', {
      displayPresets: ['free', 'presetMediaText'],
      chosenTemplate: 'presetMediaText',
      isNested: true
    }]],
    animationtypo: [['myconianhotel/group', {
      className: 'wp-block-media-text__content is-layout-flow',
      'metadata': {
        'name': 'Content'
      }
    }, [['myconianhotel/paragraph', {
      textAlign: 'center',
      fontSize: 'small',
      placeholder: __('Subtitle', 'myconianhotel')
    }], ['myconianhotel/heading', {
      level: 2,
      textAlign: 'center',
      placeholder: __('Heading', 'myconianhotel')
    }], ['myconianhotel/paragraph', {
      textAlign: 'center',
      placeholder: __('Content', 'myconianhotel')
    }], ['myconianhotel/buttons']]], ['myconianhotel/animation-typo', {
      backgroundColor: 'darkblue',
      color: 'darkblue'
    }]]
  };

  // Snippet for existing sticky media texts
  const existingBlocks = useSelect(select => select('core/block-editor').getBlocks(clientId), [clientId]);

  // Template depends on className
  useEffect(() => {
    let style = 'default';
    if (className?.includes('is-style-sticky')) {
      style = 'sticky';
    } else if (className?.includes('is-style-animationtypo')) {
      style = 'animationtypo';
    }
    setAttributes({
      chosenTemplate: style
    });
  }, [className]);

  // Update innerblocks based on chosen template
  useEffect(() => {
    if (lastTemplateRef.current !== chosenTemplate) {
      // Snippet for existing sticky media text to preserve content on paste
      let updatedChosenTemplate = [];
      if ('sticky' == chosenTemplate && existingBlocks.length) {
        existingBlocks.forEach((block, index) => {
          console.log(block);
          if ('myconianhotel/free-text' == block.name) {
            updatedChosenTemplate.push(block);
          }
        });
      }
      // Replace innerblocks
      replaceInnerBlocks(clientId, wp.blocks.createBlocksFromInnerBlocksTemplate(updatedChosenTemplate.length ? updatedChosenTemplate : templates[chosenTemplate]));
      lastTemplateRef.current = chosenTemplate;
    }
  }, [chosenTemplate, clientId]);
  const innerBlocksProps = useInnerBlocksProps({
    className: 'wp-block-media-text__content is-layout-flow'
  }, {
    template: templates[chosenTemplate],
    templateLock: 'all',
    allowedBlocks: []
  });
  return 'bottom' == props.mediaPosition || props.className?.includes('is-style-animationtypo') ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: `${!props.className?.includes('is-style-animationtypo') ? 'wp-block-media-text__content is-layout-flow' : 'wp-block-media-text__grid'}`,
    children: [innerBlocksProps.children, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_0__.MediaEdit, {
      mediaType: props.mediaType,
      mediaUrl: props.mediaUrl,
      mediaAlt: props.mediaAlt,
      mediaId: props.mediaId,
      mediaSizeSlug: props.mediaSizeSlug,
      mediaCustomPosition: props.mediaCustomPosition,
      aspectRatio: props.aspectRatio,
      controls: props.controls,
      autoplay: props.autoplay,
      loop: props.loop,
      muted: props.muted,
      playsinline: props.playsinline,
      preload: props.preload,
      poster: props.poster,
      setAttributes: props.setAttributes,
      figureProps: {
        className: 'wp-block-media-text__media'
      }
    })]
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...innerBlocksProps
  });
};
const ContentSave = props => {
  const innerBlocksProps = useInnerBlocksProps.save({
    className: 'wp-block-media-text__content is-layout-flow'
  });
  return 'bottom' == props.mediaPosition || props.className?.includes('is-style-animationtypo') ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: `${!props.className?.includes('is-style-animationtypo') ? 'wp-block-media-text__content is-layout-flow' : 'wp-block-media-text__grid'}`,
    children: [innerBlocksProps.children, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_0__.MediaSave, {
      mediaType: props.mediaType,
      mediaUrl: props.mediaUrl,
      mediaAlt: props.mediaAlt,
      mediaId: props.mediaId,
      mediaSizeSlug: props.mediaSizeSlug,
      mediaCustomPosition: props.mediaCustomPosition,
      aspectRatio: props.aspectRatio,
      controls: props.controls,
      autoplay: props.autoplay,
      loop: props.loop,
      muted: props.muted,
      playsinline: props.playsinline,
      preload: props.preload,
      poster: props.poster,
      figureProps: props.figureProps
    })]
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...innerBlocksProps
  });
};

/***/ }),

/***/ "./blocks/media-text/src/functions.js":
/*!********************************************!*\
  !*** ./blocks/media-text/src/functions.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   onChangeMediaPosition: () => (/* binding */ onChangeMediaPosition)
/* harmony export */ });
const onChangeMediaPosition = (position, setAttributes) => {
  setAttributes({
    mediaPosition: position
  });
};

/***/ }),

/***/ "./blocks/media/src/attributes.js":
/*!****************************************!*\
  !*** ./blocks/media/src/attributes.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// If any default value of
// autoplay
// loop
// muted
// controls
// playsinline
// preload
// is updated, must be updated in theme-blocks/blocks/hero/template.php

const MediaAttributes = {
  mediaType: {
    type: 'string',
    default: 'image'
  },
  mediaId: {
    type: 'number'
  },
  mediaUrl: {
    type: 'string'
  },
  mediaAlt: {
    type: 'string',
    default: ''
  },
  mediaSizeSlug: {
    type: 'string',
    default: 'medium_large'
  },
  mediaOrientation: {
    type: 'string'
  },
  mediaAnchor: {
    type: 'string',
    default: ''
  },
  mediaCustomPosition: {
    type: 'number',
    default: 50
  },
  aspectRatio: {
    type: 'string',
    default: 'unset' // Default aspect ratio
  },
  originalAspectRatio: {
    type: 'number'
  },
  autoplay: {
    type: 'boolean',
    default: true
  },
  loop: {
    type: 'boolean',
    default: true
  },
  muted: {
    type: 'boolean',
    default: true
  },
  controls: {
    type: 'boolean',
    default: false
  },
  playsinline: {
    type: 'boolean',
    default: true
  },
  preload: {
    type: 'string',
    default: 'metadata'
  },
  poster: {
    type: 'string',
    default: ''
  },
  posterId: {
    type: 'number'
  },
  relatedPostsLinkOption: {
    type: 'boolean',
    default: false
  },
  relatedPosts: {
    type: 'boolean',
    default: false
  },
  experimentalLink: {
    type: 'array',
    default: []
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaAttributes);

/***/ }),

/***/ "./blocks/media/src/components.js":
/*!****************************************!*\
  !*** ./blocks/media/src/components.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MediaEdit: () => (/* binding */ MediaEdit),
/* harmony export */   MediaSave: () => (/* binding */ MediaSave),
/* harmony export */   MediaUploadMedia: () => (/* binding */ MediaUploadMedia),
/* harmony export */   PanelBodyMedia: () => (/* binding */ PanelBodyMedia)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/link-off.js");
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./functions */ "./blocks/media/src/functions.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
/**
 * MediaEdit
 * MediaSave
 * PanelBodyMedia
 * MediaUploadMedia
 */


const {
  __
} = wp.i18n;
const {
  MediaPlaceholder,
  MediaUpload,
  MediaUploadCheck,
  __experimentalLinkControl: LinkControl
} = wp.blockEditor;
const {
  PanelBody,
  ToggleControl,
  SelectControl,
  TextareaControl,
  Button,
  RangeControl,
  Flex,
  FlexItem,
  BaseControl
} = wp.components;
const {
  useEffect,
  useState,
  Fragment
} = wp.element;
const {
  useSelect
} = wp.data;


const MediaEdit = ({
  mediaType,
  mediaUrl,
  mediaAlt,
  mediaId,
  mediaSizeSlug,
  mediaOrientation,
  mediaAnchor,
  relatedPostsLinkOption,
  relatedPosts,
  mediaCustomPosition,
  aspectRatio,
  originalAspectRatio,
  controls,
  autoplay,
  loop,
  muted,
  playsinline,
  preload,
  poster,
  figureProps,
  setAttributes
}) => {
  const addVerticalPositioning = (0,_functions__WEBPACK_IMPORTED_MODULE_0__.verticalPositioning)(mediaOrientation, originalAspectRatio, aspectRatio);
  const figureContent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [mediaType && mediaUrl ? mediaType === 'image' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: `wp-image-${mediaId} size-${mediaSizeSlug}${mediaOrientation ? ' is-' + mediaOrientation : ''}`,
      style: 'unset' !== aspectRatio ? {
        aspectRatio: aspectRatio,
        objectFit: 'cover',
        ...(mediaCustomPosition >= 0 && mediaCustomPosition !== 50 ? {
          objectPosition: `${addVerticalPositioning ? '50% ' : ''}${mediaCustomPosition}%${!addVerticalPositioning ? ' 50%' : ''}`
        } : {})
      } : null
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("video", {
      controls: controls,
      autoPlay: autoplay,
      loop: loop,
      muted: muted,
      playsInline: playsinline,
      preload: preload,
      poster: poster,
      className: `wp-video-${mediaId}`,
      style: 'unset' !== aspectRatio ? {
        aspectRatio: aspectRatio,
        objectFit: 'cover',
        ...(mediaCustomPosition >= 0 && mediaCustomPosition !== 50 ? {
          objectPosition: `${addVerticalPositioning ? '50% ' : ''}${mediaCustomPosition}%${!addVerticalPositioning ? ' 50%' : ''}`
        } : {})
      } : null,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("source", {
        src: mediaUrl
      })
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(MediaPlaceholder, {
      onSelect: (media, mediaSizeSlug) => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onSelectMedia)(media, mediaSizeSlug, setAttributes),
      allowedTypes: ['image', 'video'],
      multiple: false,
      labels: {
        title: __('Media area')
      }
    }), relatedPostsLinkOption && mediaType && mediaUrl && relatedPosts?.length > 1 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
      class: "dashicons dashicons-list-view",
      title: "Multiple appearances"
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {}), relatedPostsLinkOption && mediaType && mediaUrl && (!mediaAnchor || mediaAnchor == '-1') ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
      class: "dashicons dashicons-editor-unlink",
      title: "No link attached"
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {})]
  });
  return mediaAnchor && mediaAnchor !== '-1' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("figure", {
    ...(figureProps || {
      className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`
    }),
    style: {
      aspectRatio: aspectRatio
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
      children: figureContent
    })
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("figure", {
    ...(figureProps || {
      className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`
    }),
    style: {
      aspectRatio: aspectRatio
    },
    children: figureContent
  });
};
const MediaSave = ({
  mediaType,
  mediaUrl,
  mediaAlt,
  mediaId,
  mediaSizeSlug,
  mediaOrientation,
  mediaAnchor,
  relatedPostsLinkOption,
  relatedPosts,
  mediaCustomPosition,
  aspectRatio,
  originalAspectRatio,
  controls,
  autoplay,
  loop,
  muted,
  playsinline,
  preload,
  poster,
  figureProps
}) => {
  const addVerticalPositioning = (0,_functions__WEBPACK_IMPORTED_MODULE_0__.verticalPositioning)(mediaOrientation, originalAspectRatio, aspectRatio);
  const figureContent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [mediaType === 'image' && mediaUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
      src: mediaUrl,
      alt: mediaAlt,
      className: `wp-image-${mediaId} size-${mediaSizeSlug}${mediaOrientation ? ' is-' + mediaOrientation : ''}`,
      style: 'unset' !== aspectRatio ? {
        aspectRatio: aspectRatio,
        objectFit: 'cover',
        ...(mediaCustomPosition >= 0 && mediaCustomPosition !== 50 ? {
          objectPosition: `${addVerticalPositioning ? '50% ' : ''}${mediaCustomPosition}%${!addVerticalPositioning ? ' 50%' : ''}`
        } : {})
      } : {}
    }), mediaType === 'video' && mediaUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("video", {
      controls: controls,
      autoPlay: autoplay,
      loop: loop,
      muted: muted,
      playsInline: playsinline,
      preload: preload,
      poster: poster,
      className: `wp-video-${mediaId}`,
      style: 'unset' !== aspectRatio ? {
        aspectRatio: aspectRatio,
        objectFit: 'cover',
        ...(mediaCustomPosition >= 0 && mediaCustomPosition !== 50 ? {
          objectPosition: `${addVerticalPositioning ? '50% ' : ''}${mediaCustomPosition}%${!addVerticalPositioning ? ' 50%' : ''}`
        } : {})
      } : null,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("source", {
        src: mediaUrl
      })
    })]
  });
  return mediaAnchor && mediaAnchor !== '-1' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("figure", {
    ...(figureProps || {
      className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`
    }),
    style: {
      aspectRatio: aspectRatio
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
      href: mediaAnchor + ( true ? '#wp-image-' + mediaId : 0),
      rel: "nofollow",
      children: figureContent
    })
  }) /*todo*/ : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("figure", {
    ...(figureProps || {
      className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`
    }),
    style: {
      aspectRatio: aspectRatio
    },
    children: figureContent
  });
};
const PanelBodyMedia = ({
  mediaType,
  mediaId,
  mediaUrl,
  mediaAlt,
  mediaSizeSlug,
  mediaOrientation,
  mediaAnchor,
  relatedPostsLinkOption,
  relatedPosts,
  mediaCustomPosition,
  aspectRatio,
  originalAspectRatio,
  controls,
  autoplay,
  loop,
  muted,
  playsinline,
  preload,
  poster,
  posterId,
  open,
  setAttributes
}) => {
  const addVerticalPositioning = (0,_functions__WEBPACK_IMPORTED_MODULE_0__.verticalPositioning)(mediaOrientation, originalAspectRatio, aspectRatio);
  const imageSizes = wp.data.select('core/block-editor').getSettings().imageSizes;
  const getImageSizeOptions = () => imageSizes.map(size => ({
    label: size.name,
    value: size.slug
  }));
  const availableSizes = useSelect(select => mediaId ? select('core').getMedia(mediaId)?.media_details?.sizes : [], [mediaId]);
  const onChangeImageSize = sizeSlug => {
    if (availableSizes && availableSizes[sizeSlug]) {
      setAttributes({
        mediaSizeSlug: sizeSlug,
        mediaUrl: availableSizes[sizeSlug].source_url
      });
    }
  };
  const onChangeAltText = alt => {
    setAttributes({
      mediaAlt: alt
    });
  };
  const onChangePoster = posterMedia => {
    setAttributes({
      poster: posterMedia.url,
      posterId: posterMedia.id
    });
  };
  const onRemovePoster = setAttributes => {
    setAttributes({
      poster: '',
      posterId: 0
    });
  };

  //console.log(aspectRatio);

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(Fragment, {
    children: [mediaType && mediaUrl ? mediaType === 'image' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(PanelBody, {
      title: __('Image Settings'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(TextareaControl, {
        label: __('Alternative Text'),
        value: mediaAlt,
        onChange: onChangeAltText,
        help: __('Describe the purpose of the image. Leave empty if the image is purely decorative.')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SelectControl, {
        label: __('Image Resolution'),
        value: mediaSizeSlug,
        options: getImageSizeOptions(),
        onChange: onChangeImageSize
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SelectControl, {
        label: "Aspect Ratio",
        value: aspectRatio,
        options: [{
          label: 'Unset',
          value: 'unset'
        }, {
          label: '1:1',
          value: '1/1'
        }, {
          label: '2:1',
          value: '2/1'
        }, {
          label: '3:1',
          value: '27/10'
        }, {
          label: '3:2',
          value: '3/2'
        }, {
          label: '4:3',
          value: '4/3'
        }, {
          label: '16:9',
          value: '16/9'
        }, {
          label: '2:3',
          value: '2/3'
        }, {
          label: '3:4',
          value: '3/4'
        }, {
          label: '1:2',
          value: '20/37'
        }],
        onChange: newRatio => {
          setAttributes({
            aspectRatio: newRatio
          });
        }
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(PanelBody, {
      title: __('Video Settings'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ToggleControl, {
        label: __('Autoplay'),
        checked: autoplay,
        onChange: () => setAttributes({
          autoplay: !autoplay
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ToggleControl, {
        label: __('Loop'),
        checked: loop,
        onChange: () => setAttributes({
          loop: !loop
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ToggleControl, {
        label: __('Muted'),
        checked: muted,
        onChange: () => setAttributes({
          muted: !muted
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ToggleControl, {
        label: __('Playback Controls'),
        checked: controls,
        onChange: () => setAttributes({
          controls: !controls
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ToggleControl, {
        label: __('Play Inline'),
        checked: playsinline,
        onChange: () => setAttributes({
          playsinline: !playsinline
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SelectControl, {
        label: __('Preload'),
        value: preload,
        options: [{
          label: 'Auto',
          value: 'auto'
        }, {
          label: 'Metadata',
          value: 'metadata'
        }, {
          label: 'None',
          value: 'none'
        }],
        onChange: value => setAttributes({
          preload: value
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SelectControl, {
        label: "Aspect Ratio",
        value: aspectRatio,
        options: [{
          label: 'Unset',
          value: 'unset'
        }, {
          label: '1:1',
          value: '1/1'
        }, {
          label: '2:1',
          value: '2/1'
        }, {
          label: '3:1',
          value: '27/10'
        }, {
          label: '3:2',
          value: '3/2'
        }, {
          label: '4:3',
          value: '4/3'
        }, {
          label: '16:9',
          value: '16/9'
        }, {
          label: '2:3',
          value: '2/3'
        }, {
          label: '3:4',
          value: '3/4'
        }, {
          label: '1:2',
          value: '20/37'
        }],
        onChange: newRatio => setAttributes({
          aspectRatio: newRatio
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(MediaUploadCheck, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(MediaUpload, {
          onSelect: posterMedia => onChangePoster(posterMedia, setAttributes),
          allowedTypes: ['image'],
          value: posterId,
          render: ({
            open
          }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Button, {
              type: "button",
              "aria-describedby": "video-block__poster-image-description",
              className: "components-button is-primary",
              onClick: open,
              children: poster ? __('Replace Poster Image') : __('Select Poster Image')
            }), poster && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Button, {
              type: "button",
              className: "components-button is-secondary",
              onClick: () => onRemovePoster(setAttributes),
              children: __('Remove Poster Image')
            })]
          })
        })
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {}), mediaType && mediaUrl && relatedPostsLinkOption && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(PanelBody, {
      title: __(`${mediaType === 'image' ? 'Image' : 'Video'} Link`, 'myconianhotel'),
      children: relatedPosts.length ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(BaseControl, {
        help: "Link image to a related Page or Post.",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(SelectControl, {
          label: "",
          value: mediaAnchor,
          options: [{
            label: 'None',
            value: '-1'
          }, ...relatedPosts],
          onChange: link => setAttributes({
            mediaAnchor: link
          })
        })
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(BaseControl, {
        help: "No related Page or Post found. Enter a URL manually.",
        className: "myconianhotel-linkcontrol-wrapper",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(LinkControl, {
          value: {
            url: !mediaAnchor || mediaAnchor == '-1' ? '' : mediaAnchor
          },
          onChange: newValue => {
            setAttributes({
              mediaAnchor: newValue.url
            });
          },
          withCreateSuggestion: true,
          forceIsEditingLink: true
        }, mediaId), mediaAnchor && mediaAnchor !== '-1' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Button, {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"],
          label: "Unlink",
          isDestructive: true,
          onClick: () => setAttributes({
            mediaAnchor: ''
          })
        })]
      })
    }), mediaType && mediaUrl && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(PanelBody, {
      title: __(`${mediaType === 'image' ? 'Image' : 'Video'} Positioning`, 'myconianhotel'),
      children: 'unset' !== aspectRatio ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(Flex, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(FlexItem, {
          style: {
            flexGrow: 1
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(RangeControl, {
            label: addVerticalPositioning ? __('Vertical (Default: 50%)', 'myconianhotel') : __('Horizontal (Default: 50%)', 'myconianhotel'),
            value: mediaCustomPosition,
            onChange: value => setAttributes({
              mediaCustomPosition: value
            }),
            min: 0,
            max: 100
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(FlexItem, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
            children: "%"
          })
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
        children: __('Does not apply when aspect ratio is unset.', 'myconianhotel')
      })
    })]
  });
};
const MediaUploadMedia = ({
  mediaId,
  setAttributes
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(MediaUpload, {
    onSelect: (media, mediaSizeSlug) => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onSelectMedia)(media, mediaSizeSlug, setAttributes),
    allowedTypes: ['image', 'video'],
    value: mediaId,
    render: ({
      open
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Button, {
      onClick: open,
      children: "Replace"
    })
  });
};

/***/ }),

/***/ "./blocks/media/src/functions.js":
/*!***************************************!*\
  !*** ./blocks/media/src/functions.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   onSelectMedia: () => (/* binding */ onSelectMedia),
/* harmony export */   verticalPositioning: () => (/* binding */ verticalPositioning)
/* harmony export */ });
const onSelectMedia = (media, mediaSizeSlug, setAttributes) => {
  const type = media.type === 'video' ? 'video' : 'image';
  setAttributes({
    mediaId: media.id,
    mediaUrl: media.sizes ? media.sizes[mediaSizeSlug]?.url || media.url : media.url,
    mediaAlt: media.alt || '',
    mediaType: type,
    mediaOrientation: media.height > media.width ? 'portrait' : 'landscape',
    originalAspectRatio: media.width / media.height
  });
};
const verticalPositioning = (mediaOrientation, originalAspectRatio, aspectRatio, cnsl = false) => {
  let addVerticalPositioning = false;
  if ('unset' !== aspectRatio) {
    if ('portrait' == mediaOrientation) {
      addVerticalPositioning = true;
      try {
        if (originalAspectRatio > eval(aspectRatio)) {
          addVerticalPositioning = false;
        }
      } catch {}
    } else if ('landscape' == mediaOrientation) {
      addVerticalPositioning = false;
      try {
        if (originalAspectRatio < eval(aspectRatio)) {
          addVerticalPositioning = true;
        }
      } catch {}
    }
  } else {
    if ('portrait' == mediaOrientation) {
      addVerticalPositioning = true;
    }
  }
  return addVerticalPositioning;
};

/***/ }),

/***/ "./blocks/modules.js":
/*!***************************!*\
  !*** ./blocks/modules.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomPanelColorSettings: () => (/* binding */ CustomPanelColorSettings),
/* harmony export */   IconSet: () => (/* binding */ IconSet)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  PanelColorSettings
} = wp.blockEditor;
const {
  useSelect
} = wp.data;
const CustomPanelColorSettings = props => {
  const {
    setAttributes,
    backgroundColor,
    mediaBacgroundColor,
    palette,
    secondary
  } = props;

  // Get theme-defined palette & filter colors
  const colors = useSelect(select => {
    const settings = select('core/block-editor').getSettings();
    const allColors = settings.colors || [];

    // First, find the color value of the 'darkblue' slug
    const darkblueEntry = allColors.find(color => color.slug === 'darkblue');
    const darkblueColor = darkblueEntry?.color;
    return allColors.filter(color => {
      // Keep only if it's in the palette
      if (!palette.includes(color.slug)) return false;

      // If it's the 'darkblue' entry, keep it
      if (color.slug === 'darkblue') return true;

      // Exclude any other entry with the same color value as 'darkblue'
      return color.color !== darkblueColor;
    });
  }, []);
  if (!secondary) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PanelColorSettings, {
      title: "Color (M)",
      colorSettings: [{
        value: colors.find(c => c.slug === backgroundColor)?.color || undefined,
        onChange: newColor => {
          const matched = colors.find(c => c.color === newColor);
          setAttributes({
            backgroundColor: matched?.slug || undefined
          });
        },
        label: 'Background color',
        colors
      }]
    });
  } else {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PanelColorSettings, {
      title: "",
      className: "custom-panel-color-settings",
      colorSettings: [{
        value: colors.find(c => c.slug === mediaBacgroundColor)?.color || undefined,
        onChange: newColor => {
          const matched = colors.find(c => c.color === newColor);
          setAttributes({
            mediaBacgroundColor: matched?.slug || undefined
          });
        },
        label: 'Background color',
        colors
      }]
    });
  }
};


const IconSet = {
  animationTypo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M0,0v20h20V0H0ZM12.6,16.2l-1.6-3.8h-5.1s-1.6,3.7-1.6,3.7h-1.3S8.3,3.8,8.3,3.8h.9s5.3,12.4,5.3,12.4h-1.9ZM16,16.2L10.7,3.8h1l5.3,12.4h-1ZM8.4,6.5l2.2,5h-4.3s2.1-5,2.1-5Z"
    })
  }),
  archive: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.2",
      y: "2.2",
      width: "7",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "3.5",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "6.5",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.2",
      y: "10.8",
      width: "7",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "12",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "15",
      width: "3",
      height: "1.5"
    })]
  }),
  bookForm: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "5.7",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "5.7",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "8.7",
      width: "8.8",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "11.6 17.3 8.4 14.3 9.4 13.2 11.5 15.2 14.9 11.7 16 12.7 11.6 17.3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "2.7",
      width: "12",
      height: "1.5"
    })]
  }),
  contact: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M9.8,9.3L2,5h16l-8.2,4.3ZM9.8,11.3L2,6v9h16V6l-8.2,5.3Z"
    })
  }),
  filesText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "11",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "8 15.6 3 15.6 3 4.4 10.5 4.4 10.5 13.1 8 15.6"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "6.8 12.1 6.8 14.7 9.5 12.1 6.8 12.1",
      fill: "#FFFFFF"
    })]
  }),
  freeText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "3.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "6.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "9.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "12.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "15.2",
      width: "8",
      height: "1.5"
    })]
  }),
  gallery: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "6.5",
      width: "3.9",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.1",
      y: "6.5",
      width: "3.9",
      height: "7"
    })]
  }),
  galleryText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "10.8",
      width: "5",
      height: "1.5"
    })]
  }),
  googleMap: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M14.2,11.1h0c.5-.8.8-1.7.8-2.8,0-2.8-2.2-5-5-5s-5,2.2-5,5,.3,2,.8,2.8h0,0s0,0,0,0l4.1,5.4,4.1-5.4s0,0,0,0h0ZM10,6.9c.8,0,1.5.7,1.5,1.5s-.7,1.5-1.5,1.5-1.5-.7-1.5-1.5.7-1.5,1.5-1.5Z"
    })
  }),
  hero: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M2,4.1v9h16V4.1H2ZM8.3,5.7c.8,0,1.5.7,1.5,1.5s-.7,1.5-1.5,1.5-1.5-.7-1.5-1.5.7-1.5,1.5-1.5ZM16.5,11.6H3.5s.7-1.8,2.7-2.4c2.1-.5,2,1.9,3.5,1.4,1.5-.5,2.7-5.1,4.9-4.4,2.2.7,1.8,5.3,1.8,5.3Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5",
      y: "14.4",
      width: "10",
      height: "1.5"
    })]
  }),
  hotels: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M14.5.8h-7c-.6,0-1,.4-1,1v3H1.5c-.6,0-1,.4-1,1v7.5h8.5v-3.5c0-.1,0-.2,0-.3,0,0,0,0,0-.1,0,0,0,0,0-.1,0-.1.2-.2.3-.3.1,0,.3-.2.5-.2h5.5V1.8c0-.6-.4-1-1-1ZM5,10.8h-3v-3h3v3ZM11,6.8h-1.5v-1c0-.6-.4-1-1-1h-.5v-1h3v3Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15",
      y: "11.2",
      width: "3",
      height: "5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.5",
      y: "11.8",
      width: "3",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9",
      y: "17.8",
      width: "10.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: ".5",
      y: "14.8",
      width: "8.5",
      height: "1.5"
    })]
  }),
  interactiveTypo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M0,0v20h20V0H0ZM11.3,16.2l-1.6-3.8h-5.1s-1.6,3.7-1.6,3.7h-1.3S7,3.8,7,3.8h.9s5.3,12.4,5.3,12.4h-1.9ZM17.8,10.8l-1.1,1.1-2.4-2.3-1.4,2.6-3.5-8.4,8.9,3.6-2.8,1.2,2.3,2.3ZM7.1,6.5l2.2,5h-4.3s2.1-5,2.1-5Z"
    })
  }),
  masonry: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "1.8",
      width: "10",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "13.5",
      y: "1.8",
      width: "4.5",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "7.8",
      width: "16",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "13.8",
      width: "4.5",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "8",
      y: "13.8",
      width: "10",
      height: "4.5"
    })]
  }),
  media: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M16.5,5.5v9H3.5V5.5h13M18,4H2v12h16V4h0Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M3.5,14.5s.7-1.8,2.7-2.4,2,1.9,3.5,1.4,2.7-5.1,4.9-4.4,1.8,5.3,1.8,5.3H3.5Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("circle", {
      cx: "8.3",
      cy: "10",
      r: "1.5"
    })]
  }),
  mediaText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1.8",
      y: "5.5",
      width: "9",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.2",
      y: "7.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.2",
      y: "10.8",
      width: "6",
      height: "1.5"
    })]
  }),
  mediaTextHero: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M20,3H0v14h20V3ZM10.2,14H2.2V6h8v8ZM17.2,12.2h-5v-1.5h5v1.5ZM12.2,9.2v-1.5h5v1.5h-5Z"
    })
  }),
  mediaTextSlide: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "0",
      y: "7.8",
      width: "5.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "0",
      y: "10.8",
      width: "5.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M10.5,0v5.5h-3.5v9h3.5v5.5h9.5V0h-9.5ZM17.5,12.2h-5.5v-1.5h5.5v1.5ZM17.5,9.2h-5.5v-1.5h5.5v1.5Z"
    })]
  }),
  offers: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M4.5,7.4c0-.9.2-1.5.6-2s.9-.6,1.6-.6,1.2.2,1.6.6.6,1.1.6,2-.2,1.5-.6,2-.9.6-1.6.6-1.2-.2-1.6-.6-.6-1.1-.6-2ZM6,7.4c0,.6,0,1.1.2,1.3.1.2.3.2.5.2s.4,0,.5-.2c.1-.2.2-.6.2-1.3s0-1.1-.2-1.3c-.1-.2-.3-.2-.5-.2s-.4,0-.5.2c-.1.2-.2.6-.2,1.3ZM8.1,15.2h-1.4l5.3-10.4h1.4l-5.2,10.4ZM11.1,12.6c0-.9.2-1.5.6-2s.9-.6,1.6-.6,1.2.2,1.6.6.6,1.1.6,2-.2,1.5-.6,2-.9.6-1.6.6-1.2-.2-1.6-.6-.6-1.1-.6-2ZM12.6,12.6c0,.6,0,1.1.2,1.3.1.2.3.2.5.2s.4,0,.5-.2c.1-.2.2-.6.2-1.3s0-1.1-.2-1.3c-.1-.2-.3-.2-.5-.2s-.4,0-.5.2c-.1.2-.2.6-.2,1.3Z"
    })
  }),
  postAcfFields: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "12",
      width: "16",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "15",
      width: "16",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M7.9,8.9h-1.2l-.5-1.2h-2.1l-.4,1.2h-1.1l2.1-5.3h1.1l2.1,5.3ZM5.9,6.8l-.7-2-.7,2h1.5Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M11.9,7l1,.3c-.2.6-.4,1-.8,1.3-.4.3-.8.4-1.4.4s-1.3-.2-1.7-.7-.7-1.1-.7-2,.2-1.6.7-2.1c.5-.5,1.1-.7,1.8-.7s1.2.2,1.6.6c.2.2.4.6.5,1l-1.1.3c0-.3-.2-.5-.4-.7-.2-.2-.4-.2-.7-.2s-.7.1-1,.4c-.2.3-.4.7-.4,1.4s.1,1.2.4,1.4c.2.3.6.4.9.4s.5,0,.7-.3c.2-.2.4-.5.4-.9Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M13.8,8.9V3.6h3.7v.9h-2.6v1.3h2.2v.9h-2.2v2.3h-1.1Z"
    })]
  }),
  postInfo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "4.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "7.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "10.8",
      width: "15",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "13.8",
      width: "15",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "16.8",
      width: "10",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "1.8",
      width: "7.5",
      height: "7.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "1.8",
      width: "6",
      height: "1.5"
    })]
  }),
  postTeaser: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "4.2",
      width: "8.2",
      height: "5.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "11.2",
      width: "8.2",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "11.2",
      width: "8.2",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "14.2",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "14.2",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "4.2",
      width: "8.2",
      height: "5.5"
    })]
  }),
  postTeaserGallery: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "4",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "14.5",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "14.5",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "4",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "10.8",
      width: "5",
      height: "1.5"
    })]
  }),
  weather: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9.2",
      y: "1.5",
      width: "1.5",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M10,7.5c1.4,0,2.5,1.1,2.5,2.5s-1.1,2.5-2.5,2.5-2.5-1.1-2.5-2.5,1.1-2.5,2.5-2.5M10,6c-2.2,0-4,1.8-4,4s1.8,4,4,4,4-1.8,4-4-1.8-4-4-4h0Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5.8",
      y: "2.4",
      width: "1.5",
      height: "3",
      transform: "translate(-1.1 3.8) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "3.2",
      y: "5",
      width: "1.5",
      height: "3",
      transform: "translate(-3.7 6.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1.5",
      y: "9.2",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.4",
      y: "12.8",
      width: "3",
      height: "1.5",
      transform: "translate(-6.2 3.8) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5",
      y: "15.3",
      width: "3",
      height: "1.5",
      transform: "translate(-10.7 13.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9.2",
      y: "15.5",
      width: "1.5",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.8",
      y: "14.6",
      width: "1.5",
      height: "3",
      transform: "translate(-6.2 8.9) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15.3",
      y: "12",
      width: "1.5",
      height: "3",
      transform: "translate(-3.7 20.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15.5",
      y: "9.2",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14.6",
      y: "5.8",
      width: "3",
      height: "1.5",
      transform: "translate(-1.1 8.9) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "3.2",
      width: "3",
      height: "1.5",
      transform: "translate(3.3 13.7) rotate(-60)"
    })]
  }),
  widgetText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "10.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M9.8,14.2l-2.2-8.4h1.8l1.3,5.5,1.2-5.5h1.8l1.2,5.5,1.3-5.5h1.8l-2.2,8.4h-1.7l-1.2-5.4-1.2,5.4h-1.8Z"
    })]
  })
};

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/primitives":
/*!************************************!*\
  !*** external ["wp","primitives"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["primitives"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************************!*\
  !*** ./blocks/media-text/src/index.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./functions */ "./blocks/media-text/src/functions.js");
/* harmony import */ var _modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../modules */ "./blocks/modules.js");
/* harmony import */ var _attributes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./attributes */ "./blocks/media-text/src/attributes.js");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components */ "./blocks/media-text/src/components.js");
/* harmony import */ var _media_src_attributes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../media/src/attributes */ "./blocks/media/src/attributes.js");
/* harmony import */ var _media_src_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../media/src/components */ "./blocks/media/src/components.js");
/* harmony import */ var _animation_typo_src_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../animation-typo/src/components */ "./blocks/animation-typo/src/components.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
// https://chatgpt.com/c/66f696cc-36bc-8003-947a-46033b527297








const {
  __
} = wp.i18n;
const {
  registerBlockType
} = wp.blocks;
const {
  MediaUpload,
  InspectorControls,
  BlockControls,
  MediaUploadCheck,
  useBlockProps,
  MediaPlaceholder,
  useSetting
} = wp.blockEditor;
const {
  PanelBody,
  ToggleControl,
  TextareaControl,
  SelectControl,
  ToolbarButton,
  ToolbarGroup
} = wp.components;
const {
  useEffect,
  Fragment
} = wp.element;

// SVG Icons
const alignPullBottomIcon = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("svg", {
  class: "myconianhotel-svg-icon",
  xmlns: "http://www.w3.org/2000/svg",
  version: "1.1",
  viewBox: "0 0 20 20",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    fill: "#000000",
    x: "5",
    y: "3",
    width: "10",
    height: "2"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    fill: "#000000",
    x: "3",
    y: "11",
    width: "14",
    height: "6"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    fill: "#000000",
    x: "5",
    y: "7",
    width: "10",
    height: "2"
  })]
});
const alignPullTopIcon = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("svg", {
  class: "myconianhotel-svg-icon",
  xmlns: "http://www.w3.org/2000/svg",
  version: "1.1",
  viewBox: "0 0 20 20",
  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    x: "5",
    y: "11",
    width: "10",
    height: "2"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    x: "3",
    y: "3",
    width: "14",
    height: "6"
  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("rect", {
    x: "5",
    y: "15",
    width: "10",
    height: "2"
  })]
});

// Scheme variations
const hasAlternativeStyle = true;
registerBlockType('myconianhotel/media-text', {
  apiVersion: 2,
  title: __('Media & Text (M)'),
  description: __('A two-column layout with an image or video on one side and text on the other.'),
  icon: _modules__WEBPACK_IMPORTED_MODULE_1__.IconSet.mediaText,
  category: 'layout',
  attributes: {
    ..._attributes__WEBPACK_IMPORTED_MODULE_2__["default"],
    ..._media_src_attributes__WEBPACK_IMPORTED_MODULE_4__["default"],
    hasMediaPositionOption: {
      type: 'bool',
      default: true
    },
    isMediaTextSlide: {
      type: 'bool',
      default: false
    },
    extraClassName: {
      type: 'string',
      default: ''
    },
    mediaContent: {
      type: 'string',
      default: 'media'
    },
    mediaBacgroundColor: {
      type: 'string',
      default: ''
    }
  },
  supports: {
    //align: ['full'], // Only allow align full
    anchor: true,
    media: true
    /*color: {
        background: true, // Native background color support
    }*/
  },
  edit: props => {
    const {
      attributes,
      setAttributes,
      clientId
    } = props;
    const {
      mediaId,
      mediaUrl,
      mediaAlt,
      mediaSizeSlug,
      mediaCustomPosition,
      mediaOrientation,
      aspectRatio,
      mediaType,
      autoplay,
      loop,
      muted,
      controls,
      playsinline,
      preload,
      poster,
      posterId,
      mediaPosition,
      backgroundColor,
      className,
      hasMediaPositionOption,
      hasAspectRatioOption,
      isMediaTextSlide,
      extraClassName,
      mediaContent,
      chosenTemplate,
      mediaBacgroundColor
    } = attributes;
    const defaultBackgroundSlug = useSetting('custom.defaultBackgroundSlug');
    const mediaTextDefaultBackgroundSlug = useSetting('custom.mediaTextDefaultBackgroundSlug');
    useEffect(() => {
      if (!backgroundColor) {
        setAttributes({
          backgroundColor: defaultBackgroundSlug
        });
      }
    }, []);
    useEffect(() => {
      if (!mediaBacgroundColor) {
        setAttributes({
          mediaBacgroundColor: 'darkblue'
        });
      }
    }, []);

    // Initialize the registered style and media position (media-text-slide)
    useEffect(() => {
      if (!hasMediaPositionOption) {
        setAttributes({
          mediaPosition: 'right',
          className: 'is-style-default'
        });
      }
    }, [className]);

    // Apply default style when media position is bottom
    /*useEffect(() => {
        if (mediaPosition === 'bottom') {
            setAttributes({className: 'is-style-default'});
        }
    }, [className, mediaPosition]);*/

    // Snippet for existing blocks
    useEffect(() => {
      if ((mediaPosition == 'bottom' || mediaPosition == 'top') && !className?.includes('is-style-alternative')) {
        setAttributes({
          className: className?.replace('is-layout-constrained', '')
        });
      }
    }, []);

    // Position relative to style
    useEffect(() => {
      if (props.attributes.className?.includes('is-style-sticky')) {
        setAttributes({
          mediaPosition: 'right'
        });
      }
      if (props.attributes.className?.includes('is-style-animationtypo')) {
        setAttributes({
          mediaPosition: ''
        });
      }
    }, [className]);

    // Apply ratio based on media position & style
    useEffect(() => {
      if ('bottom' == mediaPosition) {
        setAttributes({
          aspectRatio: '16/9'
        });
      } else if ('top' == mediaPosition) {
        if (className?.includes('is-style-alternative')) {
          setAttributes({
            aspectRatio: '2/1'
          });
        } else {
          setAttributes({
            aspectRatio: '16/9'
          });
        }
      } else {
        if ('collection' == myconianhotelBlockMediaText.colorscheme) {
          if (!isMediaTextSlide) {
            setAttributes({
              aspectRatio: '4/3'
            });
          }
        } else {
          setAttributes({
            aspectRatio: '1/1'
          });
        }
      }
    }, [mediaPosition, className]);

    // Construct block classNames
    const blockProps = useBlockProps({
      className: ['wp-block-media-text',
      // Default class
      backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '',
      // Color class
      extraClassName ? extraClassName : '', props.attributes.align ? `align${props.attributes.align}` : 'none',
      // Align classes
      'is-stacked-on-mobile',
      // Mobile stacking class
      (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'has-global-padding' : '',
      // Global padding class
      (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '',
      // Constrain class
      mediaPosition === 'right' ? 'has-media-on-the-right' : mediaPosition === 'bottom' ? 'has-media-on-the-bottom' : mediaPosition === 'top' ? 'has-media-on-the-top' : '' // Media positioning class
      ].filter(Boolean).join(' ') // Filter out empty class values
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(BlockControls, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(ToolbarGroup, {
          children: hasMediaPositionOption && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(Fragment, {
            children: ['collection' !== myconianhotelBlockMediaText.colorscheme && !props.attributes.className?.includes('is-style-animationtypo') && !props.attributes.className?.includes('is-style-sticky') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(ToolbarButton, {
                icon: "align-pull-left",
                label: __('Show media on left'),
                isActive: mediaPosition === 'left',
                onClick: () => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onChangeMediaPosition)('left', setAttributes)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(ToolbarButton, {
                icon: alignPullTopIcon,
                label: __('Show media on top'),
                isActive: mediaPosition === 'top',
                onClick: () => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onChangeMediaPosition)('top', setAttributes)
              })]
            }), !props.attributes.className?.includes('is-style-animationtypo') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(ToolbarButton, {
              icon: "align-pull-right",
              label: __('Show media on right'),
              isActive: mediaPosition === 'right',
              onClick: () => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onChangeMediaPosition)('right', setAttributes)
            }), !props.attributes.className?.includes('is-style-animationtypo') && !props.attributes.className?.includes('is-style-sticky') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(ToolbarButton, {
              icon: alignPullBottomIcon,
              label: __('Show media on bottom'),
              isActive: mediaPosition === 'bottom',
              onClick: () => (0,_functions__WEBPACK_IMPORTED_MODULE_0__.onChangeMediaPosition)('bottom', setAttributes)
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_5__.MediaUploadMedia, {
          mediaId: mediaId,
          setAttributes: setAttributes // unnecessary (?)
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(InspectorControls, {
        children: [!isMediaTextSlide && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_modules__WEBPACK_IMPORTED_MODULE_1__.CustomPanelColorSettings, {
          setAttributes: setAttributes,
          backgroundColor: backgroundColor,
          palette: 'collection' == myconianhotelBlockMediaText.colorscheme ? ['lightergray', 'white'] : ['darkblue', 'black', 'lightbrown', 'darkgray', 'lightgray', 'white']
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(PanelBody, {
          title: __('Template Settings', 'myconianhotel'),
          initialOpen: true,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(SelectControl, {
            label: __('Select Media Type', 'myconianhotel'),
            value: mediaContent,
            options: 'collection' == myconianhotelBlockMediaText.colorscheme ? [{
              label: __('Image or Video', 'myconianhotel'),
              value: 'media'
            }] : [{
              label: __('Image or Video', 'myconianhotel'),
              value: 'media'
            }, {
              label: __('Animation', 'myconianhotel'),
              value: 'animation-typo'
            }],
            onChange: newMediaContent => setAttributes({
              mediaContent: newMediaContent
            })
          }), 'collection' !== myconianhotelBlockMediaText.colorscheme && 'animation-typo' == mediaContent && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_modules__WEBPACK_IMPORTED_MODULE_1__.CustomPanelColorSettings, {
            setAttributes: setAttributes,
            mediaBacgroundColor: mediaBacgroundColor,
            palette: ['darkblue', 'lightbrown'],
            secondary: true
          })]
        }), 'media' == mediaContent && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_5__.PanelBodyMedia, {
          mediaType: mediaType,
          mediaId: mediaId,
          mediaAlt: mediaAlt,
          mediaUrl: mediaUrl,
          mediaSizeSlug: mediaSizeSlug,
          mediaCustomPosition: mediaCustomPosition,
          mediaOrientation: mediaOrientation,
          aspectRatio: aspectRatio,
          open: open,
          controls: controls,
          autoplay: autoplay,
          loop: loop,
          muted: muted,
          playsinline: playsinline,
          preload: preload,
          poster: poster,
          posterId: posterId,
          setAttributes: setAttributes
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        ...blockProps,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("textarea", {
          style: {
            border: '0',
            clip: 'rect(1px, 1px, 1px, 1px)',
            clipPath: 'inset(50%)',
            height: '1px',
            margin: '-1px',
            overflow: 'hidden',
            padding: '0',
            position: 'absolute',
            width: '1px',
            wordWrap: 'normal'
          }
        }), 'media' == mediaContent ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
          children: 'bottom' !== mediaPosition && !className?.includes('is-style-animationtypo') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_5__.MediaEdit, {
            mediaType: mediaType,
            mediaUrl: mediaUrl,
            mediaAlt: mediaAlt,
            mediaId: mediaId,
            mediaSizeSlug: mediaSizeSlug,
            mediaCustomPosition: mediaCustomPosition,
            mediaOrientation: mediaOrientation,
            aspectRatio: aspectRatio,
            controls: controls,
            autoplay: autoplay,
            loop: loop,
            muted: muted,
            playsinline: playsinline,
            preload: preload,
            poster: poster,
            figureProps: {
              className: 'wp-block-media-text__media'
            },
            setAttributes: setAttributes
          })
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: `wp-block-media-text__media ${mediaBacgroundColor ? `has-${mediaBacgroundColor}-background-color has-background` : ''} ${mediaBacgroundColor == 'darkblue' ? 'has-black-color has-color' : ''} `,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_animation_typo_src_components__WEBPACK_IMPORTED_MODULE_6__.AmbientAnimation, {})
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_components__WEBPACK_IMPORTED_MODULE_3__.ContentEdit, {
          mediaType: mediaType,
          mediaUrl: mediaUrl,
          mediaAlt: mediaAlt,
          mediaId: mediaId,
          mediaSizeSlug: mediaSizeSlug,
          mediaCustomPosition: mediaCustomPosition,
          mediaOrientation: mediaOrientation,
          aspectRatio: aspectRatio,
          controls: controls,
          autoplay: autoplay,
          loop: loop,
          muted: muted,
          playsinline: playsinline,
          preload: preload,
          poster: poster,
          figureProps: false,
          setAttributes: setAttributes,
          mediaPosition: mediaPosition,
          chosenTemplate: chosenTemplate,
          className: className,
          clientId: clientId
        })]
      })]
    });
  },
  save: props => {
    const {
      attributes
    } = props;
    const {
      mediaId,
      mediaUrl,
      mediaAlt,
      mediaPosition,
      mediaSizeSlug,
      mediaCustomPosition,
      mediaOrientation,
      aspectRatio,
      mediaType,
      autoplay,
      loop,
      muted,
      controls,
      playsinline,
      preload,
      poster,
      extraClassName,
      mediaContent,
      mediaBacgroundColor,
      backgroundColor,
      className
    } = attributes;
    const blockProps = useBlockProps.save({
      className: ['wp-block-myconianhotel-media-text wp-block-media-text',
      // Default class
      backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '',
      // Default class
      extraClassName ? extraClassName : '', props.attributes.align ? `align${props.attributes.align}` : 'none',
      // Align classes
      'is-stacked-on-mobile',
      // Mobile stacking class
      (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'has-global-padding' : '',
      // Global padding class
      (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '',
      // Constrain class
      mediaPosition === 'right' ? 'has-media-on-the-right' : mediaPosition === 'bottom' ? 'has-media-on-the-bottom' : mediaPosition === 'top' ? 'has-media-on-the-top' : '' // Media positioning class
      ].filter(Boolean).join(' ') // Filter out empty class values
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      ...blockProps,
      children: ['media' == mediaContent ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
        children: 'bottom' !== mediaPosition && !className?.includes('is-style-animationtypo') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_media_src_components__WEBPACK_IMPORTED_MODULE_5__.MediaSave, {
          mediaType: mediaType,
          mediaUrl: mediaUrl,
          mediaAlt: mediaAlt,
          mediaId: mediaId,
          mediaSizeSlug: mediaSizeSlug,
          mediaCustomPosition: mediaCustomPosition,
          mediaOrientation: mediaOrientation,
          aspectRatio: aspectRatio,
          controls: controls,
          autoplay: autoplay,
          loop: loop,
          muted: muted,
          playsinline: playsinline,
          preload: preload,
          poster: poster,
          figureProps: {
            className: 'wp-block-media-text__media'
          }
        })
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: `wp-block-media-text__media ${mediaBacgroundColor ? `has-${mediaBacgroundColor}-background-color has-background` : ''} ${mediaBacgroundColor == 'darkblue' ? 'has-black-color has-color' : ''} `,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_animation_typo_src_components__WEBPACK_IMPORTED_MODULE_6__.AmbientAnimation, {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_components__WEBPACK_IMPORTED_MODULE_3__.ContentSave, {
        mediaType: mediaType,
        mediaUrl: mediaUrl,
        mediaAlt: mediaAlt,
        mediaId: mediaId,
        mediaSizeSlug: mediaSizeSlug,
        mediaCustomPosition: mediaCustomPosition,
        mediaOrientation: mediaOrientation,
        aspectRatio: aspectRatio,
        controls: controls,
        autoplay: autoplay,
        loop: loop,
        muted: muted,
        playsinline: playsinline,
        preload: preload,
        poster: poster,
        figureProps: {
          className: 'wp-block-media-text__media'
        },
        mediaPosition: mediaPosition,
        className: className
      })]
    });
  }
});

// Register block styles for 'myconianhotel/media-text'

wp.blocks.registerBlockStyle('myconianhotel/media-text', [{
  name: 'alternative',
  label: 'Alternative style'
}, {
  name: 'sticky',
  label: 'Sticky style'
}, {
  name: 'animationtypo',
  label: 'With Interactive Typo'
}]);
})();

/******/ })()
;
//# sourceMappingURL=index.js.map