import { MediaEdit, MediaSave } from '../../media/src/components';

const { __ } = wp.i18n;
const {
    InnerBlocks,
    useInnerBlocksProps,
    useBlockProps
} = wp.blockEditor;
const { Fragment, useState, useEffect, useRef } = wp.element;
const { useSelect } = wp.data;

export const ContentEdit = (props) => {
    const { clientId, setAttributes, className, chosenTemplate } = props;   
    const { updateBlockAttributes, replaceInnerBlocks } = wp.data.dispatch('core/block-editor');
    // Track last chosen template
    const lastTemplateRef = useRef(chosenTemplate);
    
    const templates = {
        default: [
            ['myconianhotel/paragraph', {
                textAlign: 'center',
                fontSize: 'small',
                placeholder: __('Subtitle', 'myconianhotel')
            }],
            ['myconianhotel/heading', {
                level: 2,
                textAlign: 'center',
                placeholder: __('Heading', 'myconianhotel')
            }],
            ['myconianhotel/paragraph', {
                textAlign: 'center',
                placeholder: __('Content', 'myconianhotel')
            }],
            ['myconianhotel/buttons']
        ],
        sticky : [
            ['myconianhotel/free-text', {displayPresets: ['free', 'presetMediaText'], chosenTemplate: 'presetMediaText', isNested: true}]
        ],
        animationtypo : [
            ['myconianhotel/group', {
                className: 'wp-block-media-text__content is-layout-flow',
                'metadata': {
                    'name': 'Content'
                }
            }, [
                ['myconianhotel/paragraph', {
                    textAlign: 'center',
                    fontSize: 'small',
                    placeholder: __('Subtitle', 'myconianhotel')
                }],
                ['myconianhotel/heading', {
                    level: 2,
                    textAlign: 'center',
                    placeholder: __('Heading', 'myconianhotel')
                }],
                ['myconianhotel/paragraph', {
                    textAlign: 'center',
                    placeholder: __('Content', 'myconianhotel')
                }],
                ['myconianhotel/buttons']
            ]],
            ['myconianhotel/animation-typo', {backgroundColor: 'darkblue', color: 'darkblue'}]
        ]
    };

    // Snippet for existing sticky media texts
    const existingBlocks = useSelect(
        (select) => select('core/block-editor').getBlocks(clientId),
        [clientId]
    );

    // Template depends on className
    useEffect(() => {
        let style = 'default'
        if (className?.includes('is-style-sticky')) {
            style = 'sticky'
        } else if (className?.includes('is-style-animationtypo')) {
            style = 'animationtypo'
        }
        setAttributes({chosenTemplate: style});
    }, [className])

    // Update innerblocks based on chosen template
    useEffect(() => {
        if (lastTemplateRef.current !== chosenTemplate) {
            // Snippet for existing sticky media text to preserve content on paste
            let updatedChosenTemplate = [];
            if ('sticky' == chosenTemplate && existingBlocks.length) {
                existingBlocks.forEach((block, index) => {
                    console.log(block);
                    if ('myconianhotel/free-text' == block.name) {
                        updatedChosenTemplate.push(block);
                    }
                });
            }
            // Replace innerblocks
            replaceInnerBlocks(clientId, wp.blocks.createBlocksFromInnerBlocksTemplate(updatedChosenTemplate.length ? updatedChosenTemplate : templates[chosenTemplate]));
            lastTemplateRef.current = chosenTemplate;
        }
    }, [chosenTemplate, clientId]);

    const innerBlocksProps = useInnerBlocksProps({
        className: 'wp-block-media-text__content is-layout-flow',
    }, {
        template: templates[chosenTemplate],
        templateLock: 'all',
        allowedBlocks: []        
    });    

    return ( 'bottom' == props.mediaPosition || props.className?.includes('is-style-animationtypo') ?
        (
        <div className={`${! props.className?.includes('is-style-animationtypo') ? 'wp-block-media-text__content is-layout-flow' : 'wp-block-media-text__grid'}`}>
            {innerBlocksProps.children}
            <MediaEdit
                mediaType={props.mediaType}
                mediaUrl={props.mediaUrl}
                mediaAlt={props.mediaAlt}
                mediaId={props.mediaId}
                mediaSizeSlug={props.mediaSizeSlug}
                mediaCustomPosition={props.mediaCustomPosition}
                aspectRatio={props.aspectRatio}
                controls={props.controls}
                autoplay={props.autoplay}
                loop={props.loop}
                muted={props.muted}
                playsinline={props.playsinline}
                preload={props.preload}
                poster={props.poster}
                setAttributes={props.setAttributes}
                figureProps={
                    {className:'wp-block-media-text__media'}
                }
            />
        </div>
        ) : (<div {...innerBlocksProps}></div>)
    );
}

export const ContentSave = (props) => {
    const innerBlocksProps = useInnerBlocksProps.save({
        className: 'wp-block-media-text__content is-layout-flow'
    });
    return ( 'bottom' == props.mediaPosition || props.className?.includes('is-style-animationtypo') ?
        (
        <div className={`${! props.className?.includes('is-style-animationtypo') ? 'wp-block-media-text__content is-layout-flow' : 'wp-block-media-text__grid'}`}>
            {innerBlocksProps.children}
            <MediaSave
                mediaType={props.mediaType}
                mediaUrl={props.mediaUrl}
                mediaAlt={props.mediaAlt}
                mediaId={props.mediaId}
                mediaSizeSlug={props.mediaSizeSlug}
                mediaCustomPosition={props.mediaCustomPosition}
                aspectRatio={props.aspectRatio}
                controls={props.controls}
                autoplay={props.autoplay}
                loop={props.loop}
                muted={props.muted}
                playsinline={props.playsinline}
                preload={props.preload}
                poster={props.poster}
                figureProps={props.figureProps}
                />
        </div>
        ) : (<div {...innerBlocksProps}></div>)
    );
}