// https://chatgpt.com/c/66f696cc-36bc-8003-947a-46033b527297
import { onChangeMediaPosition } from './functions';

import { CustomPanelColorSettings, IconSet } from '../../modules';
import MediaTextAttributes from './attributes';
import { ContentEdit, ContentSave } from './components';

import MediaAttributes from '../../media/src/attributes';
import { MediaEdit, MediaSave, MediaUploadMedia, PanelBodyMedia } from '../../media/src/components';
import { AmbientAnimation } from '../../animation-typo/src/components';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { 
    MediaUpload, 
    InspectorControls,
    BlockControls, 
    MediaUploadCheck, 
    useBlockProps, 
    MediaPlaceholder,
    useSetting
} = wp.blockEditor;
const { 
    PanelBody, 
    ToggleControl, 
    TextareaControl, 
    SelectControl, 
    ToolbarButton, 
    ToolbarGroup
} = wp.components;
const { useEffect, Fragment } = wp.element;

// SVG Icons
const alignPullBottomIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect fill="#000000" x="5" y="3" width="10" height="2"/>
        <rect fill="#000000" x="3" y="11" width="14" height="6"/>
        <rect fill="#000000" x="5" y="7" width="10" height="2"/>
    </svg>
);    

const alignPullTopIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect x="5" y="11" width="10" height="2"/>
        <rect x="3" y="3" width="14" height="6"/>
        <rect x="5" y="15" width="10" height="2"/>
    </svg>
);    

// Scheme variations
const hasAlternativeStyle = true;

registerBlockType('myconianhotel/media-text', {
    apiVersion: 2,
    title: __('Media & Text (M)'),
    description: __('A two-column layout with an image or video on one side and text on the other.'),
    icon: IconSet.mediaText,
    category: 'layout',
    attributes: {
        ...MediaTextAttributes,
        ...MediaAttributes,
        hasMediaPositionOption: {
            type: 'bool',
            default: true
        },
        isMediaTextSlide: {
            type: 'bool',
            default: false
        },
        extraClassName: {
            type: 'string',
            default: ''
        },
        mediaContent: {
            type: 'string',
            default: 'media'
        },
        mediaBacgroundColor: {
            type: 'string',
            default: ''
        }
    },
    supports: {
        //align: ['full'], // Only allow align full
        anchor: true,
        media: true,
        /*color: {
            background: true, // Native background color support
        }*/
    },
    edit: (props) => {
        const { attributes, setAttributes, clientId } = props;
        const {
            mediaId, 
            mediaUrl, 
            mediaAlt,
            mediaSizeSlug,
            mediaCustomPosition,
            mediaOrientation,
            aspectRatio,
            mediaType,
            autoplay,
            loop,
            muted,
            controls,
            playsinline,
            preload,
            poster,
            posterId,
            mediaPosition,
            backgroundColor,
            className,
            hasMediaPositionOption,
            hasAspectRatioOption,
            isMediaTextSlide,
            extraClassName,
            mediaContent,
            chosenTemplate,
            mediaBacgroundColor
        } = attributes;

        const defaultBackgroundSlug = useSetting('custom.defaultBackgroundSlug');
        const mediaTextDefaultBackgroundSlug = useSetting('custom.mediaTextDefaultBackgroundSlug');

        useEffect(() => {
            if (! backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, []);
        
        useEffect(() => {
            if (! mediaBacgroundColor) {
                setAttributes({ mediaBacgroundColor: 'darkblue' });
            }
        }, []);
        
        // Initialize the registered style and media position (media-text-slide)
        useEffect(() => {
            if ( ! hasMediaPositionOption) {
                setAttributes(
                    {
                        mediaPosition: 'right',
                        className: 'is-style-default'
                    }
                );
            }
        }, [className]);

        // Apply default style when media position is bottom
        /*useEffect(() => {
            if (mediaPosition === 'bottom') {
                setAttributes({className: 'is-style-default'});
            }
        }, [className, mediaPosition]);*/

        // Snippet for existing blocks
        useEffect(() => {
            if ((mediaPosition == 'bottom' || mediaPosition == 'top') && ! className?.includes('is-style-alternative')) {
                setAttributes({ className: className?.replace('is-layout-constrained', '') });
            }
        }, []);         

        // Position relative to style
        useEffect(() => {
            if (props.attributes.className?.includes('is-style-sticky')) {
                setAttributes({ mediaPosition: 'right' });
            }
            if (props.attributes.className?.includes('is-style-animationtypo')) {
                setAttributes({ mediaPosition: '' });
            }
        }, [className]); 

        // Apply ratio based on media position & style
        useEffect(() => {
            if ('bottom' == mediaPosition) {
                setAttributes({ aspectRatio: '16/9' });                    
            } else if ('top' == mediaPosition) {
                if (className?.includes('is-style-alternative')) {
                    setAttributes({ aspectRatio: '2/1' });
                } else {
                    setAttributes({ aspectRatio: '16/9' });
                }
            } else {
                if ('collection' == myconianhotelBlockMediaText.colorscheme) {
                    if ( ! isMediaTextSlide ) {
                        setAttributes({ aspectRatio: '4/3' });
                    }
                } else {
                    setAttributes({ aspectRatio: '1/1' });                    
                }
            }
        }, [mediaPosition, className]);

        // Construct block classNames
        const blockProps = useBlockProps({
            className: [
                'wp-block-media-text', // Default class
                backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '', // Color class
                extraClassName ? extraClassName : '',
                props.attributes.align ? `align${props.attributes.align}` : 'none', // Align classes
                'is-stacked-on-mobile', // Mobile stacking class
                (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'has-global-padding' : '', // Global padding class
                (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '', // Constrain class
                mediaPosition === 'right' ? 'has-media-on-the-right' : (mediaPosition === 'bottom' ? 'has-media-on-the-bottom' : (mediaPosition === 'top' ? 'has-media-on-the-top' : '')), // Media positioning class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        return (
            <Fragment>
                <BlockControls>
                    <ToolbarGroup>
                        { hasMediaPositionOption && (
                        <Fragment>
                            { 'collection' !== myconianhotelBlockMediaText.colorscheme && ! props.attributes.className?.includes('is-style-animationtypo') && ! props.attributes.className?.includes('is-style-sticky') && (
                            <Fragment>
                                <ToolbarButton
                                    icon="align-pull-left"
                                    label={__('Show media on left')}
                                    isActive={mediaPosition === 'left'}
                                    onClick={() => onChangeMediaPosition('left', setAttributes)}
                                />
                                <ToolbarButton
                                    icon={alignPullTopIcon}
                                    label={__('Show media on top')}
                                    isActive={mediaPosition === 'top'}
                                    onClick={() => onChangeMediaPosition('top', setAttributes)}
                                />
                            </Fragment>
                            )}
                            { ! props.attributes.className?.includes('is-style-animationtypo') && (
                            <ToolbarButton
                                icon="align-pull-right"
                                label={__('Show media on right')}
                                isActive={mediaPosition === 'right'}
                                onClick={() => onChangeMediaPosition('right', setAttributes)}
                            />
                            )}
                            { ! props.attributes.className?.includes('is-style-animationtypo') && ! props.attributes.className?.includes('is-style-sticky') && (
                            <ToolbarButton
                                icon={alignPullBottomIcon}
                                label={__('Show media on bottom')}
                                isActive={mediaPosition === 'bottom'}
                                onClick={() => onChangeMediaPosition('bottom', setAttributes)}
                            />  
                            )}
                        </Fragment>
                        )}
                    </ToolbarGroup>
                    <MediaUploadMedia
                        mediaId={mediaId}
                        setAttributes={setAttributes} // unnecessary (?)
                    />
                </BlockControls>
                <InspectorControls>
                    { ! isMediaTextSlide && (
                    <CustomPanelColorSettings
                        setAttributes={setAttributes}
                        backgroundColor={backgroundColor}
                        palette={'collection' == myconianhotelBlockMediaText.colorscheme ? ['lightergray', 'white'] : ['darkblue', 'black', 'lightbrown', 'darkgray', 'lightgray', 'white'] }
                    />
                    )}
                    <PanelBody title={__('Template Settings', 'myconianhotel')} initialOpen={true}>
                        <SelectControl
                            label={__('Select Media Type', 'myconianhotel')}
                            value={mediaContent}
                            options={'collection' == myconianhotelBlockMediaText.colorscheme ?
                            [
                                { label: __('Image or Video', 'myconianhotel'), value: 'media' }
                            ] :
                            [
                                { label: __('Image or Video', 'myconianhotel'), value: 'media' },
                                { label: __('Animation', 'myconianhotel'), value: 'animation-typo' }
                            ]}
                            onChange={(newMediaContent) => setAttributes({ mediaContent: newMediaContent })}
                        />
                        {'collection' !== myconianhotelBlockMediaText.colorscheme && 'animation-typo' == mediaContent &&
                            (<CustomPanelColorSettings
                                setAttributes={setAttributes}
                                mediaBacgroundColor={mediaBacgroundColor}
                                palette={['darkblue', 'lightbrown']}
                                secondary={true}
                            />)
                        }
                    </PanelBody>
                    {
                        'media' == mediaContent && (
                        <PanelBodyMedia
                            mediaType={mediaType}
                            mediaId={mediaId}
                            mediaAlt={mediaAlt}
                            mediaUrl={mediaUrl}
                            mediaSizeSlug={mediaSizeSlug}
                            mediaCustomPosition={mediaCustomPosition}
                            mediaOrientation={mediaOrientation}
                            aspectRatio={aspectRatio}
                            open={open}
                            controls={controls}
                            autoplay={autoplay}
                            loop={loop}
                            muted={muted}
                            playsinline={playsinline}
                            preload={preload}
                            poster={poster}
                            posterId={posterId}
                            setAttributes={setAttributes}
                        />
                    )}
                </InspectorControls>
                <div {...blockProps}>

                    {/* Invisible editable field to focus on Editor's Blocks list */}                    
                    <textarea style={{ border: '0',clip: 'rect(1px, 1px, 1px, 1px)',clipPath: 'inset(50%)',height: '1px',margin: '-1px',overflow: 'hidden',padding: '0',position: 'absolute',width: '1px',wordWrap: 'normal' }} />
                    {                    
                    'media' == mediaContent ? (
                    <>
                    { ('bottom' !== mediaPosition && ! className?.includes('is-style-animationtypo')) && (
                    <MediaEdit
                        mediaType={mediaType}
                        mediaUrl={mediaUrl}
                        mediaAlt={mediaAlt}
                        mediaId={mediaId}
                        mediaSizeSlug={mediaSizeSlug}
                        mediaCustomPosition={mediaCustomPosition}
                        mediaOrientation={mediaOrientation}
                        aspectRatio={aspectRatio}
                        controls={controls}
                        autoplay={autoplay}
                        loop={loop}
                        muted={muted}
                        playsinline={playsinline}
                        preload={preload}
                        poster={poster}
                        figureProps={
                            {className:'wp-block-media-text__media'}
                        }
                        setAttributes={setAttributes}
                    />
                    )}
                    </>) : (                    
                    <div className={`wp-block-media-text__media ${ mediaBacgroundColor ? `has-${ mediaBacgroundColor }-background-color has-background` : ''} ${ mediaBacgroundColor == 'darkblue' ? 'has-black-color has-color' : '' } `}>
                        <AmbientAnimation />
                    </div>
                    )}
                    {/*Load MediaEdit attributes + mediaPosition*/}
                    <ContentEdit
                        mediaType={mediaType}
                        mediaUrl={mediaUrl}
                        mediaAlt={mediaAlt}
                        mediaId={mediaId}
                        mediaSizeSlug={mediaSizeSlug}
                        mediaCustomPosition={mediaCustomPosition}
                        mediaOrientation={mediaOrientation}
                        aspectRatio={aspectRatio}
                        controls={controls}
                        autoplay={autoplay}
                        loop={loop}
                        muted={muted}
                        playsinline={playsinline}
                        preload={preload}
                        poster={poster}
                        figureProps={false}
                        setAttributes={setAttributes}
                        mediaPosition={mediaPosition}
                        chosenTemplate={chosenTemplate}
                        className={className}
                        clientId={clientId}
                    />
                </div>
            </Fragment>
        );
    },
    save: (props) => {
        const { attributes } = props;
        const { 
            mediaId, 
            mediaUrl, 
            mediaAlt, 
            mediaPosition,
            mediaSizeSlug,
            mediaCustomPosition,
            mediaOrientation,
            aspectRatio,
            mediaType,
            autoplay,
            loop,
            muted,
            controls,
            playsinline,
            preload,
            poster,
            extraClassName,
            mediaContent,
            mediaBacgroundColor,
            backgroundColor,
            className
        } = attributes;

        const blockProps = useBlockProps.save({
            className: [
                'wp-block-myconianhotel-media-text wp-block-media-text', // Default class
                backgroundColor ? 'has-' + backgroundColor + '-background-color has-background-color' : '', // Default class
                extraClassName ? extraClassName : '',
                props.attributes.align ? `align${props.attributes.align}` : 'none', // Align classes
                'is-stacked-on-mobile', // Mobile stacking class
                (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'has-global-padding' : '', // Global padding class
                (mediaPosition == 'bottom' || mediaPosition == 'top') && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '', // Constrain class
                mediaPosition === 'right' ? 'has-media-on-the-right' : (mediaPosition === 'bottom' ? 'has-media-on-the-bottom' : (mediaPosition === 'top' ? 'has-media-on-the-top' : '')), // Media positioning class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        return (
            <div {...blockProps}>
                {                    
                    'media' == mediaContent ? (
                    <>
                    { ('bottom' !== mediaPosition && ! className?.includes('is-style-animationtypo')) && (
                <MediaSave
                    mediaType={mediaType}
                    mediaUrl={mediaUrl}
                    mediaAlt={mediaAlt}
                    mediaId={mediaId}
                    mediaSizeSlug={mediaSizeSlug}
                    mediaCustomPosition={mediaCustomPosition}
                    mediaOrientation={mediaOrientation}
                    aspectRatio={aspectRatio}
                    controls={controls}
                    autoplay={autoplay}
                    loop={loop}
                    muted={muted}
                    playsinline={playsinline}
                    preload={preload}
                    poster={poster}
                    figureProps={
                        {className:'wp-block-media-text__media'}
                    }
                    />
                )}
                    </>) : (                    
                    <div className={`wp-block-media-text__media ${ mediaBacgroundColor ? `has-${ mediaBacgroundColor }-background-color has-background` : ''} ${ mediaBacgroundColor == 'darkblue' ? 'has-black-color has-color' : '' } `}>
                        <AmbientAnimation />
                    </div>
                    )}                
                {/*Load MediaSave attributes + mediaPosition*/}
                <ContentSave
                    mediaType={mediaType}
                    mediaUrl={mediaUrl}
                    mediaAlt={mediaAlt}
                    mediaId={mediaId}
                    mediaSizeSlug={mediaSizeSlug}
                    mediaCustomPosition={mediaCustomPosition}
                    mediaOrientation={mediaOrientation}
                    aspectRatio={aspectRatio}
                    controls={controls}
                    autoplay={autoplay}
                    loop={loop}
                    muted={muted}
                    playsinline={playsinline}
                    preload={preload}
                    poster={poster}
                    figureProps={
                        {className:'wp-block-media-text__media'}
                    }
                    mediaPosition={mediaPosition}
                    className={className}
                />                    
            </div>
        );
    }
});

// Register block styles for 'myconianhotel/media-text'

wp.blocks.registerBlockStyle('myconianhotel/media-text', [
    {
        name: 'alternative',
        label: 'Alternative style',
    },
    {
        name: 'sticky',
        label: 'Sticky style',
    },
    {
        name: 'animationtypo',
        label: 'With Interactive Typo',
    }
]);  