
export const onSelectMedia = (media, mediaSizeSlug, setAttributes) => {
    const type = media.type === 'video' ? 'video' : 'image';
    setAttributes({
        mediaId: media.id,
        mediaUrl: media.sizes ? media.sizes[mediaSizeSlug]?.url || media.url : media.url,
        mediaAlt: media.alt || '',
        mediaType: type,
        mediaOrientation: media.height > media.width ? 'portrait' : 'landscape',
        originalAspectRatio: media.width / media.height
    });
};

export const verticalPositioning = (mediaOrientation, originalAspectRatio, aspectRatio, cnsl=false) => {
    let addVerticalPositioning = false;

    if ('unset' !== aspectRatio) {
        if ('portrait' == mediaOrientation) {
            addVerticalPositioning = true;
            try {
                if ( originalAspectRatio > eval(aspectRatio) ) {
                    addVerticalPositioning = false;
                }
            } catch {}
        } else if ('landscape' == mediaOrientation) {
            addVerticalPositioning = false;
            try {
                if ( originalAspectRatio < eval(aspectRatio) ) {
                    addVerticalPositioning = true;
                }
            } catch {}
        }
    } else {
        if ('portrait' == mediaOrientation) {
            addVerticalPositioning = true;
        }
    }

    return addVerticalPositioning;
}