const { __ } = wp.i18n;

const {
    MediaPlaceholder
} = wp.blockEditor;

import { onSelectMedia } from './functions';

export const MediaEdit = ({
    mediaType,
    mediaUrl,
    mediaAlt,
    mediaId,
    mediaSizeSlug,
    aspectRatio,
    controls,
    autoplay,
    loop,
    muted,
    playsinline,
    preload,
    poster,
    figureProps,
    setAttributes
}) => {

    return(
        <figure {...figureProps || {className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`}}>
            {mediaType && mediaUrl ? (
                mediaType === 'image' ? (
                    <img 
                        src={mediaUrl} 
                        alt={mediaAlt} 
                        className={`wp-image-${mediaId} size-${mediaSizeSlug}`}
                        style={{
                            aspectRatio: aspectRatio,
                            objectFit: 'cover'
                        }}
                    />
                ) : (
                    <video
                        controls={controls}
                        autoPlay={autoplay}
                        loop={loop}
                        muted={muted}
                        playsInline={playsinline}
                        preload={preload}
                        poster={poster}
                        className={`wp-video-${mediaId}`}
                        style={{
                            aspectRatio: aspectRatio,
                            objectFit: 'cover'
                        }}
                    >
                        <source src={mediaUrl} />
                    </video>
                )
            ) : (
                <MediaPlaceholder
                    onSelect={(media, mediaSizeSlug) => onSelectMedia(media, mediaSizeSlug, setAttributes)}
                    allowedTypes={['image', 'video']}
                    multiple={false}
                    labels={{ title: __('Media area') }}
                />
            )}
        </figure>
    );
}

export const MediaSave = ({
    mediaType,
    mediaUrl,
    mediaAlt,
    mediaId,
    mediaSizeSlug,
    aspectRatio,
    controls,
    autoplay,
    loop,
    muted,
    playsinline,
    preload,
    poster,
    figureProps    
}) => {
    return(
        <figure {...figureProps || {className: `wp-block-${mediaType} wp-block-myconianhotel-media wp-block-myconianhotel-${mediaType} size-${mediaSizeSlug}`}}>
            {mediaType === 'image' && mediaUrl && (
                <img
                    src={mediaUrl}
                    alt={mediaAlt}
                    className={`wp-image-${mediaId} size-${mediaSizeSlug}`}
                    style={{
                        aspectRatio: aspectRatio,
                        objectFit: 'cover'
                    }}
                />
            )}
            {mediaType === 'video' && mediaUrl && (
                <video
                    controls={controls}
                    autoPlay={autoplay}
                    loop={loop}
                    muted={muted}
                    playsInline={playsinline}
                    preload={preload}
                    poster={poster}
                    className={`wp-video-${mediaId}`}
                    style={{
                        aspectRatio: aspectRatio,
                        objectFit: 'cover'
                    }}
                >
                    <source src={mediaUrl} />
                </video>
            )}
        </figure>
    );
}