const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
const {useBlockProps, useInnerBlocksProps } = wp.blockEditor;
const { useSelect } = wp.data;
import { IconSet } from '../../modules';

registerBlockType('myconianhotel/offers', {
    apiVersion: 2,
    title: __('Offers', 'myconianhotel'),
    description: __('Some description'),
    icon: IconSet.offers,
    category: 'layout',
    edit(props) {
        const site = useSelect( ( select ) =>
            select( 'core' ).getSite(),
            []
        );

        const logo = useSelect( ( select ) =>
            select( 'core' ).getMedia( site?.site_logo )
        );

        return (
            <div className="wp-block-myconianhotel-archive">
                <div className="wp-block-myconianhotel-post wp-block-myconianhotel-group wp-block-group is-layout-constrained alignfull has-global-padding">
                    <div className="wp-block-myconianhotel-media-text wp-block-media-text is-stacked-on-mobile has-media-on-the-right">
                        <figure className="wp-block-media-text__media">
                            <img 
                                 src={logo?.source_url}
                                 className="attachment-large size-large wp-post-image"
                                 style={{
                                     aspectRatio:3/2,
                                     objectFit:'contain',
                                     background:'black',
                                     padding:'10%',
                                     boxSizing:'border-box',
                                     height:'unset',
                                     background:'var(--wp--preset--color--darkblue)'
                                  }}
                                 />              
                        </figure>
                        <div className="wp-block-media-text__content is-layout-flow">
                            <p class="has-small-font-size">List of</p>
                            <h2 className="wp-block-heading wp-myconianhotel-block-heading">Special Offers</h2>
                            <p>Please ensure all required credentials (username & password) are submitted <a href={site?.url + '/wp-admin/options-general.php?page=acf-options-accommodations'} target="_blank">here.</a></p>
                        </div>
                    </div>
                </div>
            </div>
        );
    },
    save(props) {
        return null; // Server side render
    }
});