<?php
$post_id = $args['id'] ?? get_the_ID();
$fields = ( $args['attributes'] ?? get_field( 'myconian_room_attributes', $post_id ) ) ?? array();
$title = $args['title'] ?? true;
$filter = $args['filter'] ?? null;
$full_label = true;

// Filter the array to only include items where 'value' is not empty
$filtered = array_filter( $fields, function($item) {
    return ! empty( $item['value'] );
});
?>

<?php if ( ! empty( $filtered ) ) : // TODO: the are never empty ?>
<div class="wp-block-myconianhotel-post-acf-fields wp-block is-layout-flow">
	<?php if ( $title ) : ?><p>Details</p><?php endif; ?>
	<ul>
        <?php
        foreach ( $fields as $key => $attr ) :
            if (
                $attr['value']
                && ( ! $filter || $attr[$filter] ) // there is no filter parameter || there is filter parameter and attribute is filtered by parameter
            ) :
                ?>

            <li data-content="<?php echo $attr['full_label']; ?>"><?php echo $full_label ? $attr['full_label'] : $attr['value'] ?></li>
                
                <?php
            endif;
        endforeach;
        ?>
    </ul>	
</div>
<?php endif; ?>