

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { useBlockProps, useInnerBlocksProps, InnerBlocks, useSetting } = wp.blockEditor;
const { useEffect } = wp.element;
import { IconSet } from '../../modules';

registerBlockType('myconianhotel/post-info', {
	apiVersion: 2,
    title: __('Post Info', 'myconianhotel'),
    description: __('Some description'),
    icon: IconSet.postInfo,
    category: 'layout',
    attributes: {
        backgroundColor: {
            type: 'string',
            //default: 'white', It is declared inside index.js (themeDefaultBackground)
        }
    },
    edit(props) {
    	const { attributes, setAttributes } = props;
    	const { backgroundColor } = attributes;

        // Set the initial background color if it hasn't been set
        const defaultBackgroundSlug  = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
        useEffect(() => {
            if (!backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, [backgroundColor, defaultBackgroundSlug]);

        const blockProps = useBlockProps({
            className: `alignfull is-layout-constrained has-${backgroundColor}-background-color has-background-color has-global-padding`,
        });

        const TEMPLATE = [
            ['myconianhotel/post-info-column', {
				metadata: {
				    name: 'Content'
				}
            },
	    		[            		
		            ['myconianhotel/post-terms', {makeTermsLink: true}],
		            ['core/post-title', {level: 1}],
		            ['myconianhotel/paragraph', {'placeholder': 'Add a description about accomodation.'}],
		            ['myconianhotel/book-form']
		        ]
            ],
            ['myconianhotel/post-info-column', {
            	extraClasses: 'is-layout-flex',
				metadata: {
				    name: 'Terms & attributes'
				}
            },
				[            		
		            ['myconianhotel/post-acf-fields'],
		            ['myconianhotel/post-terms', { taxonomy: 'accommodation_amenities', showTitle: true}],
		            ['myconianhotel/post-terms', { taxonomy: 'accommodation_benefits', showTitle: true}]
		        ]
            ]
        ];

        const innerBlocksProps = useInnerBlocksProps({
            className: 'wp-block-columns wp-block-myconianhotel-columns is-layout-flex wp-block-columns-is-layout-flex'
            },
            {
                allowedBlocks: [ 'myconianhotel/post-info-column' ],
                template: TEMPLATE,
                templateLock: 'all'
            }
        );

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );                

    },
    save(props) {
    	const { attributes } = props;
    	const { backgroundColor } = attributes;

        const blockProps = useBlockProps.save({
            className: `alignfull is-layout-constrained has-${backgroundColor}-background-color has-background-color has-global-padding`,
        });

        const innerBlocksProps = useInnerBlocksProps.save({
            className: 'wp-block-columns wp-block-myconianhotel-columns is-layout-flex wp-block-columns-is-layout-flex'
            }
        );    	
        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );  
    }
});

// Register 'myconianhotel/post-info-column' block

registerBlockType('myconianhotel/post-info-column', {
    apiVersion: 2,
    title: __('Post info Column', 'myconianhotel'),
    icon: 'columns',
    category: 'layout',
    attributes: {
        extraClasses: {
            type: 'string',
            default: 'is-layout-flow'
        }
    },
    supports: {
        inserter: false, // Prevents this block from appearing in the block inserter
        html: false,
    },
    parent: ['myconianhotel/post-info'], // Restricts this block to be used only inside 'myconianhotel/post-teaser'

    edit(props) {
    	const { attributes } = props;
    	const { extraClasses } = attributes;

        const innerBlocksProps = useInnerBlocksProps({
            className: `wp-block-column wp-block-myconian-hotel-column ${extraClasses}`
        }/*, {
            template: template,
            allowedBlocks: [],
            templateLock: 'all'        
        }*/);

        return (
            <div {...innerBlocksProps}></div>
        );
    },

    save(props) {
    	const { attributes } = props;
    	const { extraClasses } = attributes

        const blockProps = useBlockProps.save({
            className: `wp-block-column wp-block-myconian-hotel-column ${extraClasses}`
        });

        return (
        	<div {...blockProps}>
           		<InnerBlocks.Content />
           	</div>
        );
    },
});