    import { CustomPanelColorSettings, IconSet } from '../../modules';
wp.domReady(() => {
    const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
    const { InspectorControls, InnerBlocks, useBlockProps, useInnerBlocksProps, useSetting } = wp.blockEditor;
    const { PanelBody, RangeControl, SelectControl } = wp.components;
    const { __ } = wp.i18n;
    const { useState, useEffect, Fragment } = wp.element;
    const { useSelect, dispatch } = wp.data;

    registerBlockType('myconianhotel/post-teaser', {
        apiVersion: 2,
        title: __('Post Teaser', 'myconianhotel'),
        description: __('Some description'),
        icon: IconSet.postTeaser,
        category: 'layout',
        attributes: {
            columns: {
                type: 'number',
                default: 2,
            },
            aspectRatio: {
                type: 'string',
                default: '3/2' // Default aspect ratio (unnecessary)
            },
            backgroundColor: {
                type: 'string',
            },
            makeCarousel: {
                type: 'bool',
                default: false
            },
            parentIsSticky: {
                type: 'bool',
                default: false
            }
        },
        supports: {
            anchor: true,
            styles: true
        },
        edit({ attributes, setAttributes, clientId, className }) {
            const { columns, aspectRatio, backgroundColor, makeCarousel, classNamem, parentIsSticky } = attributes;
            const [localColumns, setLocalColumns] = useState(columns);
            const { getBlocksByClientId } = wp.data.select('core/block-editor');
            const { replaceInnerBlocks, updateBlockAttributes } = wp.data.dispatch('core/block-editor');
            const innerBlocks = getBlocksByClientId(clientId)[0].innerBlocks;

            console.log(backgroundColor);

            // Set the initial background color if it hasn't been set
            const defaultBackgroundSlug  = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
            useEffect(() => {
                if (!backgroundColor) {
                    setAttributes({ backgroundColor: makeCarousel ? 'transparent' : defaultBackgroundSlug });
                }
            }, [backgroundColor, defaultBackgroundSlug, makeCarousel]);

            // Always alternative style when makeCarousel
            // TODO: replace gallery-text" Dynamically unregister and register styles" script with this approach
            useEffect(() => {
                if (makeCarousel) {
                    setAttributes({className: 'is-style-alternative'});
                }
            }, [className, makeCarousel]);

            const tsiou = makeCarousel ?
            'wp-block-myconianhotel-gallery__preview owl-theme-autowidth' :
            'wp-block-columns wp-block-myconianhotel-columns';

            //Debug console.log(tsiou);

            const innerBlocksPropsClassName = [
                makeCarousel ? 'wp-block-myconianhotel-gallery__preview owl-theme-autowidth' : '',
                ! makeCarousel && parentIsSticky ? 'wp-block-myconianhotel-gallery__preview' : '',
                ! makeCarousel && ! parentIsSticky ? 'wp-block-columns wp-block-myconianhotel-columns' : ''
            ].filter(Boolean).join(' ');
            
            //Debug console.log(innerBlocksPropsClassName);
            //Debug console.log('------------');

            const innerBlocksProps = useInnerBlocksProps({
                className: innerBlocksPropsClassName
                },
                {
                    allowedBlocks: [],
                    templateLock: 'delete' // Lock deletion, allow adding and moving
                }
            );

            // Detect block style change using useSelect to track className changes dynamically
            const blockClassName = useSelect(
                (select) => select('core/block-editor').getBlockAttributes(clientId)?.className || ''
            );

            useEffect(() => {
                if ( makeCarousel ) {                 
                    // Snippet to update unset aspect ratio to 3/2 for existing blocks
                    if ('unset' == aspectRatio) {
                        setAttributes({ aspectRatio: '3/2' });
                    } else {
                        setAttributes({ aspectRatio: aspectRatio });
                    }             
                } else {
                    if (blockClassName.includes('is-style-alternative')) {
                        setAttributes({ aspectRatio: '2/3' });
                        ///setAttributes({ backgroundColor: defaultBackgroundSlug });                    
                    } else {
                        setAttributes({ aspectRatio: '3/2' });                    
                        if (parentIsSticky) {
                            setAttributes({ backgroundColor: 'lightgray' });
                        } else {
                            ///setAttributes({ backgroundColor: 'lightergray' });
                        }
                    }                    
                }

            }, [blockClassName]);

            // Update only the aspectRatio of the child blocks, keeping InnerBlocks content intact
            useEffect(() => {
                innerBlocks.forEach((block) => {
                    if (block.attributes.aspectRatio !== aspectRatio) {
                        updateBlockAttributes(block.clientId, { aspectRatio });
                    }
                });
            }, [aspectRatio]);

            const iou = makeCarousel ?
            `` :
            `alignfull${className?.includes('is-style-alternative') ? ' is-layout-constrained' : ' '} has-${backgroundColor}-background-color has-background-color has-${columns}-columns`;

            //Debug console.log(iou);

            const blockPropsClassName = [
                ! makeCarousel && ! parentIsSticky ? 'alignfull' : '',
                ! makeCarousel && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '',
                ! makeCarousel ? `has-${backgroundColor}-background-color has-background-color` : '',
                ! makeCarousel && ! parentIsSticky ? `has-${columns}-columns` : ''
            ].filter(Boolean).join(' ');

            //Debug console.log(blockPropsClassName);
            //Debug console.log('------------');

            const blockProps = useBlockProps({
                className: blockPropsClassName
            });

            // Ensure the correct number of columns is rendered
            useEffect(() => {
                if (innerBlocks.length === 0 && localColumns > 0) {
                    const defaultColumns = Array.from({ length: localColumns }, (value, index) => {
                        return createBlock('myconianhotel/post-teaser-column', {
                            makeCarouselItem: makeCarousel,
                            aspectRatio,
                            lastColumn: index == localColumns-1 ? true : false,
                            firstColumn: index == 0 ? true : false
                            });
                    });;
                    replaceInnerBlocks(clientId, defaultColumns, false);
                } else if (innerBlocks.length !== localColumns) {
                    updateColumns(localColumns);
                }
            }, [localColumns, aspectRatio]);

            const updateColumns = (newColumnCount) => {
                const currentColumnCount = innerBlocks.length;
                let newInnerBlocks = [...innerBlocks];

                for (let i = 0; i < newInnerBlocks.length; i++) {
                    newInnerBlocks[i].attributes.lastColumn = false;
                }

                if (newColumnCount > currentColumnCount) {
                    for (let i = currentColumnCount; i < newColumnCount; i++) {
                        newInnerBlocks.push(createBlock('myconianhotel/post-teaser-column', {
                            makeCarouselItem: makeCarousel,
                            aspectRatio,
                            lastColumn: i == newColumnCount-1 ? true : false
                            }));
                    }
                } else if (newColumnCount < currentColumnCount) {
                    newInnerBlocks = newInnerBlocks.slice(0, newColumnCount);
                    newInnerBlocks[newColumnCount-1].attributes.lastColumn = true;
                    newInnerBlocks[0].attributes.firstColumn = true;
                }

                replaceInnerBlocks(clientId, newInnerBlocks, false);
                setAttributes({ columns: newColumnCount });
            };

            const handleSliderChange = (newColumns) => {
                setLocalColumns(newColumns);
            };

            return (
                <Fragment>
                    <InspectorControls>
                        { ! makeCarousel && blockClassName?.includes('is-style-alternative') && (
                        <CustomPanelColorSettings
                            setAttributes={setAttributes}
                            backgroundColor={backgroundColor}
                            palette={'collection' == myconianhotelBlockPostTeaser.colorscheme ? ['lightgray', 'white'] : ['darkblue', 'lightgray', 'white'] }
                        />
                        )}
                        <PanelBody title={__('Column Settings', 'myconianhotel')}>
                            <RangeControl
                                label={__('Columns', 'myconianhotel')}
                                value={localColumns}
                                onChange={handleSliderChange}
                                min={1}
                                max={makeCarousel || parentIsSticky ? 15 : 3}
                            />
                            { makeCarousel &&
                                <SelectControl
                                    label="Aspect Ratio"
                                    value={aspectRatio}
                                    options={[
                                        { label: '2:3', value: '2/3' },
                                        { label: '3:2', value: '3/2' },                        
                                    ]}
                                    onChange={(newRatio) => setAttributes({ aspectRatio: newRatio })}
                                />
                            }
                        </PanelBody>
                    </InspectorControls>

                    <div {...blockProps}>
                        <textarea style={{ border: '0',clip: 'rect(1px, 1px, 1px, 1px)',clipPath: 'inset(50%)',height: '1px',margin: '-1px',overflow: 'hidden',padding: '0',position: 'absolute',width: '1px',wordWrap: 'normal' }} /> {/* Invisible editable field */}
                        <div {...innerBlocksProps}></div>
                    </div>
                </Fragment>
            );
        },
        save({ attributes }) {
            const { aspectRatio, backgroundColor, columns, makeCarousel, className, parentIsSticky } = attributes;
                    
            const tsiou = makeCarousel ?
            `` :
            `alignfull${className?.includes('is-style-alternative') ? ' is-layout-constrained' : ' '} has-${backgroundColor}-background-color has-background-color has-${columns}-columns`;

            //Debug console.log(tsiou);

            const blockPropsClassName = [
                ! makeCarousel && ! parentIsSticky ? 'alignfull' : '',
                ! makeCarousel && className?.includes('is-style-alternative') ? 'is-layout-constrained' : '',
                ! makeCarousel ? `has-${backgroundColor}-background-color has-background-color` : '',
                ! makeCarousel && ! parentIsSticky ? `has-${columns}-columns` : ''
            ].filter(Boolean).join(' ');

            //Debug console.log(blockPropsClassName);
            //Debug console.log('------------');

            const blockProps = useBlockProps.save({
                className: blockPropsClassName
            });

            const iou = makeCarousel ?
            'wp-block-myconianhotel-gallery__slider owl-carousel owl-theme-autowidth' :
            'wp-block-columns wp-block-myconianhotel-columns';

            //Debug console.log(iou);
            
            const innerBlocksPropsClassName = [
                makeCarousel ? 'wp-block-myconianhotel-gallery__slider owl-carousel owl-theme-autowidth' : '',
                ! makeCarousel && parentIsSticky ? 'wp-block-myconianhotel-gallery__slider' : '',
                ! makeCarousel && ! parentIsSticky ? 'wp-block-columns wp-block-myconianhotel-columns' : ''
            ].filter(Boolean).join(' ');
            
            //Debug console.log(innerBlocksPropsClassName);
            //Debug console.log('------------');

            const innerBlocksProps = useInnerBlocksProps.save({
                className: innerBlocksPropsClassName
            });

            return (
                <div {...blockProps}>
                    <div {...innerBlocksProps}></div>
                </div>
            );
        }
    });
});

// Register block styles for 'myconianhotel/post-teaser'
wp.blocks.registerBlockStyle('myconianhotel/post-teaser', [
    {
        name: 'default',
        label: 'Default',
        isDefault: true,
    },
    {
        name: 'alternative',
        label: 'Alternative style',
    }
]);

// Register 'myconianhotel/post-teaser-column-empty' block
wp.domReady(() => {
    const { registerBlockType } = wp.blocks;
    const { useBlockProps, InnerBlocks, useInnerBlocksProps } = wp.blockEditor;
    const { __ } = wp.i18n;
    const { useSelect, dispatch } = wp.data;
    const { useEffect } = wp.element;

    registerBlockType('myconianhotel/post-teaser-column-empty', {
        apiVersion: 2,
        title: __('Post Teaser Column', 'myconianhotel'),
        icon: 'columns',
        category: 'layout',
        attributes: {
            lastColumn: {
                type: 'boolean',
                default: false
            },
            firstColumn: {
                type: 'boolean',
                default: false
            }
        },
        supports: {
            inserter: false, // Prevents this block from appearing in the block inserter
            html: false,
        },
        edit({ attributes, clientId }) {
            const { lastColumn, firstColumn } = attributes;

            // Select the inner blocks to update their aspectRatio
            const innerBlocks = useSelect((select) => select('core/block-editor').getBlocks(clientId));

            const innerBlocksProps = useInnerBlocksProps({
                className: `wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column${lastColumn ? ' is-column-last' : ''}${firstColumn ? ' is-column-first' : ''} is-layout-flow`
            }, {
                allowedBlocks: [
                    'core/heading',
                    'myconianhotel/free-text',
                    'core/paragraph'
                ],
                templateLock: 'all'
            });

            return (
                <div {...innerBlocksProps}></div>
            );
        },

        save({ attributes }) {
            const { lastColumn, firstColumn } = attributes; // Get aspectRatio attribute

            const blockProps = {
                className: [
                    `wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column${lastColumn ? ' is-column-last' : ''}${firstColumn ? ' is-column-first' : ''} is-layout-flow`,
                    lastColumn ? 'is-column-last' : '',
                    firstColumn ? 'is-column-first' : ''
                ].filter(Boolean).join(' ') // Filter out empty class values
            }

            return (
                <div {...blockProps}>
                    <InnerBlocks.Content />
                </div>
            );
        },
    });
});

// Register 'myconianhotel/post-teaser-column' block
wp.domReady(() => {
    const { registerBlockType } = wp.blocks;
    const { useBlockProps, InnerBlocks, useInnerBlocksProps } = wp.blockEditor;
    const { __ } = wp.i18n;
    const { useSelect, dispatch } = wp.data;
    const { useEffect } = wp.element;

    registerBlockType('myconianhotel/post-teaser-column', {
        apiVersion: 2,
        title: __('Post Teaser Column', 'myconianhotel'),
        icon: 'columns',
        category: 'layout',
        attributes: {
            aspectRatio: {
                type: 'string',
                default: '3/2' // Default aspect ratio
            },
            lastColumn: {
                type: 'boolean',
                default: false
            },
            firstColumn: {
                type: 'boolean',
                default: false
            },
            makeCarouselItem: {
                type: 'bool',
                default: false
            }
        },
        supports: {
            inserter: false, // Prevents this block from appearing in the block inserter
            html: false,
        },
        parent: ['myconianhotel/post-teaser'], // Restricts this block to be used only inside 'myconianhotel/post-teaser'

        edit({ attributes, clientId }) {
            const { aspectRatio, lastColumn, firstColumn, makeCarouselItem, className } = attributes; // Get aspectRatio attribute

            // Template for columns, including the 'myconianhotel/media' block
            const TEMPLATE = [
                ['myconianhotel/paragraph', {
                    //textAlign: 'center',
                    fontSize: 'small',
                    placeholder: __('Subtitle', 'myconianhotel')
                }],
                ['myconianhotel/heading', {
                    level: 2,
                    //textAlign: 'center',
                    placeholder: __('Heading', 'myconianhotel')
                }],
                ['myconianhotel/media', {
                    mediaSizeSlug: 'medium',
                    aspectRatio // Pass aspectRatio dynamically to media block

                }],                
                ['myconianhotel/paragraph', {
                    //textAlign: 'center',
                    placeholder: __('Content', 'myconianhotel')
                }],
                ['myconianhotel/buttons']
            ];

            // Select the inner blocks to update their aspectRatio
            const innerBlocks = useSelect((select) => select('core/block-editor').getBlocks(clientId));

            const innerBlocksPropsClassName = makeCarouselItem ?
            'wp-block-post-teaser-column is-layout-flow' :
            `wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column${lastColumn ? ' is-column-last' : ''}${firstColumn ? ' is-column-first' : ''} is-layout-flow`;

            const innerBlocksProps = useInnerBlocksProps({
                className: innerBlocksPropsClassName
            }, {
                template: TEMPLATE,
                allowedBlocks: [],
                templateLock: 'all'        
            });

            // Update the aspectRatio of any 'myconianhotel/media' blocks inside
            useEffect(() => {
                innerBlocks.forEach((block) => {
                    if (block.name === 'myconianhotel/media') {
                        dispatch('core/block-editor').updateBlockAttributes(block.clientId, {
                            aspectRatio,
                        });
                    }
                });
            }, [aspectRatio]);

            return (
                <div {...innerBlocksProps}></div>
            );
        },

        save({ attributes }) {
            const { lastColumn, firstColumn, makeCarouselItem } = attributes; // Get aspectRatio attribute

            const blockPropsClass = makeCarouselItem ?
            'wp-block-post-teaser-column is-layout-flow' :
             `wp-block-post-teaser-column wp-block-column wp-block-myconian-hotel-column${lastColumn ? ' is-column-last' : ''}${firstColumn ? ' is-column-first' : ''} is-layout-flow`;

            const blockProps = {
                className: [
                    blockPropsClass,
                    lastColumn ? 'is-column-last' : '',
                    firstColumn ? 'is-column-first' : ''
                ].filter(Boolean).join(' ') // Filter out empty class values
            }

            return (
                <div {...blockProps}>
                    <InnerBlocks.Content />
                </div>
            );
        },
    });
});