const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle  } = wp.blocks;
const { useBlockProps, InnerBlocks, useInnerBlocksProps } = wp.blockEditor;
import { IconSet } from '../../modules';

const TEMPLATE = [    
    ['myconianhotel/gallery', { backgroundColor: 'transparent', sliderTheme: 'fade', aspectRatio: '27/10', layout: '', align: ''}],
];

registerBlockType('myconianhotel/weather', {
    apiVersion: 2,
    title: __('Weather'),
    description: __('Weather'),
    icon: IconSet.weather,
    category: 'widgets',
    supports: {
        //align: ['full'], // Only allow align full
        media: true,
        anchor: true,
        multiple: false
    },
    edit: (props) => {
        //const { attributes } = props;
        //const { feed, time } = attributes;

        const blockProps = useBlockProps({
            className: [
                'alignfull', // Align classes
                'has-global-padding', // Align classes
                'is-layout-constrained', // Constrain class
                'has-darkblue-background-color has-background-color'
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps({}, {
            templateLock: 'all',
            template: TEMPLATE,
            allowedBlocks: []        
        });

        return (
            <div {...blockProps}>
                {innerBlocksProps.children}
                <WeatherRender /*feed={feed} time={time}*//>
            </div>
        );
    },
    save: (props) => {
        //const { attributes } = props;
        //const { feed, time } = attributes;

        const blockProps = useBlockProps.save({
            className: [
                'alignfull', // Align classes
                'has-global-padding', // Align classes
                'is-layout-constrained', // Constrain class
                'has-darkblue-background-color has-background-color',
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps.save();

        return (
             <div {...blockProps}>
                {innerBlocksProps.children}
                <WeatherRender /*feed={feed} time={time}*//>
            </div>
        );
    }
});

const WeatherRender = (props) => {
    //const paresedFeed = JSON.parse(props.feed);
    //const temp = (paresedFeed.hourly?.temperature_2m[0] ?? '') + (paresedFeed.hourly_units?.temperature_2m ?? '');

    return (
        
        <div className="wp-block-myconianhotel-weather-info">
            <div className="wp-block-myconianhotel-weather-info__content">
                <div className="weather-info">
                <div className="temperature">[temp]</div>
                <div className="time">[time]</div>
                </div>
                <div className="place-info">MYCONOS, GREECE</div>
            </div>
        </div>
    );
}