<?php

/**
 * Enqueue Editor assets * 
 */
add_action( 'enqueue_block_editor_assets', function(){
    $asset_file = include( __DIR__ . '/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-widget-text',
        get_theme_file_uri() . '/theme-blocks/blocks/widget-text/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );
}, 100 );

/**
 * Filter Block's HTML
 */
add_filter('render_block', function ( $rendered_block, $block ) {
    if ( !is_admin() ) {
        if ( 'myconianhotel/widget-text' == $block['blockName'] ) {
            $post_type = $block['attrs']['chosenTemplate'] ?? 'position';
            $link_text = $block['attrs']['linkText'] ?? 'View';
            $term = $block['attrs']['chosenTerm'] ?? null;
            $tax_query = $term ? array(
                [
                    'taxonomy' => 'document_type',
                    'field'    => 'term_id',
                    'terms'    => $term,
                ]
            ) : array();

            $rendered_block = preg_replace_callback(
                '/<ul class="wp-block-list wp-block is-style-lined">(.*?)<\/ul>/is', // Match <ul> with any attributes and content
                function ( $matches ) use ( $post_type, $link_text, $tax_query ) { // Pass $post_type correctly
                    $replacement = '';
                    $positions = get_posts( array(
                        'post_type'   => $post_type,
                        'post_status' => array( 'publish', 'draft' ),
                        'numberposts' => -1,
                        'tax_query'   => $tax_query
                    ));

                    if ( 'event' == $post_type) {
                        foreach ( $positions as $post ) {
                            $link = get_post_meta( $post->ID, 'myconianhotel_event_file', true );
                            if ( $post->post_status === 'publish' && $link ) {
                                $replacement .= '<li><a href="' . get_post_meta( $post->ID, 'myconianhotel_event_file', true ) . '" target="_blank">' . esc_html( $post->post_title ) . '<span>Download</span></a></li>';
                            }
                        }
                    } else if ( 'position' == $post_type) {
                        foreach ( $positions as $post ) {
                            $replacement .= '<li>' . 
                                ( $post->post_status === 'publish' ? 
                                    '<a href="' . get_the_permalink( $post->ID ) . '">' : ''
                                ) . 
                                esc_html( $post->post_title ) . 
                                ( $post->post_status === 'publish' ? '<span>Apply</span></a>' : '' ) . 
                                '</li>';
                        }
                    } else if ( 'menu' == $post_type) {
                        foreach ( $positions as $post ) {
                            $file = get_field( 'myconianhotel_file', $post->ID );
                            if ( $post->post_status === 'publish' && $file ) {
                                $replacement .= '<li><a href="' . $file . '" target="_blank">' . esc_html( $post->post_title ) . '<span>View</span></a></li>';
                            }
                        }
                    } else if ( 'document' == $post_type) {
                        foreach ( $positions as $post ) {
                            $document = get_field( 'myconianhotel_document', $post->ID );
                            if ( $post->post_status === 'publish' && ( $document['file'] || $document['url'] ) ) {
                                $replacement .= '<li><a href="' . ( $document['file'] ?: $document['url'] ) . '" target="_blank">' . esc_html( $post->post_title ) . '<span>' . $link_text . '</span></a></li>';
                            }
                        }
                    }

                    return '<ul class="wp-block-list wp-block is-style-lined">' . $replacement . '</ul>';
                },
                $rendered_block
            );
        }
    }
    return $rendered_block;
}, 2, 2);