<?php

defined('ABSPATH') || exit;

/**
 * Blocks after set up theme actions
 *
 * Remove core styles (Not recommended)
 * 
 * Enqueue Editor assets
 *  myconianhotel/media
 *  myconianhotel/media-text
 *  myconianhotel/media-text-hero
 *  myconianhotel/post-teaser
 *  myconianhotel/buttons
 *  myconianhotel/paragraph
 *  myconianhotel/heading
 *  myconianhotel/hero
 *  myconianhotel/gallery
 *  myconianhotel/gallery-text
 *  myconianhotel/instagram-feed
 *  myconianhotel/group
 *  myconianhotel/interactive-typo
 *  myconianhotel/weather
 *  myconianhotel/post-acf-fields
 *  myconianhotel/post-terms
 *  myconianhotel/post-info
 *  myconianhotel/post-navigation
 *  myconianhotel/post-teaser-gallery
 *  myconianhotel/post-teaser-feed
 *  myconianhotel/files-text
 *  myconianhotel/contact
 *  myconianhotel/hotels
 *  myconianhotel/media-text-slide
 *  myconianhotel/book-form
 *  myconianhotel/google-map
 *  myconianhotel/offers
 *  myconianhotel/free-text
 * 
 * Enqueue front-end assets
 *  myconianhotel/media-text-hero
 *  myconianhotel/gallery
 *  myconianhotel/interactive-typo
 *  myconianhotel/hotels
 *  myconianhotel/media-text-slide
 *  myconianhotel/book-form
 *  myconianhotel/google-map
 *  myconianhotel/gallery-text
 * 
 * Enqueue admin assets
 * 
 * Enqueue blocks PHP assets
 *  myconianhotel/hero
 *  myconianhotel/instagram-feed
 *  myconianhotel/interactive-typo
 *  myconianhotel/post-acf-fields
 *  myconianhotel/post-terms
 *  myconianhotel/post-navigation
 *  myconianhotel/post-teaser-feed
 *  myconianhotel/contact
 *  myconianhotel/book-form
 *  myconianhotel/offers
 *  myconianhotel/google-map
 * myconianhotel/hero render callback
 * myconianhotel/instagram-feed render callback
 * myconianhotel/post-acf-fields render callback
 * myconianhotel/post-terms render callback
 * myconianhotel/post-navigation render callback
 * myconianhotel/post-teaser-feed render callback
 * myconianhotel/contact render callback
 * myconianhotel/hotels render callback
 * myconianhotel/book-form render callback
 * myconianhotel/offers render callback
 * myconianhotel/google-map render callback
 * 
 * Whitelist specific Gutenberg blocks for user roles
 * 
 * Filter blocks HTML
 *  myconianhotel/media-text-hero
 *  myconianhotel/buttons
 *  myconianhotel/gallery
 *  myconianhotel/post-gallery
 *  myconianhotel/post-teaser-gallery
 *  myconianhotel/weather
 *  Remove empty paragraphs
 *  Remove empty headers
 * 
 * Modify theme json
 * 
 * Add admin body classes
 *
 * Fetch block data
 * 
 * Find posts using image endpoint
 * 
 * Block css object position rule orientation
 */

/**
 * Blocks after set up theme actions
 */
function theme_blocks_after_setup_theme() {
    $myconianhotel_colorscheme = get_option( 'myconianhotel_colorscheme', null );

    // Block editor custom styles
    add_theme_support( 'editor-styles' );    
    // Generic style
    add_editor_style( get_theme_file_uri( '/assets/css/wp-block-library-myconianhotel.css' ) );        
    if ( file_exists( get_theme_file_path( '/assets/css/wp-block-library-' . $myconianhotel_colorscheme . '.css' ) ) ) {
        // Theme specific style
        add_editor_style( get_theme_file_uri( '/assets/css/wp-block-library-' . $myconianhotel_colorscheme . '.css' ) );
    }
    
    // Remove patterns bundled with WordPress core // https://developer.wordpress.org/block-editor/how-to-guides/curating-the-editor-experience/disable-editor-functionality/
    //remove_theme_support( 'core-block-patterns' );
}

/**
 * Remove core styles (Not recommended)
 */
//add_action( 'wp_enqueue_scripts', 'theme_blocks_remove_block_styles', 100 );
function theme_blocks_remove_block_styles() {
    //wp_dequeue_style( 'wp-block-library' ); // Remove all block styles (style.css)
    //wp_dequeue_style( 'wc-blocks-style' ); // Remove WooCommerce block styles (if using WooCommerce)
}

// myconianhotel/animation-typo
include  __DIR__ . '/blocks/animation-typo/index.php';
// myconianhotel/widget-text
include  __DIR__ . '/blocks/widget-text/index.php';
// myconianhotel/archive
include  __DIR__ . '/blocks/archive/index.php';
// myconianhotel/masonry
include  __DIR__ . '/blocks/masonry/index.php';

/**
 * Enqueue Editor assets
 * https://developer.wordpress.org/block-editor/getting-started/devenv/get-started-with-wp-scripts/
 */
add_action( 'enqueue_block_editor_assets', 'theme_enqueue_block_editor_assets', 100 );
function theme_enqueue_block_editor_assets() {

    // block editor
    $asset_file = include( __DIR__ . '/block-editor/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-block-editor',
        get_theme_file_uri() . '/theme-blocks/block-editor/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/media
    $asset_file = include( __DIR__ . '/blocks/media/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-media',
        get_theme_file_uri() . '/theme-blocks/blocks/media/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );
    
    // myconianhotel/media-text
    $asset_file = include( __DIR__ . '/blocks/media-text/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-media-text',
        get_theme_file_uri() . '/theme-blocks/blocks/media-text/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-media-text',
        'myconianhotelBlockMediaText',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );


    // myconianhotel/media-text-hero
    $asset_file = include( __DIR__ . '/blocks/media-text-hero/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-media-text-hero',
        get_theme_file_uri() . '/theme-blocks/blocks/media-text-hero/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-media-text-hero',
        'myconianhotelBlockMediaTextHero',
        [
            'logotype' => get_option( 'myconianhotel_logotype', null ),
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );

    // myconianhotel/post-teaser
    $asset_file = include( __DIR__ . '/blocks/post-teaser/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-teaser',
        get_theme_file_uri() . '/theme-blocks/blocks/post-teaser/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-post-teaser',
        'myconianhotelBlockPostTeaser',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );

    // myconianhotel/buttons
    $asset_file = include( __DIR__ . '/blocks/buttons/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-buttons',
        get_theme_file_uri() . '/theme-blocks/blocks/buttons/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-buttons',
        'myconianhotelBlockButtons',
        [
            'wpforms' => get_posts( array(
                'post_type'      => 'wpforms',
                'posts_per_page' => -1,  // Get all forms
                'post_status'    => 'publish',
            ))
        ]
    );

    // myconianhotel/paragraph
    $asset_file = include( __DIR__ . '/blocks/paragraph/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-paragraph',
        get_theme_file_uri() . '/theme-blocks/blocks/paragraph/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/heading
    $asset_file = include( __DIR__ . '/blocks/heading/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-heading',
        get_theme_file_uri() . '/theme-blocks/blocks/heading/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/hero
    $asset_file = include( __DIR__ . '/blocks/hero/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-hero',
        get_theme_file_uri() . '/theme-blocks/blocks/hero/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/gallery
    $asset_file = include( __DIR__ . '/blocks/gallery/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-gallery',
        get_theme_file_uri() . '/theme-blocks/blocks/gallery/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/gallery-text
    $asset_file = include( __DIR__ . '/blocks/gallery-text/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-gallery-text',
        get_theme_file_uri() . '/theme-blocks/blocks/gallery-text/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-gallery-text',
        'myconianhotelBlockGalleryText',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );

    // myconianhotel/instagram-feed
    $asset_file = include( __DIR__ . '/blocks/instagram-feed/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-instagram-feed',
        get_theme_file_uri() . '/theme-blocks/blocks/instagram-feed/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/group
    $asset_file = include( __DIR__ . '/blocks/group/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-group',
        get_theme_file_uri() . '/theme-blocks/blocks/group/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/interactive-typo
    $asset_file = include( __DIR__ . '/blocks/interactive-typo/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-interactive-typo',
        get_theme_file_uri() . '/theme-blocks/blocks/interactive-typo/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-interactive-typo',
        'myconianhotelBlockInteractiveTypo',
        [
            'appearanceOptionsPage' => admin_url('themes.php?page=myconianhotel-appearance-options'),
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );
    
    // myconianhotel/weather
    $asset_file = include( __DIR__ . '/blocks/weather/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-weather',
        get_theme_file_uri() . '/theme-blocks/blocks/weather/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/post-acf-fields
    $asset_file = include( __DIR__ . '/blocks/post-acf-fields/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-acf-fields',
        get_theme_file_uri() . '/theme-blocks/blocks/post-acf-fields/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/post-terms
    $asset_file = include( __DIR__ . '/blocks/post-terms/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-terms',
        get_theme_file_uri() . '/theme-blocks/blocks/post-terms/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/post-info
    $asset_file = include( __DIR__ . '/blocks/post-info/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-info',
        get_theme_file_uri() . '/theme-blocks/blocks/post-info/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/post-navigation
    $asset_file = include( __DIR__ . '/blocks/post-navigation/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-navigation',
        get_theme_file_uri() . '/theme-blocks/blocks/post-navigation/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/post-teaser-gallery
    $asset_file = include( __DIR__ . '/blocks/post-teaser-gallery/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-teaser-gallery',
        get_theme_file_uri() . '/theme-blocks/blocks/post-teaser-gallery/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-post-teaser-gallery',
        'myconianhotelBlockPostTeaserGallery',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null ),
        ]
    );

    // myconianhotel/post-teaser-feed
    $asset_file = include( __DIR__ . '/blocks/post-teaser-feed/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-post-teaser-feed',
        get_theme_file_uri() . '/theme-blocks/blocks/post-teaser-feed/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/files-text
    $asset_file = include( __DIR__ . '/blocks/files-text/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-files-text',
        get_theme_file_uri() . '/theme-blocks/blocks/files-text/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/contact
    $asset_file = include( __DIR__ . '/blocks/contact/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-contact',
        get_theme_file_uri() . '/theme-blocks/blocks/contact/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-contact',
        'myconianhotelBlockContact',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null ),
        ]
    );

    // myconianhotel/hotels
    $asset_file = include( __DIR__ . '/blocks/hotels/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-hotels',
        get_theme_file_uri() . '/theme-blocks/blocks/hotels/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/media-text-slide
    $asset_file = include( __DIR__ . '/blocks/media-text-slide/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-media-text-slide',
        get_theme_file_uri() . '/theme-blocks/blocks/media-text-slide/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/book-form
    $asset_file = include( __DIR__ . '/blocks/book-form/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-book-form',
        get_theme_file_uri() . '/theme-blocks/blocks/book-form/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-book-form',
        'myconianhotelBlockBookForm',
        [
            'adminUrl' => admin_url(),
            'options' => get_field( 'myconianhotel_book_form_block', 'options' )
        ]
    );

    // myconianhotel/google-map
    $asset_file = include( __DIR__ . '/blocks/google-map/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-google-map',
        get_theme_file_uri() . '/theme-blocks/blocks/google-map/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/offers
    $asset_file = include( __DIR__ . '/blocks/offers/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-offers',
        get_theme_file_uri() . '/theme-blocks/blocks/offers/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    // myconianhotel/free-text
    $asset_file = include( __DIR__ . '/blocks/free-text/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-free-text',
        get_theme_file_uri() . '/theme-blocks/blocks/free-text/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-free-text',
        'myconianhotelBlockFreeText',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null ),
        ]
    );
}

/**
 * Enqueue front-end assets
 */
add_action('enqueue_block_assets', 'myconianhotel_enqueue_frontend_scripts');
function myconianhotel_enqueue_frontend_scripts() {
    $theme = wp_get_theme();
    $version = $theme->get( 'Version' );

    // myconianhotel/media-text-hero
    wp_register_script(
        'myconianhotel-block-media-text-hero-front-end',
        get_template_directory_uri() . '/theme-blocks/blocks/media-text-hero/assets/js/index.js',
        array(),
        $version,
        true // Load in the footer
    );

    if ( has_block('myconianhotel/media-text-hero') || has_block('myconianhotel/media-text') || has_block('myconianhotel/animation-typo') || has_block('myconianhotel/contact') ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('myconianhotel-block-media-text-hero-front-end');
    }

    // myconianhotel/gallery
    wp_register_script(
        'myconianhotel-block-gallery-front-end',
        get_template_directory_uri() . '/theme-blocks/blocks/gallery/assets/js/index.js',
        array('theme-owl'),
        $version,
        true // Load in the footer
    );

    wp_localize_script(
        'myconianhotel-block-gallery-front-end',
        'myconianhotelBlockGallery',
        [
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );

    if ( has_block('myconianhotel/gallery') || has_block('myconianhotel/post-teaser-gallery') || is_archive() ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('myconianhotel-block-gallery-front-end');
    }

    // myconianhotel/interactive-typo
    wp_register_script(
        'myconianhotel-block-interactive-typo-front-end',
        get_template_directory_uri() . '/theme-blocks/blocks/interactive-typo/assets/js/index.js',
        array(),
        $version,
        true // Load in the footer
    );

    if ( has_block('myconianhotel/interactive-typo') || is_archive() ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('myconianhotel-block-interactive-typo-front-end');
    } 

    // myconianhotel/hotels
    wp_register_script(
        'myconianhotel-block-hotels-front-end',
        get_template_directory_uri() . '/theme-blocks/blocks/hotels/assets/js/index.js',
        array(),
        $version,
        true // Load in the footer
    );

    if ( has_block('myconianhotel/hotels') ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('myconianhotel-block-hotels-front-end');
    }   

    if ( ! is_admin() ) {
        // myconianhotel/media-text-slide
        wp_register_script(
            'myconianhotel-block-media-text-slide-front-end',
            get_template_directory_uri() . '/theme-blocks/blocks/media-text-slide/assets/js/index.js',
            array(),
            $version,
            true // Load in the footer
        );

        if ( has_block('myconianhotel/media-text-slide') ) {
            // Enqueue the script only if the block is present
            wp_enqueue_script('myconianhotel-block-media-text-slide-front-end');
        }
    }   

    if ( ! is_admin() ) {
        // myconianhotel/book-form
        wp_register_script(
            'myconianhotel-block-book-form-front-end',
            get_template_directory_uri() . '/theme-blocks/blocks/book-form/assets/js/index.js',
            array(),
            $version,
            true // Load in the footer
        );

        if ( has_block('myconianhotel/book-form') ) {
            // Enqueue the script only if the block is present
            wp_enqueue_script('myconianhotel-block-book-form-front-end');
        }
    }

    // myconianhotel/google-map
    $parameters = is_admin() ? '&libraries=places' : '&callback=initMap&v=weekly&libraries=marker';
    wp_register_script(
        'google-maps-api',
        'https://maps.googleapis.com/maps/api/js?key=AIzaSyCBsqyAzc8nf-n3BVu7VjRU0bsGtVRNVtI' . $parameters,
        [],
        null,
        true // Load in the footer
    );

    if ( has_block('myconianhotel/google-map') || is_admin() ) {
        // Enqueue the script only if the block is present
        wp_enqueue_script('google-maps-api');
    }

    if ( ! is_admin() ) {
        // myconianhotel/gallery-text        
        wp_register_script(
            'myconianhotel-block-gallery-text-front-end',
            get_template_directory_uri() . '/theme-blocks/blocks/gallery-text/assets/js/index.js',
            array(),
            $version,
            true // Load in the footer
        );

        if ( has_block('myconianhotel/gallery-text') ) {
            // Enqueue the script only if the block is present
            wp_enqueue_script('myconianhotel-block-gallery-text-front-end');
        }
    }  
}

/**
 * Enqueue admin assets
 * 
 */
add_action( 'admin_enqueue_scripts', 'myconianhotel_blocks_admin_enqueue_scripts' );
function myconianhotel_blocks_admin_enqueue_scripts() {
    $theme = wp_get_theme();
    $version = $theme->get( 'Version' );
    
    wp_register_style( 'myconianhotel-admin-editor', get_stylesheet_directory_uri() . '/assets/css/admin-editor.css', array(), $version );
    wp_enqueue_style( 'myconianhotel-admin-editor'); 
}

/**
 * Enqueue blocks PHP assets
 * has_block() is not working here
 */
add_action('init', 'myconianhotel_register_php_blocks');
function myconianhotel_register_php_blocks() {
    
    // myconianhotel/hero
    register_block_type('myconianhotel/hero', array(
        'render_callback' => 'myconianhotel_render_hero_block'
    ));

    // myconianhotel/instagram-feed
    register_block_type( 'myconianhotel/instagram-feed', array(
        'render_callback' => 'myconianhotel_render_instagram_feed_block',
        'attributes'      => array(
            'feed' => array(
                'type'    => 'string',
                'default' => function_exists( 'beetinstafeed_get_insta_feed' ) ? json_encode( beetinstafeed_get_insta_feed() ) : [],
                // 'default' => json_encode( [] ),
            ),
            'backgroundColor' => array(
                'type'    => 'string',
                'default' => '',
            )
        )
    ));

    // myconianhotel/interactive-typo
    register_block_type( 'myconianhotel/interactive-typo', array(
        'attributes'  => array(
            'typo' => array(
                'type' => 'string',
                'default' => get_option( 'myconianhotel_logotype' )
            ),
            'backgroundColor' => array(
                'type' => 'string',
            )
        )
    ));  

    // myconianhotel/post-acf-fields
    register_block_type( 'myconianhotel/post-acf-fields', array(
        'render_callback' => 'myconianhotel_render_post_acf_fields_block',
        'attributes'  => array(
            'attributesHelper' => array(
                'type'    => 'string',
                'default' => json_encode( myconianhotel_accommodation_attributes_helper() )
            ),
            'acfValues' => array(
                'type'    => 'string',
                'default' => '{}'
            )
        )
    ));

    // myconianhotel/post-terms
    register_block_type('myconianhotel/post-terms', array(
        'render_callback' => 'myconianhotel_render_post_terms_block'
    ));

    // myconianhotel/post-navigation
    register_block_type('myconianhotel/post-navigation', array(
        'render_callback' => 'myconianhotel_render_post_navigation_block'
    ));

    // myconianhotel/post-teaser-feed
    register_block_type('myconianhotel/post-teaser-feed', array(
        'render_callback' => 'myconianhotel_render_post_teaser_feed_block',
        'attributes' => array(
            'postSource' => array(
                'type' => 'string',
                'default' => 'manual'
            ),
            'lastUpdate' => array(
                'type' => 'string',
                'default' => myconianhotel_timestamp_to_date( get_option('myconianhotel_magazine_feed_block_data')['timestamp'] ?? 0 )
            )
        )
    ));

    // myconianhotel/contact
    /*register_block_type('myconianhotel/contact', array(
        'render_callback' => 'myconianhotel_render_contact_block',
    ));*/

    // myconianhotel/hotels
    register_block_type('myconianhotel/hotels', array(
        'render_callback' => 'myconianhotel_render_hotels_block',
        'attributes' => array(
            'lastUpdate' => array(
                'type' => 'string',
                'default' => myconianhotel_timestamp_to_date( get_option('myconianhotel_hotels_block_data')['timestamp'] ?? 0 )
            )
        )
    ));

    // myconianhotel/book-form
    register_block_type('myconianhotel/book-form', array(
        'render_callback' => 'myconianhotel_render_book_form_block',
    ));

    // myconianhotel/offers
    register_block_type('myconianhotel/offers', array(
        'render_callback' => 'myconianhotel_render_offers_block',
    ));

    // myconianhotel/google-map
    register_block_type('myconianhotel/google-map', array(
        'render_callback' => 'myconianhotel_render_google_map_block',
    ));
}

/**
 * myconianhotel/hero render callback
 */
function myconianhotel_render_hero_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/hero/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/instagram-feed render callback
 */
function myconianhotel_render_instagram_feed_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/instagram-feed/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/post-acf-fields render callback
 */
function myconianhotel_render_post_acf_fields_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/post-acf-fields/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/post-terms render callback
 */
function myconianhotel_render_post_terms_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/post-terms/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/post-navigation render callback
 */
function myconianhotel_render_post_navigation_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/post-navigation/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/post-teaser-feed render callback
 */
function myconianhotel_render_post_teaser_feed_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/post-teaser-feed/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/contact render callback
 */
function myconianhotel_render_contact_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/contact/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/hotels render callback
 */
function myconianhotel_render_hotels_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/hotels/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/book-form render callback
 */
function myconianhotel_render_book_form_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/book-form/template.php';
    return ob_get_clean();
}

/**
 * myconianhotel/offers render callback
 */
function myconianhotel_render_offers_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/offers/template.php';
    return ob_get_clean();
}


/**
 * myconianhotel/google-map render callback
 */
function myconianhotel_render_google_map_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/google-map/template.php';
    return ob_get_clean();
}

/**
 * Whitelist specific Gutenberg blocks for user roles
 */
add_filter( 'allowed_block_types_all', 'unihalls_allowed_block_types', 10, 2 ); 
function unihalls_allowed_block_types( $allowed_blocks, $editor_context ) {

    if ( false && current_user_can( 'administrator' ) ) {
        if ( ! empty( $editor_context->post ) ) {
            return $allowed_blocks;
        }

        return $editor_context; 
    }

    global $post;

    $blocks = array(
        'core/paragraph',
        'core/heading',
        'core/list',
        'core/list-item',
        'core/quote',
        'core/table',
        //'core/media-text',
        //'core/image',
        //'core/buttons',
        //'core/gallery',
        //'myconianhotel/heading',
        //'myconianhotel/paragraph',
        //'myconianhotel/buttons',
        'myconianhotel/media',
        'myconianhotel/media-text',
        'myconianhotel/media-text-hero',
        'myconianhotel/post-teaser',
        'myconianhotel/media',
        'myconianhotel/hero',
        'myconianhotel/gallery',
        'myconianhotel/gallery-text',
        'myconianhotel/instagram-feed',
        'myconianhotel/group',
        'myconianhotel/interactive-typo',
        'myconianhotel/weather',
        //'myconianhotel/post-acf-fields',
        //'myconianhotel/post-terms',
        //'myconianhotel/post-info'
        //'myconianhotel/post-navigation',
        'myconianhotel/post-teaser-gallery',
        'myconianhotel/files-text',
        'myconianhotel/contact',
        'myconianhotel/hotels',
        'myconianhotel/media-text-slide',
        'myconianhotel/book-form',
        'myconianhotel/google-map',
        'myconianhotel/offers',
        'myconianhotel/free-text',
        'myconianhotel/widget-text',
        'myconianhotel/archive',
        'myconianhotel/masonry',
        'myconianhotel/animation-typo'
    );

    if ( ! empty( $editor_context->post ) ) {
        return $blocks;
    }

    return $editor_context;
}

/**
 * Filter blocks HTML
 */

function getHotelsByTaxonomy($taxonomy_ids, $type = 'group') {
    // Initialize an empty array to hold results
    $hotel_details = [];

    // Loop through each taxonomy ID
    foreach ($taxonomy_ids as $term_id) {
        // Initialize an empty array to store the hotels for the current taxonomy term
        $hotels_in_taxonomy = [];

        // Check the type parameter: If it's a group, process as a group
        if ($type === 'group') {
            // Query hotels associated with this taxonomy term
            $args = [
                'post_type'      => 'hotel', // Query custom post type 'hotel'
                'posts_per_page' => -1, // Get all associated hotels
                'tax_query'      => [
                    [
                        'taxonomy' => 'group', // Replace with the correct taxonomy (e.g., 'group' or 'location')
                        'field'    => 'term_id',
                        'terms'    => $term_id,
                        'operator' => 'IN',
                    ],
                ],
            ];

            $query = new WP_Query($args);

            // Loop through hotels and retrieve necessary information
            if ($query->have_posts()) {
                while ($query->have_posts()) {
                    $query->the_post();

                    // Get the hotel name (title)
                    $hotel_name = get_the_title();

                    // Get the featured image URL for the hotel
                    $featured_image = get_the_post_thumbnail_url(get_the_ID(), 'full'); // You can use other sizes like 'medium', 'thumbnail', etc.

                    // Get the taxonomy terms (locations) associated with the hotel
                    $hotel_locations = wp_get_post_terms(get_the_ID(), 'location'); // Change 'location' if needed
                    $location_names = [];
                    foreach ($hotel_locations as $location) {
                        $location_names[] = $location->name;
                    }

                    // Store the hotel information in the array
                    $hotels_in_taxonomy[] = [
                        'hotel_name'      => $hotel_name,
                        'featured_image'  => $featured_image,
                        'locations'       => $location_names, // Locations associated with the hotel
                    ];
                }
            }

            // Reset the post data after the custom query
            wp_reset_postdata();
        } elseif ($type === 'page') {
            // If it's a page, only return the featured image
            $page = get_post($term_id);
            if ($page && $page->post_type === 'page') {
                // Get the featured image URL for the page
                $featured_image = get_the_post_thumbnail_url($page->ID, 'full'); // You can use other sizes like 'medium', 'thumbnail', etc.

                // Store the page information in the array with empty hotel_name and locations
                $hotels_in_taxonomy[] = [
                    'hotel_name'      => '',
                    'featured_image'  => $featured_image,
                    'locations'       => [],
                ];
            }
        }

        // Add the taxonomy data to the result array, with the taxonomy ID as the key
        if (!empty($hotels_in_taxonomy)) {
            $hotel_details[$term_id] = $hotels_in_taxonomy;
        }
    }

    return $hotel_details;
}


add_filter( 'render_block', function( $rendered_block, $block ) {    

    // myconianhotel/media-text
    if ( 'myconianhotel/media-text' == $block['blockName'] ) {
        
        $rendered_block = str_replace(
            '<figure class="wp-block-media-text__media"></figure>',
            '',
            $rendered_block
        );

        preg_match_all('/<a[^>]+data-type="(group|page)"[^>]+data-id="(\d+)"/', $rendered_block, $matches);

        // Extracted data-type and data-id values
        $dataTypes = $matches[1]; // group or page
        $dataIds = $matches[2]; // data-id values

        if (is_array($dataIds) && count($dataIds) > 0) {
            // Iterate over each match and retrieve hotel information based on type
            foreach ($dataIds as $index => $term_id) {
                $type = $dataTypes[$index]; // Either 'group' or 'page'
                
                if ($type === 'group') {
                    $hotels_info = getHotelsByTaxonomy([$term_id], 'group'); // For group, get hotel details
                } elseif ($type === 'page') {
                    $hotels_info = getHotelsByTaxonomy([$term_id], 'page'); // For page, get only the featured image
                }

                $tippy_images = '';
                foreach ($hotels_info as $hotel_info) {
                    foreach ($hotel_info as $singular_hotel) {
                        $tippy_images .= '<div class="tooltip"><img src="' . $singular_hotel['featured_image'] . '"/></div>';
                    }
                }

                // Escape the tooltip images content to prevent HTML injection
                $escaped_images = htmlspecialchars($tippy_images, ENT_QUOTES, 'UTF-8');

                // Replace the original data-id with the data-tooltip-content
                $rendered_block = str_replace('data-type="' . $type . '" data-id="' . $term_id . '"', 
                                              'data-type="' . $type . '" data-tooltip-content=\'' . $escaped_images . '\' ', $rendered_block);
            }
        }

    }

    // myconianhotel/buttons
    if ( 'myconianhotel/buttons' == $block['blockName'] ) {
        if ( $block['attrs']['linkToForm'] ?? false ) {
            $rendered_block = str_replace(
                'href=',
                'rel="nofollow noopener noreferrer" data-mh-modal-target=',
                $rendered_block
            );
            
            $form = $block['attrs']['linkToForm'];
            add_action( 'wp_footer', function() use ( $form ) {
                get_template_part( 'template-parts/modal', 'form', array( 'wpform' => $form ) );
            });
        }
    }

    // myconianhotel/post-gallery
    if ( 'myconianhotel/gallery' == $block['blockName'] ) {
        if ( str_contains($rendered_block, 'owl-theme-default') ) { // TODO
            $logotype = get_option( 'myconianhotel_logotype' );
            $logotype_angle = get_option( 'myconianhotel_logotype_angle', 0 );

            $rendered_block = str_replace(
                '<div class="wp-block-myconianhotel-gallery__slider ',
                '<div class="gallery-circle">
                      <svg xmlns="http://www.w3.org/2000/svg" width="786" height="785" viewBox="0 0 786 785">
                          <g id="Group_1176" data-name="Group 1176" transform="translate(-1294 -975)">
                            <text id="A" transform="translate(1667 1030) rotate(' . ( 0 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-2" data-name="A" transform="translate(1461.577 1621.707) rotate(' . ( -135 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-3" data-name="A" transform="translate(1939.707 1593.423) rotate(' . ( 135 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-4" data-name="A" transform="translate(1349 1388) rotate(' . ( -90 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-5" data-name="A" transform="translate(2025 1348) rotate(' . ( 90 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-6" data-name="A" transform="translate(1707 1705) rotate(' . ( 180 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-7" data-name="A" transform="translate(1433.293 1144.577) rotate(' . ( -45 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                            <text id="A-8" data-name="A" transform="translate(1911.423 1116.293) rotate(' . ( 45 - ($logotype_angle*-1)) . ')" fill="#EBEAE2" font-size="55" font-family="DomaineSansText-Regular, Domaine Sans Text" letter-spacing="0.056em"><tspan x="0" y="0">' . $logotype . '</tspan></text>
                          </g>
                    </svg>
                </div>
                <div class="wp-block-myconianhotel-gallery__slider ',
                $rendered_block
            );
        }
    }

    // myconianhotel/post-teaser-gallery
    if ( 'myconianhotel/post-teaser-gallery' == $block['blockName'] ) {
        if ( isset( $block['attrs']['mediaPosition'] ) && 'top' == $block['attrs']['mediaPosition'] ) {
            $rendered_block = str_replace(
                '<div class="wp-block-myconianhotel-post-teaser-gallery ',
                '<div class="wp-block-myconianhotel-post-teaser-gallery has-info ',
                $rendered_block
            );
            $rendered_block = str_replace(
                '<div class="wp-block-myconianhotel-gallery__slider',
                '<div class="wp-block-myconianhotel-gallery__info"></div><div class="wp-block-myconianhotel-gallery__slider',
                $rendered_block
            );
        }

        // Group subtitle, title and content, button
        if ( isset( $block['attrs']['mediaPosition'] ) && 'bottom' == $block['attrs']['mediaPosition'] ) {
            $contentInnerBlocks = $block['innerBlocks'][1]["innerBlocks"];

            $has_subtitle = ! str_contains( $contentInnerBlocks[0]['innerHTML'], "></p>" );
            $has_title = ! str_contains( $contentInnerBlocks[1]['innerHTML'], "></h2>" );
            $has_content = ! str_contains( $contentInnerBlocks[2]['innerHTML'], "></p>" );
            $has_buttons = $contentInnerBlocks[3]['innerHTML'];

            if ( trim( $contentInnerBlocks[0]['innerHTML'] ) ) {
                $rendered_block = myconianhotel_str_lreplace(
                    trim($contentInnerBlocks[0]['innerHTML']),
                    '<div>' . $contentInnerBlocks[0]['innerHTML'] . ( ! $has_title ? '</div>' : ''),
                    $rendered_block
                );
            }

            if ( trim( $contentInnerBlocks[1]['innerHTML'] ) ) {
                $rendered_block = myconianhotel_str_lreplace(
                    trim($contentInnerBlocks[1]['innerHTML']),
                    ( ! $has_subtitle ? '<div>' : '') . $contentInnerBlocks[1]['innerHTML'] . '</div>',
                    $rendered_block
                );
            }

            if ( trim( $contentInnerBlocks[2]['innerHTML'] ) ) {
                $rendered_block = myconianhotel_str_lreplace(
                    trim($contentInnerBlocks[2]['innerHTML']),
                    ( ! $has_subtitle && ! $has_title ? '<div></div>' : '') . '<div>' . $contentInnerBlocks[2]['innerHTML'] . ( ! $has_buttons ? '</div>' : ''),
                    $rendered_block
                );
            }

            if ( trim( $contentInnerBlocks[3]['innerHTML'] ) ) {
                $rendered_block = myconianhotel_str_lreplace(
                    trim($contentInnerBlocks[3]['innerHTML']),
                    ( ! $has_subtitle && ! $has_title ? '<div></div>' : '') . ( ! $has_content ? '<div>' : '') . ($has_buttons ? $contentInnerBlocks[3]['innerHTML'] . '</div>' : '</div>'),
                    $rendered_block
                );
            }
        }
    }

    // myconianhotel/weather
    if ( 'myconianhotel/weather' == $block['blockName'] ) {
        $feed = myconianhotel_fetch_block_data(
            'https://api.open-meteo.com/v1/forecast?latitude=37.4515036&longitude=25.3396485&hourly=temperature_2m&timezone=auto&forecast_days=1&forecast_hours=1',
            'myconianhotel_weather_block_data',
            HOUR_IN_SECONDS
        );
        $date = new DateTime( "now", new DateTimeZone( 'Europe/Athens'  ) ); //get_option( 'timezone_string' )
        $temp = $feed['hourly']["temperature_2m"][0].$feed['hourly_units']["temperature_2m"];
        $rendered_block = str_replace( "[temp]", $temp, $rendered_block );
        $rendered_block = str_replace( "[time]", $date->format('H:i') ?: null, $rendered_block );
    }

    // myconianhotel/contact
    if ( 'myconianhotel/contact' == $block['blockName'] ) {
        
        if ( 'collection' == get_option( 'myconianhotel_colorscheme', null ) ) {
            $index = 0;
        } else {
            $index = 1;            
        }

        $form_id = $block['innerBlocks'][$index]['innerBlocks'][0]['attrs']['formId'] ?? null;


        if ( $form_id ) {
            $form = wpforms()->form->get( $form_id );

            if ( ! empty( $form ) && ( $form->post_excerpt ?? null) ) {
                $rendered_block = myconianhotel_str_lreplace(
                    esc_html( $form->post_excerpt ),
                    '',
                    $rendered_block
                );
                $rendered_block = myconianhotel_str_lreplace(
                    '<div class="wpforms-container',
                    '<h2 class="wp-block-heading">' . esc_html( $form->post_excerpt ) . '</h2><div class="wpforms-container',
                    $rendered_block
                );
            }
        }
    }

    // Remove empty paragraphs
    if ( 'myconianhotel/archive' !== $block['blockName'] ) {
        preg_match_all( '~(<p[^>]*><\/p>)~i', $rendered_block, $matches );
        if ( count( $matches ) ) {
            for ( $m=0; $m < count( $matches[0] ); $m++ ) {
                if ( ! empty($matches[0][$m]) ) {
                    $rendered_block = str_replace( $matches[0][$m], '', $rendered_block );
                } 
            }
        }      
    }
    // Remove empty headers
    preg_match_all( '~(<h2[^>]*><\/h2>)~i', $rendered_block, $matches );
    if ( count( $matches ) ) {
        for ( $m=0; $m < count( $matches[0] ); $m++ ) {
            if ( ! empty($matches[0][$m]) ) {
                $rendered_block = str_replace( $matches[0][$m], '', $rendered_block );
            } 
        }
    }
    // Remove empty figures
    preg_match_all( '~(<figure[^>]*><\/figure>)~i', $rendered_block, $matches );
    if ( count( $matches ) ) {
        for ( $m=0; $m < count( $matches[0] ); $m++ ) {
            if ( ! empty($matches[0][$m]) ) {
                $rendered_block = str_replace( $matches[0][$m], '', $rendered_block );
            } 
        }
    }
           
    // Remove consecutive newline characters
    $pattern = "/\n{2,}/"; // Matches two or more consecutive newline characters
    $replacement = "";
    $rendered_block = preg_replace($pattern, $replacement, $rendered_block);

    return $rendered_block;
}, 2, 2);

/**
 * Modify theme json
 */
add_filter( 'wp_theme_json_data_theme', 'myconianhotel_filter_theme_json' );
function myconianhotel_filter_theme_json( $theme_json ) {
    $myconianhotel_colorscheme = get_option( 'myconianhotel_colorscheme', null );

    // Get the theme.json data as an array.
    $data = $theme_json->get_data();

    // Primary background colors
    $backgrounds = array(
        // ambassador is the default
        "deos" => "#465A32",
        "kyma" => "#0F5EBC",
        "avaton" => "#871515",
        "royal" => "#BFA06D",
        "utopia" => "#10592D",
        "imperial" => "#E9E7E4",
        "villa" => "#AA5C83",
        "kove" => "#903A1C",
        "sunrize" => "#52635E",
        "o" => "#434B55",
        "naia" => "",
        "korali" => "#F4E134"
    );

    // Primary text colors
    $colors = array(
        // ambassador is the default
        "deos" => $backgrounds['deos'],
        "kyma" => $backgrounds['kyma'],
        "avaton" => $backgrounds['avaton'],
        "royal" => "#8E7755",
        "utopia" => $backgrounds['utopia'],
        "imperial" => "#150101",
        "villa" => $backgrounds['villa'],
        "kove" => $backgrounds['kove'],
        "sunrize" => $backgrounds['sunrize'],
        "o" => "#1E2125",
        "naia" => "",
        "korali" => "#150101"
    );

    if ( 'collection' == $myconianhotel_colorscheme /*&& isset( $data['settings']['custom'] )*/ ) {
        $data['settings']['custom']['rootPaddingRightFallback'] = 'var(--wp--preset--spacing--30)';
        $data['settings']['custom']['rootPaddingLeftFallback'] = 'var(--wp--preset--spacing--30)';
        $data['settings']['custom']['mediaTextHeroBlockDefaultBackgroundSlug'] = 'lightergray';
        $data['settings']['custom']['mediaTextHeroBlockInnerDefaultBackgroundSlug'] = 'white';

        $data['settings']['color']['palette'] = 
            [
                [
                    "name"  => "Primary color",
                    "slug"  => "darkblue",
                    "color" => "#B4AEA1"
                ],
                [
                    "name"  => "primary-text",
                    "slug"  => "primary-text",
                    "color" => "#150101"
                ],
                [
                    "name"  => "Black",
                    "slug"  => "black",
                    "color" => "#150101"
                ],
                [
                    "name"    => "Light brown",
                    "slug"    => "lightbrown",
                    "color"   => "#B4AEA1"
                ],
                [
                    "name"  => "Dark gray",
                    "slug"  => "darkgray",
                    "color" => "#DBD8D1"
                ],
                [
                    "name"  => "Light gray",
                    "slug"  => "lightgray",
                    "color" => "#E9E7E4"
                ],                
                [
                    "name"  => "Lighter gray",
                    "slug"  => "lightergray",
                    "color" => "#F7F7F7"
                ],                
                [
                    "name"  => "White (Default)",
                    "slug"  => "white",
                    "color" => "#FFFFFF"
                ], 
            ];

        $data['styles']['color']['text'] = 'var(--wp--preset--color--black)';
        $data['styles']['elements']['button']['spacing']['margin']['top'] = 'var(--wp--preset--spacing--20)'; // TODO
    }

    if ( isset( $backgrounds[$myconianhotel_colorscheme] ) && $backgrounds[$myconianhotel_colorscheme] ) {
        // Primary background colors
        $data['settings']['color']['palette']['theme'][0] =
            [
                "name"  => "Primary color",
                "slug"  => "darkblue", // Important to keep the same slug. Is used as primary color. Sad but true
                "color" => $backgrounds[$myconianhotel_colorscheme]
            ];
        // Primary text colors
        $data['settings']['color']['palette']['theme'][1] =
            [
                "name"  => "Primary Text color",
                "slug"  => "primary-text", // Important to keep the same slug. Is used as primary color. Sad but true
                "color" => $colors[$myconianhotel_colorscheme]
            ];
    }

    // Create a new WP_Theme_JSON object with the modified data.
    return new WP_Theme_JSON( $data, 'theme' );
}

/**
 * Add admin body classes
 */
add_filter( 'admin_body_class', 'myconianhotel_admin_body_class' );
function myconianhotel_admin_body_class( $classes ) {    
    if ( 'align-left' == get_option( 'myconianhotel_subtheme' ) ) {
        $classes .= ' myconianhotel-subtheme-align-left';
    }
    return $classes;
}

/**
 * Fetch block data
 * TODO: Change name. Is not only for blocks
 */
function myconianhotel_fetch_block_data( $url, $db_option, $duration, $force_update = false ) {
    // Define the option name where data will be cached
    $option_name = $db_option;
    // Try to get the cached data
    $cached_data = get_option( $option_name );

    $timestamp = time();

    // Check if cached data exists and if it's still valid (less than duration old)
    if ( ! $force_update && $cached_data && isset($cached_data['timestamp']) && $timestamp - $cached_data['timestamp'] < $duration ) {
        // Return cached JSON data
        return $cached_data['feed'];
    }
    
    // If no valid cache exists or forced update, fetch new data
    $response = @file_get_contents( $url );


    if ( $response === false ) {
        // Handle the error (optional, e.g., log the issue)
        return false;
    }

    // Decode the JSON response to ensure it's valid
    $feed = json_decode( $response, true );

    if ( $feed === null ) {
        // Handle JSON decoding errors (optional)
        return false;
    }

    // Store the new data and current timestamp in the WP option
    update_option($option_name, [
        'feed' => $feed,
        'timestamp' => $timestamp,
    ]);

    // Return the fresh JSON data   
    return $feed;
}

/**
 * Find posts using image endpoint
 */
add_action('rest_api_init', function () {
    register_rest_route('myconianhotel/v1', '/image-usage/(?P<id>\d+)', [
        'methods'  => 'GET',
        'callback' => function ($request) {
             $attachment_id = $request['id'];
            $exclude_ids = $request->get_param('exclude');

            // Convert exclude param to array if it's a string
            if (!is_array($exclude_ids)) {
                $exclude_ids = array_filter(array_map('intval', explode(',', $exclude_ids)));
            }

            $posts = find_posts_using_image($attachment_id, $exclude_ids);

            return rest_ensure_response(array_map(function($post) {
                return [
                    //'id'    => $post->ID,
                    'label' => ucfirst(get_post_type($post)) . ': ' . get_the_title($post),
                    'value'  => get_permalink($post),
                ];
            }, $posts));
        },
        'permission_callback' => '__return_true',
    ]);
});

/**
 * Block css object position rule orientation
 */
function myconianhotel_block_vertical_position( $mediaOrientation, $originalAspectRatio, $aspectRatio ) {
    $addVerticalPositioning = false;

    if ('unset' !== $aspectRatio) {
        if ('portrait' == $mediaOrientation) {
            $addVerticalPositioning = true;
            if ( $originalAspectRatio > eval('return ' . $aspectRatio . ';') ) {
                $addVerticalPositioning = false;
            }            
        } else if ('landscape' == $mediaOrientation) {
            $addVerticalPositioning = false;
            if ( $originalAspectRatio < eval('return ' . $aspectRatio . ';') ) {
                $addVerticalPositioning = true;
            }            
        }
    } else {
        if ('portrait' == $mediaOrientation) {
            $addVerticalPositioning = true;
        }
    }

    return $addVerticalPositioning;
}