// npm install --save-dev grunt-php
// npm install --save-dev load-grunt-tasks

module.exports = function(grunt) {

  const sass = require('node-sass');
  require('load-grunt-tasks')(grunt);

  // Project configuration.
  grunt.initConfig({

    paths: {
      src: '.',
      dist: '..',
      modules: './node_modules',
      vendor: './vendor'
    },

    pkg: grunt.file.readJSON('package.json'),

    php: {
      dist: {
        options: {
          hostname: '127.0.0.1',
          port: 8010,
          base: '.', // Project root
          keepalive: false,
          open: false
        }
      }
    },

    browserSync: {
      dist: {
        bsFiles: {
          src : [
              '<%= paths.dist %>/css/*.css',
              '<%= paths.dist %>/js/*.js',
              '<%= paths.dist %>/*.html',
              '<%= paths.dist %>/../**/*.php'
            ]
        },
        options: {
          proxy: 'localhost/myconian-hotel',
          port: 8080,
          //server: "./dist",
          watchTask: true,
          notify: true,
          open: true,
          //logLevel: 'silent',
          ghostMode: {
            clicks: true,
            scroll: true,
            links: true,
            forms: true
          }
        },        
      }
    },
    copy: {
      options: {
        separator: '',
        punctuation: '',
      },
      js: {
        files: [
          { src:"<%= paths.src %>/js/main.js", dest:"<%= paths.dist %>/js/main.js" }
        ]
      }
    },
    concat: {
      options: {
        separator: ';',
      },
      // Include all js plugins in a single file on dist
      js: {
        src: [
          //'<%= paths.vendor %>/jquery-ui-effects-core.min.js'
        ],
        dest: '<%= paths.dist %>/js/scripts.concat.js',
      },
      // Include all css plugins as sass partial on src
      css: {
        src: [
          //'<%= paths.vendor %>/owl_carousel_2/assets/owl.carousel.css'
        ],
        dest: '<%= paths.src %>/sass/_modules.concat.scss',
      },
    },
    sass: {
      options: {
        outputStyle: 'compressed',
        implementation: sass,
        sourceMap: true
      },
      main: {
        files: {
          '<%= paths.dist %>/css/main.css' : '<%= paths.src %>/sass/main.scss',
        }
      },
      wpblocks: {
        files: {
          '<%= paths.dist %>/css/wp-block-library-myconianhotel.css' : '<%= paths.src %>/sass/wp-block-library-myconianhotel.scss',
          '<%= paths.dist %>/css/wp-block-library-ambassador.css' : '<%= paths.src %>/sass/ambassador/wp-block-library-ambassador.scss',
          '<%= paths.dist %>/css/wp-block-library-collection.css' : '<%= paths.src %>/sass/collection/wp-block-library-collection.scss',
          '<%= paths.dist %>/css/wp-block-library-kove.css' : '<%= paths.src %>/sass/kove/wp-block-library-kove.scss',
          '<%= paths.dist %>/css/wp-block-library-imperial.css' : '<%= paths.src %>/sass/imperial/wp-block-library-imperial.scss',
          '<%= paths.dist %>/css/wp-block-library-korali.css' : '<%= paths.src %>/sass/korali/wp-block-library-korali.scss'
        }
      }
    },

    watch: {
      sass: {
        files: ['<%= paths.src %>/sass/**/*.scss'],
        tasks: ['sass:main']
      },
      'js': {
        files: ['<%= paths.src %>/js/main.js'],
        tasks: ['copy:js']
      },      
      wpblocks: {
        files: [
          '<%= paths.src %>/sass/**/*.scss'
        ],
        tasks: ['sass:wpblocks']
      },
      php: {
        files: ['<%= paths.dist %>/../**/*.php']
      }
    }
  });

  // Load the plugin that provides the "uglify" task.
  grunt.loadNpmTasks('grunt-browser-sync');
  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-watch');
  grunt.loadNpmTasks('grunt-contrib-copy');
  grunt.loadNpmTasks('grunt-sass');
  // grunt.loadNpmTasks('grunt-contrib-cssmin');
  // grunt.loadNpmTasks('grunt-contrib-imagemin');

  // Default task(s).
  grunt.registerTask('default', ['php', 'browserSync', 'watch']);
  /*grunt.registerTask('getbootstrap', 'Download and init bootstrap for this project.', function() {
    
  });*/

  /*grunt.registerTask('serve', [
    'php:dist',         // Start PHP Server
    'browserSync:dist', // Using the PHP instance as a proxy
    'watch'             // Any other watch tasks you want to run
  ]);*/

  //grunt.registerTask('phpwatch', ['php:watch', 'watch']);

};