document.addEventListener("DOMContentLoaded", function() {
    if (navigator.userAgent.match(/Mobi|Android|iPhone|iPad|iPod/i)) {
        document.body.classList.add("is-device");
    }
});

(function($){

$(document).ready(function() {

	var booklink = $('#booking-menu-column').attr('data-reserve');
	var checkInLink;
	var nightsLink;
	var rooms;
	var adults;
	var finStartDate
	var finEndDate;
	var timeDifference;
	var nights;
	var windowWidth;
	var startDateString;
	var endDateString;
	var start_val;
	var end_val;
	var start_time;
	var end_time;


	//LOTTIE ANIMATIONS

	$('a[data-type="group"]').click(function(e){
		e.preventDefault();
	})

	$('a[data-type="group"], a[data-type="page"]').mouseenter(function(){
		
		var thisParent = $(this).closest('.wp-block-myconianhotel-media-text')
		var tooltipContent = $(this).attr('data-tooltip-content')
		console.log(tooltipContent)
		console.log(thisParent)

		thisParent.prepend(tooltipContent);
	})

	$('a[data-type="group"], a[data-type="page"]').mouseleave(function(e){
		$('.tooltip').remove()
	})

	$('.mobile-book-button').click(function(){

		if(!$('#main-nav').hasClass('right-opened')){
			$('.mobile-book-button').fadeOut();
		}
		$('.open-book-menu').trigger('click');
	
	})

	$('.mobile-booking-close').click(function(){

		$('.mobile-book-button').fadeIn();
		$('.open-book-menu').trigger('click');
	
	})

    var footer_params = {
        container: document.getElementById('footer-animation'),
        renderer: 'svg',
        loop: true,
        autoplay: true,
        path: theme.baseurl + '/wp-content/uploads/lottie-files/footer.json'
    };

    var footer_anim;

    footer_anim = lottie.loadAnimation(footer_params);

    var menu_params = {
        container: document.getElementById('menu-animation'),
        renderer: 'svg',
        loop: false,
        autoplay: false,
        path: theme.baseurl + '/wp-content/uploads/lottie-files/menu-fast.json'
    };

    var menu_anim;

    menu_anim = lottie.loadAnimation(menu_params);


    var loader_params = {
	    container: document.getElementById('loader-content-animation'),
	    renderer: 'svg',
	    loop: false,
	    autoplay: false,
	    path: theme.baseurl + '/wp-content/uploads/lottie-files/loader.json' 
    };


	if (getCookie('visited') !== 'true') {
        var loader_anim = lottie.loadAnimation(loader_params);
        loader_anim.addEventListener('enterFrame', function(event) {
            var currentFrame = event.currentTime;
            if (currentFrame >= 100 && currentFrame < 101) {
                afterLoader();
            }
        });
        function afterLoader(){
            $('.home-loader').addClass('opened');
            $('.home-spacer').css({
                'height' : '0'
            });
            setTimeout(function(){
                $('.home-loader').fadeOut();
                $('.home-menu').removeClass('home-menu')
            }, 1500)
        }
    } else {
        $('.home-menu').removeClass('home-menu');
        $('.home-spacer').remove();
        $('.home-loader').remove();
    }

	//MAIN WEBSITE


	$('.hotel-wording').click(function(){
		if ($('.booking-col').hasClass('opened')){
			$('.external-booking .hotel-listing').slideToggle();
		}

		if ($('#main-nav').hasClass('opened-right')){
			$('.internal .hotel-listing').slideToggle();
		}
	})

	$('.booking-hotel').click(function(){
		var thisWording = $(this).text().trim();
		booklink =  $(this).data('url');
		generateBookingLink(startDate, nights, rooms, adults);
		$('.hotel-wording').text(thisWording)
		$('.hotel-listing').slideUp();
	})

	var openMenuWording = $('.open-main-menu').text().trim();
	var closeMenuWording = 'CLOSE';

	var openBookWording = $('.open-book-menu a').text().trim();
	var closeBookWording = 'CLOSE';
	
	var windowWidth = $(window).width();
	var animationDuration = 300;

	var internalBookingOptions = {
		loop:true,
		margin:10,
		responsiveClass:true,
		nav:false,
		onRefreshed: displayInternalBooking,
		responsive:{
		    0:{
		        items:1
		    },
		    600:{
		        items:2
		    },
		    1000:{
		        items:3,
		        loop:false
		    },
		    1600:{
		        items:3,
		        loop:false
		    }
		}
	}
	
	if ($('.home-loader').length > 0){
		setCookie('visited','true',30);
		$('#loader-content-animation').animate({
			opacity : '1'
		}, 500, function(){
			loader_anim.play();
		});
	}
	
	$('.open-main-menu').click(function(){

		if (!$('#main-nav').hasClass('opened')){

			$('.open-main-menu').text(closeMenuWording);
			$('#main-nav').toggleClass('opened-left')
			$('#main-nav').removeClass('opened-right')
			$('#main-nav').addClass('opened');
			menu_anim.play();
		}
		else{
			$('.open-main-menu').text(openMenuWording);
			$('#main-nav').removeClass('opened');
			$('#main-nav').removeClass('opened-left')
			$('#main-nav').removeClass('opened-right')
			if (parallaxExists()){
				if (!parallaxFinished()){
					$('#main-nav').addClass('scrolled-out');
				}
			}
			menu_anim.stop();
		}
	})

	$('.open-main-menu-static').click(function(){
		$('#main-nav').removeClass('scrolled-out');
		setTimeout(function(){
			$('.open-main-menu').trigger('click');
			menu_anim.play();
		}, 200)
		
	})

	$('.open-main-menu a').click(function(e){
		e.preventDefault();
	})

	$('.open-book-menu').click(function(){
		menu_anim.stop();
		if (!$('#main-nav').hasClass('opened-right')){
			$('.open-book-menu a').text(closeBookWording);
			$('.menu-blue-overlay').fadeIn();
			$('.outer-menu-items').hide();
			$('#menu-main-menu-external').hide();
			$('#main-nav').addClass('opened-right');
			$('#main-nav').removeClass('opened-left');
			$('#main-nav').addClass('opened');
			setTimeout(function(){
				var bookigCarouselSec = $('#monthContainer2').owlCarousel(internalBookingOptions);
                $(document).on('click', '.next-month', function(){
                    bookigCarouselSec.trigger('next.owl.carousel');
                });
                $(document).on('click', '.prev-month', function(){
                    bookigCarouselSec.trigger('prev.owl.carousel');
                });
			}, animationDuration)
		}
		else{
			$('.open-book-menu a').text(openBookWording);
			$('.open-main-menu').text(openMenuWording);
			$('.menu-blue-overlay').fadeOut();
			$('.booking-module-container.internal').css('opacity', 0);
			$('#main-nav').removeClass('opened-right');
			$('#monthContainer2').owlCarousel("destroy");
			$('#main-nav').removeClass('opened');
			if (parallaxExists()){
				if (!parallaxFinished()){
					$('#main-nav').addClass('scrolled-out');
				}
			}
			setTimeout(function(){
				$('.outer-menu-items').show();
				$('#menu-main-menu-external').show();
			}, animationDuration)
		}
		
	})

	function displayInternalBooking(e){
		$('.booking-module-container.internal').css('opacity', 1);
	}

	$('.open-book-menu a').click(function(e){
		e.preventDefault();
	})

	$('.main-navbar .menu-open').click(function(){
		$('.main-navbar-wrapper').toggleClass('opened')
	})

	$('.static-nav-wrapper .menu-open').click(function(){
		$('.main-navbar').toggleClass('opened')
		$('.main-navbar-wrapper').toggleClass('opened')
	})


	$('.main-nav-content > .menu-item').mouseenter(function(){
		if (windowWidth > 991) {
			if($(this).hasClass('menu-item-has-children')){
				$('.sub-menu').not($(this).find('.sub-menu')).fadeOut();
				$(this).find('.sub-menu').fadeIn();
			}
			else{
				$('.sub-menu').fadeOut();
			}
			
		}
	})

	$('.menu-item a').mouseenter(function(){
		var thisId = $(this).closest('.menu-item').attr('id');
		$('.menu-item-img').fadeOut();
		$('.menu-item-img[data-menu-item="'+thisId+'"]').fadeIn();
		console.log(thisId)
	})

	$('.menu-item a').mouseleave(function(){
		$('.menu-item-img').fadeOut();
	})

	$('.wp-block-myconianhotel-hotels .hotel-name').hover(function(){
		var thisId = $(this).attr('data-img');
		$('.wp-block-myconianhotel-hotels .hotel-img').hide();
		$('.wp-block-myconianhotel-hotels .hotel-img[data-id="'+thisId+'"]').show();
	});

	$('.wp-block-hotels__content').mouseleave(function(){
		$('.wp-block-myconianhotel-hotels .hotel-img').hide();
	})

	var bookingCarouel = $('#monthContainer').owlCarousel({
        loop:true,
        margin:10,
        responsiveClass:true,
        nav:false,
        responsive:{
            0:{
                items:1
            },
            600:{
                items:2
            },
            1000:{
                items:3,
                loop:false
            }
        }
    })
    $(document).on('click', '.next-month', function(){
        bookingCarouel.trigger('next.owl.carousel');
    });
    $(document).on('click', '.prev-month', function(){
        bookingCarouel.trigger('prev.owl.carousel');
    });

	//BOOKING MODULE FUNCTIONALITY

	$(document).on('click', '.external-booking .sel-date-wrapper, .external-booking .sel-hotel-wrapper, .sel-hotel-wrapper .external-booking #rooms, .external-booking #guests, .external-booking .dropdown-icon, .external-booking .booking-module-overlay', function(e){

        if (windowWidth > 0){
            e.stopPropagation();

            if (!$('.booking-col').hasClass('opened')){
            	$('.booking-module-container').addClass('opened');
                $('.booking-col').addClass('opened')
                $('.booking-calendar').animate({
                    'height':$('#monthContainer').outerHeight(),
                })
                $('.static-navbar').fadeOut();
                // $('.section-separator').addClass('opened');     
            }
        }

    })

    $(document).on('click', '.view-results a', function(e){
		if(! $(this).hasClass('mobile-booking-redirect')){
			if (!$('.booking-col').hasClass('opened')){
				e.preventDefault();
				$('.booking-module-container').addClass('opened');
				$('.booking-col').addClass('opened')
				$('.booking-calendar').animate({
					'height':$('#monthContainer').outerHeight(),
				})
				$('.static-navbar').fadeOut();
			}

			if (windowWidth < 992){
				$('#main-nav').fadeOut()
			}
		}
    })


	$(document).on('click', function(e) {
        closeBooking(e)
    });

    $(document).on('click', '.mobile-booking-close', function(e){
		$('.booking-module-container').removeClass('opened');
       	$('.booking-col').removeClass('opened')
       	$('.booking-calendar').animate({
       	    'height':0,
       	})
       	$('.static-navbar').fadeOut();

       	$('#main-nav').fadeIn()
	})

	function closeBooking(e){
		if (windowWidth > 991){
            if (!$(e.target).closest('.booking-col').length) {

            	$('.booking-calendar').animate({
                    'height': 0,
                })
            	$('.booking-col').removeClass('opened')
                $('.booking-module-container').removeClass('opened');
                 $('.static-navbar').fadeIn();
                 $('.hotel-listing').slideUp();
            }
        }
	}


    $(document).on('keydown', function(e) {
	    if (event.key === "Escape" || event.keyCode === 27) {
            closeBooking(e)
            if (!$('#main-nav').hasClass('opened-right')){
                $('.open-main-menu').trigger('click')
            }
            else{
                $('.open-book-menu a').text(openBookWording);
                $('.open-main-menu').text(openMenuWording);
                $('.menu-blue-overlay').fadeOut();
                $('.booking-module-container.internal').css('opacity', 0);
                $('#main-nav').removeClass('opened-right');
                $('#monthContainer2').owlCarousel("destroy");
                $('#main-nav').removeClass('opened');
                if (parallaxExists()){
                    if (!parallaxFinished()){
                        $('#main-nav').addClass('scrolled-out');
                    }
                }
                setTimeout(function(){
                    $('.outer-menu-items').show();
                    $('#menu-main-menu-external').show();
                }, animationDuration)
            }
        }
	});


    $(document).on('click', '.day-wrapper', function(){

        if ($('.selected-start-date').length < 1){

            if (!$(this).parent().hasClass('past-day')){
                // $(this).parent().addClass('selected-start-date');
				var thisStart = $(this).parent().attr('data-time');
				$('td[data-time="'+thisStart+'"]').addClass('selected-start-date');
                $('.start-date').text($(this).parent().attr('data-b-date'));
                start_time = Number($(this).parent().attr('data-time'));
                $('.sep-date').text('-');
                $('.sep-date').css('margin','0 9px');
                $('.end-date').text('Check out date');
                startDateString = $(this).parent().attr('data-date');
            }

        }
        else{
            if (!$(this).parent().hasClass('selected-start-date')){
                if ($('.selected-end-date').length > 0){
                   
                    //If end date exists

                    if (!$(this).parent().hasClass('past-day')){

                        $('.av-day').css('background', 'transparent');
                        $('.selected-start-date').removeClass('selected-start-date');
                        $('.selected-end-date').removeClass('selected-end-date');
                        $(this).parent().addClass('selected-start-date');
                        $('.start-date').text($(this).parent().attr('data-b-date'));
                        startDateString = $(this).parent().attr('data-date');
                        start_time = Number($(this).parent().attr('data-time'));
                        $('.end-date').text('Check out date');
                    }

                }
                else{
                    //If end date doesnt exist
                    if (!$(this).parent().hasClass('past-day')){
                        end_time = Number($(this).parent().attr('data-time'));
                        if (end_time < start_time){
                            
                            $('.selected-start-date').removeClass('selected-start-date');
                            $('.selected-end-date').removeClass('selected-end-date');
                            $(this).parent().addClass('selected-start-date');
                            $('.start-date').text($(this).parent().attr('data-b-date'));
                            startDateString = $(this).parent().attr('data-date');
                            $('.end-date').text('');
                            start_time = Number($(this).parent().attr('data-time'));
                        }
                        else{
                            
							var thisEnd = $(this).parent().attr('data-time');
							$('td[data-time="'+thisEnd+'"]').addClass('selected-end-date');
                            // $(this).parent().addClass('selected-end-date');
                            $('.end-date').text($(this).parent().attr('data-b-date'));
                            endDateString = $(this).parent().attr('data-date');

                            var selectedElements = $('.av-day').filter(function() {
                                return $(this).attr('data-time') >= start_time && $(this).attr('data-time') <= end_time
                            });


                            if ($('.selected-start-date').length > 0 && $('.selected-end-date').length > 0){
                                finStartDate = new Date(startDateString);
                                finEndDate = new Date(endDateString);

                                timeDifference = finEndDate - finStartDate;

                                // Convert milliseconds to days
                                nights = Math.floor(timeDifference / (1000 * 60 * 60 * 24));

                                checkInLink = '?checkin='+startDateString;
                                nightsLink = '&nights='+nights;

                                $('.view-results .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
                                $('.view-results-mob .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
                            }

                            if (windowWidth > 1200){
                                selectedElements.css('background', '#F9F8F6');
                            }
                            else{
                                selectedElements.css('background', '#FFFFFF');
                            }
                        }
                    }
                }
            }
        }
 
    })

	$(document).on('click', '.op-sign-minus',function(){

        var thisTarget = $(this).attr('data-target');
        var thisVal = Number($('#'+thisTarget).attr('data-val'));

        if (thisVal > 1){
            var newVal = thisVal - 1;
            $('div[data-ident="'+thisTarget+'"]').text(newVal);
            $('div[data-ident="'+thisTarget+'"]').attr('data-val',newVal);
        }

        $('.view-results .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
        $('.view-results-mob .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
        
    })

    $(document).on('click', '.op-sign-plus',function(){
        var thisTarget = $(this).attr('data-target');
        var thisVal = Number($('#'+thisTarget).attr('data-val'));

        if (thisVal < 10){
            var newVal = thisVal + 1;
            $('div[data-ident="'+thisTarget+'"]').text(newVal);
            $('div[data-ident="'+thisTarget+'"]').attr('data-val', newVal);
        }

        $('.view-results .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
        $('.view-results-mob .wording a').attr('href',generateBookingLink(startDateString, nights, $('#rooms').attr('data-val'), $('#guests').attr('data-val')))
          
    })


	function generateBookingLink(startDate, nights, rooms, adults){
    if (startDate != undefined && nights != undefined && rooms != undefined && adults != undefined){
        var finalLink = booklink+'?checkin='+startDate+'&nights='+nights+'&rooms='+rooms+'&adults='+adults;

        return finalLink;
    }
    else{
        return booklink;
    }
	}

	$(window).on('scroll', function() {

		if (parallaxExists()){
			
			if (!$('#main-nav').hasClass('opened')){
	        	if (parallaxFinished()){
		        	$('#main-nav').removeClass('scrolled-out')
		        }
		        else{
		        	$('#main-nav').addClass('scrolled-out')
		        }
	        }

		}

		if ($('.accommodation-main-content .info').length > 0){
			var elementTop = $('.accommodation-main-content .info').get(0).getBoundingClientRect().top;

	        if (!$('.main-navbar-wrapper').hasClass('opened')){
	        	if (elementTop < 120 && elementTop > 90){
		        	$('.accommodation-nav').addClass('opened');
		        	$('#main-nav').addClass('opened')
		        }
		        else{
		        	$('.accommodation-nav').addClass('opened');
		        	$('#main-nav').removeClass('opened')
		        }
	        }

		}
                
    });

    function setCookie(name,value,days) {
	    if (days) {
	        var date = new Date();
	        date.setTime(date.getTime()+(days*24*60*60*1000));
	        var expires = "; expires="+date.toGMTString();
	    }
	    else var expires = "";
	    document.cookie = name+"="+value+expires+"; path=/";
	}

	function parallaxExists(){
		var blockAfterParalax = $('.entry-content > .wp-block-myconianhotel-hero').next();
		if (blockAfterParalax.length > 0){
			return true;
		}
		else{
			return false;
		}
	}

	function getCookie(name) {
        let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        return match ? match[2] : null;
    }

	function getElementAfterParallax(){
		if(parallaxExists()){

			var blockAfterParalax = $('.entry-content > .wp-block-myconianhotel-hero').next().get(0);

			return blockAfterParalax;
		}
		else{
			return false;
		}
	}

	function parallaxFinished(){
		if(getElementAfterParallax()){
			var blockAfterParallax = getElementAfterParallax();
			var elementTop = blockAfterParallax.getBoundingClientRect().top;
			var triggerHeight = 130;
			var triggerHeightAccomodation = 240;

			if(windowWidth < 1400){
				triggerHeight = 70;
				triggerHeightAccomodation = 150;
			}

			if($('.wp-block-myconianhotel-accommodation-filters').length > 0){
				triggerHeight = triggerHeightAccomodation;
				
			}

			if (elementTop < triggerHeight){
				return true;
			}
			else{
				return false;
			}
		}
	}

})


})(jQuery)