<?php

/** 
 *  Add custom class to the WPForms submit button
 *  Add custom Form Footer Description to WPForm general settings
 *  Custom post type select
 *  Custom input type number
 */

/**
 * Add custom class to the WPForms submit button
 */
add_filter( 'wpforms_frontend_form_data', 'myconianhotel_wpforms_frontend_form_data' );
function myconianhotel_wpforms_frontend_form_data( $form_data ) {
    $form_data['settings']['submit_class'] .= ' wp-element-button';
    return $form_data;
}

/**
 * Add custom Form Footer Description to WPForm general settings
 */
add_action( 'wpforms_form_settings_panel_content', function( $settings ) {
    wpforms_panel_field(
        'textarea',
        'settings',
        'form_footer_desc',
        $settings->form_data,
        esc_html__( 'Form Footer Description', 'wpforms-lite' ),
        [
            'tooltip' => esc_html__( 'Enter descriptive text or instructions to help your users understand the requirements of your form.', 'wpforms-lite' ),
        ]
    );
});

/**
 * Custom post type select
 *  Add select with one option [posttype]
 *
 * Custom input type number
 *  Add classes min-[number] max-[number] step-[number] to input's css field in admin
 */
add_action( 'wpforms_wp_footer_end', 'myconianhotel_wpforms_wp_footer_end', 30 );
function myconianhotel_wpforms_wp_footer_end() {
    global $post;   
    ?>
    <script type="text/javascript">
        <?php // Custom post type select ?>

        (function($){
        	const $selectPositions = $('[value="[position]"]').closest('select');
        	const $selectHotels = $('[value="[hotel]"]').closest('select');
            const theSlug = '<?php echo $post->post_name; ?>';
            const isSingular = <?php echo is_singular( 'position' ) ? 1 : 0 ?>;

            let selectedPosition = [];

        	if ( $selectPositions.length ) {
        		fetchCustomPosts($selectPositions, 'position', 'myconianhotel_related_hotels');
	        	
	        	$selectPositions.on('change', function() {
                    const relatedHotel = $(this).find(':selected').data('myconianhotel_related_hotels');
	        		$selectHotels.find('option').removeAttr('disabled');
	        		$selectHotels.find(`option:not([data-id="${relatedHotel}"])`).attr('disabled', "");
                    $(this).prev('.wpforms-myconianhotel-select-clear').show();
                    // Fix still invalid bug
                    if ($(this).val()) {
                        $(this).next('.wpforms-error').remove();
                    }
                    
	        	});
        	}

        	if ( $selectHotels.length ) {
        		fetchCustomPosts($selectHotels, 'hotel');

	        	$selectHotels.on('change', function(){
                    const hotel = $(this).find(':selected').data('id');
	        		$selectPositions.find('option').removeAttr('disabled');
	        		$selectPositions.find(`option:not([data-myconianhotel_related_hotels="${hotel}"])`).attr('disabled', "");
                    $(this).prev('.wpforms-myconianhotel-select-clear').show();
                    // Fix still invalid bug
                    if ($(this).val()) {
                        $(this).next('.wpforms-error').remove();
                    }
                    
	        	});
        	}

            if ( $selectPositions.length && $selectHotels.length) {
                $('.wpforms-form').on('click', '.wpforms-myconianhotel-select-clear', function(){
                    console.log($(this).next('select').val());
                    $(this).next('select').val('');
                    $selectPositions.find('option').removeAttr('disabled');
                    $selectHotels.find('option').removeAttr('disabled');
                    $(this).hide();
                })
            }

            // Fetch posts
        	async function fetchCustomPosts($select, postType, acfField=null) {
			    try {
			        const baseUrl = '<?php echo get_site_url(); ?>'; // Get the base URL dynamically
			        const apiUrl = `${baseUrl}/wp-json/wp/v2/${postType}`; // Construct the API endpoint
			        const response = await fetch(apiUrl);

			        if (!response.ok) {
			            throw new Error(`HTTP error! Status: ${response.status}`);
			        }

			        const data = await response.json();
			        
        			$select.html('');
			        data.forEach(post => {
                        if ('position' == postType && theSlug === post.slug) {
                            selectedPosition.slug = post.slug;
                            selectedPosition.value = decodeHTMLEntities(post.title.rendered);
                        }

                        $select.append(
                        `<option  data-id="${post.id}" ` + ( acfField ? `data-${acfField}="${post.acf[acfField] ? post.acf[acfField][0] : ''}" ` : '' ) + `value="${post.title.rendered}">${post.title.rendered}</option>`
                        )
                    });


                    if ('position' == postType) {
                        if (! selectedPosition.slug) {
                            $select.val('');
                        } else {
                            $select.val(selectedPosition.value);
                            $select.attr('disabled', true);                            
                            $select.trigger('change');                        
                        }
                    }

                    if ('hotel' == postType) {
                        $select.val('');
                    }

                    if ( $selectPositions.length && $selectHotels.length && ! selectedPosition.value && ! isSingular) {
                        $select.before('<button class="mh-icon-close wpforms-myconianhotel-select-clear" style="display:none;"></button>');
                    }

                    $select.closest('.wpforms-field').removeClass('is-loading');

			    } catch (error) {
			        console.error('Error fetching custom post type:', error);
			    }
			}

            function decodeHTMLEntities(str) {
                const textArea = document.createElement("textarea");
                textArea.innerHTML = str;
                return textArea.value;
            }

        })(jQuery);

        <?php // Custom input type number ?>

        (function($){
            // Init
            $('.wpforms-field-number').append('<div class="wpforms-field-number-dec" >-</div><div class="wpforms-field-number-inc">+</div><div class="wpforms-field-unit"></div>');
            $('.wpforms-field-number').each(function() {
                const $input = $(this).find('input');

                $(this).attr("class").split(' ').find(function(className) {
                    let value = 0;
                    value = className.split('-');
                    if (undefined !== value[1] && value[1]) {
                        if (className.startsWith('min-')) {
                            $input.attr('min', value[1]);

                            if (value[1] == $input.val()) {
                                //$input.siblings('.wpforms-field-number-dec').attr('disabled', true);
                            }
                        }
                        if (className.startsWith('max-')) {
                            $input.attr('max', value[1]);

                            if (value[1] == $input.val()) {
                                //$input.siblings('.wpforms-field-number-inc').attr('disabled', true);
                            }
                        }
                        if (className.startsWith('step-')) {
                            $input.attr('step', value[1]);
                        }
                        if (className.startsWith('unit-')) {
                            $input.attr('data-mh-input-unit', value[1]);
                            if ('e' == $input.data('mh-input-unit')) {
                                $input.attr('data-mh-input-unit', '€');
                            }
                            $input.siblings('.wpforms-field-unit').text($input.attr('data-mh-input-unit'))
                        }
                    }                    
                });
            });

            // Min max validation
            $( '.wpforms-field-number input' ).on('input', function() {
                if ($(this).val() > parseInt($(this).attr('max'))) {
                    $(this).val($(this).attr('max'));
                }
                if ($(this).val() < parseInt($(this).attr('min'))) {
                    $(this).val($(this).attr('min'));
                }
            });

            // Events
            $( '.wpforms-field-number-inc, .wpforms-field-number-dec' ).on('click', function() {
                let val = parseInt($(this).siblings('input').val());
                const max = $(this).siblings('input').attr('max');
                const min = $(this).siblings('input').attr('min');
                const step = parseInt($(this).siblings('input').attr('step') ?? 1);

                if ($(this).is('.wpforms-field-number-inc')) {
                    if (val < max || undefined == max) {
                        $(this).siblings('input').val(val+step);
                    }
                } else {
                    if (val > min || undefined == min) {
                        $(this).siblings('input').val(val-step);
                    } 
                }

                val = $(this).siblings('input').val();
                
                /*if (undefined != max && val < max) {
                    $('.wpforms-field-number-inc').removeAttr('disabled');                    
                } else if (undefined != max && val > max) {
                    $('.wpforms-field-number-inc').attr('disabled', true);
                }
                if (undefined != min && val > min) {
                    $('.wpforms-field-number-dec').removeAttr('disabled');                    
                } else if (undefined != min && val > min) {
                    $('.wpforms-field-number-dec').attr('disabled', true);                
                }*/
            });
        })(jQuery);
    </script>
    <?php
}
