<?php

/**
 * WP init actions
 *  Register the 'medium_large' size
 * 
 * WP after set up theme actions
 *  Post thumbnails
 *  Update medium_large core image size
 *  Menus
 *  Custom logo
 *  Title tag
 *  Blocks actions
 * 
 * Head scripts
 *  Preload fonts
 * 
 * Update medium_large core image size
 * 
 */

/**
 * WP init actions
 */
add_action( 'init', 'theme_init' );
function theme_init() {
    // Register the 'medium_large' size
    add_filter( 'image_size_names_choose', 'theme_add_image_size_to_editor' );
}

/**
 * WP after set up theme actions
 */
add_action( 'after_setup_theme', 'theme_after_setup_theme' );
function theme_after_setup_theme() {
    // Post thumbnails
    add_theme_support( 'post-thumbnails' );
    // Update medium_large core image size
    theme_update_medium_large_image_size();
    // Menus
    //require_once __DIR__ . '/inc/walker.php';
    register_nav_menu( 'header', 'Header' );
    register_nav_menu( 'header-external', 'Header External' );
    register_nav_menu( 'header-extras', 'Header Extras' );
    register_nav_menu( 'footer-bottom-left', 'Footer bottom left' );
    register_nav_menu( 'footer-bottom-right', 'Footer bottom right' );
    // Custom logo
    add_theme_support( 'custom-logo' );
    // Title tag
    add_theme_support( 'title-tag' );
    // Blocks actions
    theme_blocks_after_setup_theme();
}

/**
 * Head scripts
 *  Preload fonts
 */
//add_action( 'wp_head', 'theme_preload_fonts' );
function theme_preload_fonts() {
    ?>
    <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/RelativePro/relative-medium-pro.woff" as="font" type="font/woff" crossorigin="anonymous">
    <?php
}