<?php

/**
 * Allow users with the role editor or administrator to edit and delete the privacy policy page
 */
//add_action( 'map_meta_cap', 'theme_manage_privacy_options', 1, 4 );
function theme_manage_privacy_options( $caps, $cap, $user_id, $args ) {
  if ( !is_user_logged_in() ) return $caps;

  $user_meta = get_userdata( $user_id );
  if ( array_intersect( ['editor', 'administrator'], $user_meta->roles ) ) {
    if ( 'manage_privacy_options' === $cap ) {
      $manage_name = is_multisite() ? 'manage_network' : 'manage_options';
      $caps = array_diff( $caps, [ $manage_name ] );
    }
  }
  return $caps;
}


/**
 * Plugin Name: Redirection Access for SEO Manager
 * Description: Grants Redirection access to the wpseo_manager role without manage_options.
 */

add_action('init', function() {
    $role = get_role('wpseo_manager');
        
    if ($role && ! $role->has_cap('redirection_full_access')) {
        $role->add_cap('redirection_full_access');
    }

    $role = get_role('administrator');
        
    if ($role && ! $role->has_cap('redirection_full_access')) {
        $role->add_cap('redirection_full_access');
    }
});

add_filter('redirection_role', function() {
    return 'redirection_full_access';
});